/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriterFactory;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    SAMFileHeader samFileHeader;
    int recordsPerSlice = 10000;
    boolean preserveReadNames = true;
    long globalRecordCounter = 0L;
    boolean AP_delta = true;

    public ContainerFactory(SAMFileHeader samFileHeader, int recordsPerSlice) {
        this.samFileHeader = samFileHeader;
        this.recordsPerSlice = recordsPerSlice;
    }

    public Container buildContainer(List<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException, IOException {
        return this.buildContainer(records, null);
    }

    public Container buildContainer(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) throws IllegalArgumentException, IllegalAccessException, IOException {
        long time1 = System.nanoTime();
        CompressionHeader h2 = new CompressionHeaderFactory().build(records, substitutionMatrix);
        h2.AP_seriesDelta = this.AP_delta;
        long time2 = System.nanoTime();
        h2.readNamesIncluded = this.preserveReadNames;
        h2.AP_seriesDelta = true;
        ArrayList<Slice> slices = new ArrayList<Slice>();
        Container c2 = new Container();
        c2.h = h2;
        c2.nofRecords = records.size();
        c2.globalRecordCounter = this.globalRecordCounter;
        c2.bases = 0L;
        c2.blockCount = 0;
        long time3 = System.nanoTime();
        long lastGlobalRecordCounter = c2.globalRecordCounter;
        for (int i2 = 0; i2 < records.size(); i2 += this.recordsPerSlice) {
            List<CramCompressionRecord> sliceRecords = records.subList(i2, Math.min(records.size(), i2 + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(sliceRecords, h2, this.samFileHeader);
            slice.globalRecordCounter = lastGlobalRecordCounter;
            lastGlobalRecordCounter += (long)slice.nofRecords;
            c2.bases += slice.bases;
            slices.add(slice);
            if (c2.sequenceId != -1 || slice.sequenceId == -1) continue;
            c2.sequenceId = slice.sequenceId;
        }
        long time4 = System.nanoTime();
        c2.slices = slices.toArray(new Slice[slices.size()]);
        ContainerFactory.calculateAlignmentBoundaries(c2);
        c2.buildHeaderTime = time2 - time1;
        c2.buildSlicesTime = time4 - time3;
        this.globalRecordCounter += (long)records.size();
        return c2;
    }

    private static void calculateAlignmentBoundaries(Container c2) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Slice s2 : c2.slices) {
            if (s2.sequenceId == -1) continue;
            start = Math.min(start, s2.alignmentStart);
            end = Math.max(end, s2.alignmentStart + s2.alignmentSpan);
        }
        if (start < Integer.MAX_VALUE) {
            c2.alignmentStart = start;
            c2.alignmentSpan = end - start;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> records, CompressionHeader h2, SAMFileHeader fileHeader) throws IllegalArgumentException, IllegalAccessException, IOException {
        HashMap<Integer, ExposedByteArrayOutputStream> map = new HashMap<Integer, ExposedByteArrayOutputStream>();
        for (int id : h2.externalIds) {
            map.put(id, new ExposedByteArrayOutputStream());
        }
        DataWriterFactory f2 = new DataWriterFactory();
        ExposedByteArrayOutputStream bitBAOS = new ExposedByteArrayOutputStream();
        DefaultBitOutputStream bos = new DefaultBitOutputStream(bitBAOS);
        Slice slice = new Slice();
        slice.nofRecords = records.size();
        slice.sequenceId = -1;
        int minAlStart = Integer.MAX_VALUE;
        int maxAlEnd = 0;
        for (CramCompressionRecord r2 : records) {
            slice.bases += (long)r2.readLength;
            if (slice.sequenceId == -2 || r2.alignmentStart == 0 || r2.sequenceId == -1) continue;
            switch (slice.sequenceId) {
                case -1: {
                    slice.sequenceId = r2.sequenceId;
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    if (slice.sequenceId == r2.sequenceId) break;
                    slice.sequenceId = -1;
                }
            }
            minAlStart = Math.min(r2.alignmentStart, minAlStart);
            maxAlEnd = Math.max(r2.getAlignmentEnd(), maxAlEnd);
        }
        if (slice.sequenceId == -2 || minAlStart == Integer.MAX_VALUE) {
            slice.alignmentStart = 0;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = minAlStart;
            slice.alignmentSpan = maxAlEnd - minAlStart + 1;
        }
        Writer writer = f2.buildWriter(bos, map, h2, slice.sequenceId);
        int prevAlStart = slice.alignmentStart;
        for (CramCompressionRecord r2 : records) {
            r2.alignmentDelta = r2.alignmentStart - prevAlStart;
            prevAlStart = r2.alignmentStart;
            writer.write(r2);
        }
        slice.contentType = slice.alignmentSpan > -1 ? BlockContentType.MAPPED_SLICE : BlockContentType.RESERVED;
        bos.close();
        slice.coreBlock = new Block();
        slice.coreBlock.method = BlockCompressionMethod.RAW;
        slice.coreBlock.setRawContent(bitBAOS.toByteArray());
        slice.coreBlock.contentType = BlockContentType.CORE;
        slice.external = new HashMap<Integer, Block>();
        for (Integer i2 : map.keySet()) {
            ExposedByteArrayOutputStream os = (ExposedByteArrayOutputStream)map.get(i2);
            Block externalBlock = new Block();
            externalBlock.contentType = BlockContentType.EXTERNAL;
            externalBlock.method = BlockCompressionMethod.GZIP;
            externalBlock.contentId = i2;
            externalBlock.setRawContent(os.toByteArray());
            slice.external.put(i2, externalBlock);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }
}

