/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final Charset charset = Charset.forName("US-ASCII");
    private static Log log = Log.getInstance(CompressionHeaderFactory.class);
    private static final int oqz = ReadTag.nameType3BytesToInt("OQ", 'Z');
    private static final int bqz = ReadTag.nameType3BytesToInt("OQ", 'Z');

    public CompressionHeader build(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix) {
        CompressionHeader h2 = new CompressionHeader();
        h2.externalIds = new ArrayList<Integer>();
        int exCounter = 0;
        int baseID = exCounter++;
        h2.externalIds.add(baseID);
        int qualityScoreID = exCounter++;
        h2.externalIds.add(qualityScoreID);
        int readNameID = exCounter++;
        h2.externalIds.add(readNameID);
        int mateInfoID = exCounter++;
        h2.externalIds.add(mateInfoID);
        int tagValueExtID = exCounter++;
        h2.externalIds.add(tagValueExtID);
        log.debug("Assigned external id to bases: " + baseID);
        log.debug("Assigned external id to quality scores: " + qualityScoreID);
        log.debug("Assigned external id to read names: " + readNameID);
        log.debug("Assigned external id to mate info: " + mateInfoID);
        log.debug("Assigned external id to tag values: " + tagValueExtID);
        h2.eMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey key : EncodingKey.values()) {
            h2.eMap.put(key, NullEncoding.toParam());
        }
        h2.tMap = new TreeMap<Integer, EncodingParams>();
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.BF_BitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.CF_CompressionBitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.RI_RefId, -2, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.RL_ReadLength, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.AP_AlignmentPositionOffset, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(h2, EncodingKey.RG_ReadGroup, -1, records);
        Object calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r2 : records) {
            ((HuffmanParamsCalculator)calculator).add(r2.readName.length());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.RN_ReadName, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()), ExternalByteArrayEncoding.toParam(readNameID)));
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(EncodingKey.NF_RecordsToNextFragment.name(), 0);
        for (CramCompressionRecord r3 : records) {
            if (!r3.isHasMateDownStream()) continue;
            calc.addValue(r3.recordsToNextFragment);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        h2.eMap.put(EncodingKey.NF_RecordsToNextFragment, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r4 : records) {
            ((HuffmanParamsCalculator)calculator).add(r4.tags == null ? 0 : r4.tags.length);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.TC_TagCount, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r5 : records) {
            if (r5.tags == null) continue;
            for (ReadTag tag : r5.tags) {
                ((HuffmanParamsCalculator)calculator).add(tag.keyType3BytesAsInt);
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.TN_TagNameAndType, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag o1, ReadTag o2) {
                return o1.keyType3BytesAsInt - o2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> baComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length - o2.length != 0) {
                    return o1.length - o2.length;
                }
                for (int i2 = 0; i2 < o1.length; ++i2) {
                    if (o1[i2] == o2[i2]) continue;
                    return o1[i2] - o2[i2];
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> map = new TreeMap<byte[], MutableInt>(baComparator);
        MutableInt noTagCounter = new MutableInt();
        map.put(new byte[0], noTagCounter);
        for (CramCompressionRecord r6 : records) {
            if (r6.tags == null) {
                ++noTagCounter.value;
                r6.tagIdsIndex = noTagCounter;
                continue;
            }
            Arrays.sort(r6.tags, comparator);
            r6.tagIds = new byte[r6.tags.length * 3];
            int tagIndex = 0;
            for (int i2 = 0; i2 < r6.tags.length; ++i2) {
                r6.tagIds[i2 * 3] = (byte)r6.tags[tagIndex].keyType3Bytes.charAt(0);
                r6.tagIds[i2 * 3 + 1] = (byte)r6.tags[tagIndex].keyType3Bytes.charAt(1);
                r6.tagIds[i2 * 3 + 2] = (byte)r6.tags[tagIndex].keyType3Bytes.charAt(2);
                ++tagIndex;
            }
            MutableInt count = (MutableInt)map.get(r6.tagIds);
            if (count == null) {
                count = new MutableInt();
                map.put(r6.tagIds, count);
            }
            ++count.value;
            r6.tagIdsIndex = count;
        }
        byte[][][] dic = new byte[map.size()][][];
        int i3 = 0;
        HuffmanParamsCalculator calculator2 = new HuffmanParamsCalculator();
        for (byte[] idsAsBytes : map.keySet()) {
            int nofIds = idsAsBytes.length / 3;
            dic[i3] = new byte[nofIds][];
            int j2 = 0;
            while (j2 < idsAsBytes.length) {
                int idIndex = j2 / 3;
                dic[i3][idIndex] = new byte[3];
                dic[i3][idIndex][0] = idsAsBytes[j2++];
                dic[i3][idIndex][1] = idsAsBytes[j2++];
                dic[i3][idIndex][2] = idsAsBytes[j2++];
            }
            calculator2.add(i3, ((MutableInt)map.get((Object)idsAsBytes)).value);
            ((MutableInt)map.get((Object)idsAsBytes)).value = i3++;
        }
        calculator2.calculate();
        h2.eMap.put(EncodingKey.TL_TagIdList, HuffmanIntegerEncoding.toParam(calculator2.values(), calculator2.bitLens()));
        h2.dictionary = dic;
        TreeMap<Integer, HuffmanParamsCalculator> cc = new TreeMap<Integer, HuffmanParamsCalculator>();
        for (CramCompressionRecord r7 : records) {
            if (r7.tags == null) continue;
            for (ReadTag tag : r7.tags) {
                switch (tag.keyType3BytesAsInt) {
                    default: 
                }
                HuffmanParamsCalculator c2 = (HuffmanParamsCalculator)cc.get(tag.keyType3BytesAsInt);
                if (c2 == null) {
                    c2 = new HuffmanParamsCalculator();
                    cc.put(tag.keyType3BytesAsInt, c2);
                }
                c2.add(tag.getValueAsByteArray().length);
            }
        }
        if (!cc.isEmpty()) {
            for (Integer key : cc.keySet()) {
                HuffmanParamsCalculator c3 = (HuffmanParamsCalculator)cc.get(key);
                c3.calculate();
                h2.tMap.put(key, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(c3.values(), c3.bitLens()), ExternalByteArrayEncoding.toParam(tagValueExtID)));
            }
        }
        for (Integer key : h2.tMap.keySet()) {
            log.debug(String.format("TAG ENCODING: %d, %s", key, h2.tMap.get(key)));
        }
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            ((HuffmanParamsCalculator)calculator).add(r7.readFeatures == null ? 0 : r7.readFeatures.size());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.FN_NumberOfReadFeatures, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        calc = new IntegerEncodingCalculator("read feature position", 0);
        for (CramCompressionRecord r7 : records) {
            int prevPos = 0;
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                calc.addValue(rf.getPosition() - prevPos);
                prevPos = rf.getPosition();
            }
        }
        bestEncoding = calc.getBestEncoding();
        h2.eMap.put(EncodingKey.FP_FeaturePosition, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                ((HuffmanParamsCalculator)calculator).add(rf.getOperator());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.FC_FeatureCode, HuffmanByteEncoding.toParam(((HuffmanParamsCalculator)calculator).valuesAsBytes(), ((HuffmanParamsCalculator)calculator).bitLens));
        h2.eMap.put(EncodingKey.BA_Base, ExternalByteEncoding.toParam(baseID));
        h2.eMap.put(EncodingKey.QS_QualityScore, ExternalByteEncoding.toParam(qualityScoreID));
        if (substitutionMatrix == null) {
            long[][] freqs = new long[200][200];
            for (CramCompressionRecord r7 : records) {
                if (r7.readFeatures == null) continue;
                for (ReadFeature rf : r7.readFeatures) {
                    if (rf.getOperator() != 88) continue;
                    Substitution s2 = (Substitution)rf;
                    byte refBase = s2.getRefernceBase();
                    byte base = s2.getBase();
                    long[] lArray = freqs[refBase];
                    byte by = base;
                    lArray[by] = lArray[by] + 1L;
                }
            }
            h2.substitutionMatrix = new SubstitutionMatrix(freqs);
        } else {
            h2.substitutionMatrix = substitutionMatrix;
        }
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                if (rf.getOperator() != 88) continue;
                Substitution s3 = (Substitution)rf;
                if (s3.getCode() == -1) {
                    byte refBase = s3.getRefernceBase();
                    byte base = s3.getBase();
                    s3.setCode(h2.substitutionMatrix.code(refBase, base));
                }
                ((HuffmanParamsCalculator)calculator).add(s3.getCode());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.BS_BaseSubstitutionCode, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        h2.eMap.put(EncodingKey.IN_Insertion, ByteArrayStopEncoding.toParam((byte)0, baseID));
        h2.eMap.put(EncodingKey.SC_SoftClip, ByteArrayStopEncoding.toParam((byte)0, baseID));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                if (rf.getOperator() != 68) continue;
                ((HuffmanParamsCalculator)calculator).add(((Deletion)rf).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.DL_DeletionLength, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new IntegerEncodingCalculator(EncodingKey.HC_HardClip.name(), 1);
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                if (rf.getOperator() != 72) continue;
                ((IntegerEncodingCalculator)calculator).addValue(((HardClip)rf).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator).getBestEncoding();
        h2.eMap.put(EncodingKey.HC_HardClip, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new IntegerEncodingCalculator(EncodingKey.PD_padding.name(), 1);
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                if (rf.getOperator() != 80) continue;
                ((IntegerEncodingCalculator)calculator).addValue(((Padding)rf).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator).getBestEncoding();
        h2.eMap.put(EncodingKey.PD_padding, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (r7.readFeatures == null) continue;
            for (ReadFeature rf : r7.readFeatures) {
                if (rf.getOperator() != 78) continue;
                ((HuffmanParamsCalculator)calculator).add(((RefSkip)rf).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.RS_RefSkip, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (r7.isSegmentUnmapped()) continue;
            ((HuffmanParamsCalculator)calculator).add(r7.mappingQuality);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.MQ_MappingQualityScore, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            ((HuffmanParamsCalculator)calculator).add(r7.getMateFlags());
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        h2.eMap.put(EncodingKey.MF_MateBitFlags, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values, ((HuffmanParamsCalculator)calculator).bitLens));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord r7 : records) {
            if (!r7.isDetached()) continue;
            ((HuffmanParamsCalculator)calculator).add(r7.mateSequenceID);
        }
        ((HuffmanParamsCalculator)calculator).calculate();
        if (((HuffmanParamsCalculator)calculator).values.length == 0) {
            h2.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, NullEncoding.toParam());
        }
        h2.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator).values(), ((HuffmanParamsCalculator)calculator).bitLens()));
        log.debug("NS: " + h2.eMap.get((Object)EncodingKey.NS_NextFragmentReferenceSequenceID));
        h2.eMap.put(EncodingKey.NP_NextFragmentAlignmentStart, ExternalIntegerEncoding.toParam(mateInfoID));
        h2.eMap.put(EncodingKey.TS_InsetSize, ExternalIntegerEncoding.toParam(mateInfoID));
        return h2;
    }

    private static final int getValue(EncodingKey key, CramCompressionRecord r2) {
        switch (key) {
            case AP_AlignmentPositionOffset: {
                return r2.alignmentDelta;
            }
            case BF_BitFlags: {
                return r2.flags;
            }
            case CF_CompressionBitFlags: {
                return r2.compressionFlags;
            }
            case FN_NumberOfReadFeatures: {
                return r2.readFeatures == null ? 0 : r2.readFeatures.size();
            }
            case MF_MateBitFlags: {
                return r2.mateFlags;
            }
            case MQ_MappingQualityScore: {
                return r2.mappingQuality;
            }
            case NF_RecordsToNextFragment: {
                return r2.recordsToNextFragment;
            }
            case NP_NextFragmentAlignmentStart: {
                return r2.mateAlignmentStart;
            }
            case NS_NextFragmentReferenceSequenceID: {
                return r2.mateSequenceID;
            }
            case RG_ReadGroup: {
                return r2.readGroupID;
            }
            case RI_RefId: {
                return r2.sequenceId;
            }
            case RL_ReadLength: {
                return r2.readLength;
            }
            case TC_TagCount: {
                return r2.tags == null ? 0 : r2.tags.length;
            }
        }
        throw new RuntimeException("Unexpected encoding key: " + key.name());
    }

    private static final void getOptimalIntegerEncoding(CompressionHeader h2, EncodingKey key, int minValue, List<CramCompressionRecord> records) {
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(key.name(), minValue);
        for (CramCompressionRecord r2 : records) {
            int value = CompressionHeaderFactory.getValue(key, r2);
            calc.addValue(value);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        h2.eMap.put(key, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
    }

    private static Integer[] autobox(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            newArray[i2] = array[i2];
        }
        return newArray;
    }

    public static class IntegerEncodingCalculator {
        public List<EncodingLengthCalculator> calcs = new ArrayList<EncodingLengthCalculator>();
        private int max = 0;
        private int count = 0;
        private String name;
        private HashMap<Integer, MutableInt> dictionary = new HashMap();
        private int dictionaryThreshold = 100;

        public IntegerEncodingCalculator(String name, int dictionaryThreshold, int minValue) {
            this.name = name;
            this.calcs.add(new EncodingLengthCalculator(new GammaIntegerEncoding(1 - minValue)));
            for (int i2 = 2; i2 < 5; ++i2) {
                this.calcs.add(new EncodingLengthCalculator(new SubexpIntegerEncoding(0 - minValue, i2)));
            }
            this.dictionary = dictionaryThreshold < 1 ? null : new HashMap();
        }

        public IntegerEncodingCalculator(String name, int minValue) {
            this(name, 255, minValue);
        }

        public void addValue(int value) {
            ++this.count;
            if (value > this.max) {
                this.max = value;
            }
            for (EncodingLengthCalculator c2 : this.calcs) {
                c2.add(value);
            }
            if (this.dictionary != null) {
                if (this.dictionary.size() >= this.dictionaryThreshold - 1) {
                    this.dictionary = null;
                } else {
                    MutableInt m2 = this.dictionary.get(value);
                    if (m2 == null) {
                        m2 = new MutableInt();
                        this.dictionary.put(value, m2);
                    }
                    ++m2.value;
                }
            }
        }

        public Encoding<Integer> getBestEncoding() {
            int betaLength;
            if (this.dictionary != null && this.dictionary.size() == 1) {
                int value = this.dictionary.keySet().iterator().next();
                EncodingParams param = HuffmanIntegerEncoding.toParam(new int[]{value}, new int[]{0});
                HuffmanIntegerEncoding he = new HuffmanIntegerEncoding();
                he.fromByteArray(param.params);
                return he;
            }
            EncodingLengthCalculator bestC = this.calcs.get(0);
            for (EncodingLengthCalculator c2 : this.calcs) {
                if (c2.len() >= bestC.len()) continue;
                bestC = c2;
            }
            Encoding bestEncoding = bestC.encoding;
            long bits = bestC.len();
            if (bits > (long)((betaLength = (int)Math.round(Math.log(this.max) / Math.log(2.0) + 0.5)) * this.count)) {
                bestEncoding = new BetaIntegerEncoding(betaLength);
                bits = betaLength * this.count;
            }
            if (this.dictionary != null) {
                HuffmanParamsCalculator c3 = new HuffmanParamsCalculator();
                for (Integer value : this.dictionary.keySet()) {
                    c3.add(value, this.dictionary.get((Object)value).value);
                }
                c3.calculate();
                EncodingParams param = HuffmanIntegerEncoding.toParam(c3.values(), c3.bitLens());
                HuffmanIntegerEncoding he = new HuffmanIntegerEncoding();
                he.fromByteArray(param.params);
                EncodingLengthCalculator lc = new EncodingLengthCalculator(he);
                for (Integer value : this.dictionary.keySet()) {
                    lc.add(value, this.dictionary.get((Object)value).value);
                }
                if (lc.len() < bits) {
                    bestEncoding = he;
                    bits = lc.len();
                }
            }
            byte[] params = bestEncoding.toByteArray();
            params = Arrays.copyOf(params, Math.min(params.length, 20));
            log.debug("Best encoding for " + this.name + ": " + bestEncoding.id().name() + Arrays.toString(params));
            return bestEncoding;
        }
    }

    public static class EncodingLengthCalculator {
        private BitCodec<Integer> codec;
        private Encoding<Integer> encoding;
        private long len;

        public EncodingLengthCalculator(Encoding<Integer> encoding) {
            this.encoding = encoding;
            this.codec = encoding.buildCodec(null, null);
        }

        public void add(int value) {
            this.len += this.codec.numberOfBits(value);
        }

        public void add(int value, int inc) {
            this.len += (long)inc * this.codec.numberOfBits(value);
        }

        public long len() {
            return this.len;
        }
    }

    public static class HuffmanParamsCalculator {
        private HashMap<Integer, MutableInt> countMap = new HashMap();
        private int[] values = new int[0];
        private int[] bitLens = new int[0];

        public void add(int value) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            ++counter.value;
        }

        public void add(Integer value, int inc) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            counter.value += inc;
        }

        public int[] bitLens() {
            return this.bitLens;
        }

        public int[] values() {
            return this.values;
        }

        public Integer[] valuesAsAutoIntegers() {
            Integer[] ivalues = new Integer[this.values.length];
            for (int i2 = 0; i2 < ivalues.length; ++i2) {
                ivalues[i2] = this.values[i2];
            }
            return ivalues;
        }

        public byte[] valuesAsBytes() {
            byte[] bvalues = new byte[this.values.length];
            for (int i2 = 0; i2 < bvalues.length; ++i2) {
                bvalues[i2] = (byte)(0xFF & this.values[i2]);
            }
            return bvalues;
        }

        public Byte[] valuesAsAutoBytes() {
            Byte[] bvalues = new Byte[this.values.length];
            for (int i2 = 0; i2 < bvalues.length; ++i2) {
                bvalues[i2] = (byte)(0xFF & this.values[i2]);
            }
            return bvalues;
        }

        public void calculate() {
            HuffmanTree<Integer> tree = null;
            int size = this.countMap.size();
            int[] freqs = new int[size];
            int[] values = new int[size];
            int i2 = 0;
            for (Integer v2 : this.countMap.keySet()) {
                values[i2] = v2;
                freqs[i2] = this.countMap.get((Object)v2).value;
                ++i2;
            }
            tree = HuffmanCode.buildTree(freqs, CompressionHeaderFactory.autobox(values));
            ArrayList valueList = new ArrayList();
            ArrayList<Integer> lens = new ArrayList<Integer>();
            HuffmanCode.getValuesAndBitLengths(valueList, lens, tree);
            Object[] codes = new BitCode[valueList.size()];
            for (i2 = 0; i2 < valueList.size(); ++i2) {
                codes[i2] = new BitCode((Integer)valueList.get(i2), (Integer)lens.get(i2));
            }
            Arrays.sort(codes);
            this.values = new int[codes.length];
            this.bitLens = new int[codes.length];
            for (i2 = 0; i2 < codes.length; ++i2) {
                Object code = codes[i2];
                this.bitLens[i2] = ((BitCode)code).len;
                this.values[i2] = ((BitCode)code).value;
            }
        }
    }

    private static class BitCode
    implements Comparable<BitCode> {
        int value;
        int len;

        public BitCode(int value, int len) {
            this.value = value;
            this.len = len;
        }

        @Override
        public int compareTo(BitCode o2) {
            int result = this.value - o2.value;
            if (result != 0) {
                return result;
            }
            return this.len - o2.len;
        }
    }
}

