/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

public final class Hash {
    static final long _longHashConstant = 4095L;

    public static final int hashBackward(String s2) {
        int hash = 0;
        for (int i2 = s2.length() - 1; i2 >= 0; --i2) {
            hash = hash * 31 + s2.charAt(i2);
        }
        return hash;
    }

    public static final long hashBackwardLong(String s2) {
        long hash = 0L;
        for (int i2 = s2.length() - 1; i2 >= 0; --i2) {
            hash = hash * 63L + (long)s2.charAt(i2);
        }
        return hash;
    }

    public static final long longHash(String s2) {
        return Hash.longHash(s2, 0, s2.length());
    }

    public static final long longHash(String s2, int start, int end) {
        long hash = 0L;
        while (start < end) {
            hash = 4095L * hash + (long)s2.charAt(start);
            ++start;
        }
        return hash;
    }

    public static final long longLowerHash(String s2) {
        return Hash.longLowerHash(s2, 0, s2.length());
    }

    public static final long longLowerHash(String s2, int start, int end) {
        long hash = 0L;
        while (start < end) {
            hash = 4095L * hash + (long)Character.toLowerCase(s2.charAt(start));
            ++start;
        }
        return hash;
    }

    public static final long longLowerHash(String s2, int start, int end, long hash) {
        while (start < end) {
            hash = 4095L * hash + (long)Character.toLowerCase(s2.charAt(start));
            ++start;
        }
        return hash;
    }

    public static final long longLowerHashAppend(long hash, char c2) {
        return hash * 4095L + (long)Character.toLowerCase(c2);
    }

    public static final long longHashAppend(long hash, char c2) {
        return hash * 4095L + (long)c2;
    }

    public static final int lowerCaseHash(String s2) {
        int h2 = 0;
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            h2 = 31 * h2 + Character.toLowerCase(s2.charAt(i2));
        }
        return h2;
    }

    public static final int lowerCaseHash(String s2, int start, int end) {
        int h2 = 0;
        int len = s2.length();
        for (int i2 = start; i2 < len && i2 < end; ++i2) {
            h2 = 31 * h2 + Character.toLowerCase(s2.charAt(i2));
        }
        return h2;
    }

    public static final int hashCode(CharSequence s2, int start, int end) {
        int h2 = 0;
        int len = s2.length();
        for (int i2 = start; i2 < len && i2 < end; ++i2) {
            h2 = 31 * h2 + s2.charAt(i2);
        }
        return h2;
    }

    public static final int nospaceLowerHash(String s2, int start, int end) {
        int h2 = 0;
        int len = s2.length();
        for (int i2 = start; i2 < len && i2 < end; ++i2) {
            char c2 = s2.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            h2 = 31 * h2 + Character.toLowerCase(c2);
        }
        return h2;
    }

    public static final int lowerCaseSpaceTrimHash(String s2) {
        int len;
        int h2 = 0;
        for (len = s2.length(); len > 1 && Character.isWhitespace(s2.charAt(len - 1)); --len) {
        }
        boolean lastWasSpace = true;
        for (int i2 = 0; i2 < len; ++i2) {
            boolean isSpace = Character.isWhitespace(s2.charAt(i2));
            if (isSpace && lastWasSpace) continue;
            lastWasSpace = isSpace;
            h2 = 31 * h2 + Character.toLowerCase(s2.charAt(i2));
        }
        return h2;
    }

    public static final int lowerCaseSpaceTrimHash(String s2, int start, int end) {
        int len;
        int h2 = 0;
        for (len = s2.length(); len > 1 && Character.isWhitespace(s2.charAt(len - 1)); --len) {
        }
        boolean lastWasSpace = true;
        for (int i2 = start; i2 < len && i2 < end; ++i2) {
            boolean isSpace = Character.isWhitespace(s2.charAt(i2));
            if (isSpace && lastWasSpace) continue;
            lastWasSpace = isSpace;
            h2 = 31 * h2 + Character.toLowerCase(s2.charAt(i2));
        }
        return h2;
    }

    public static final int hashCode(String ... strings) {
        int h2 = 0;
        for (String s2 : strings) {
            int len = s2.length();
            for (int i2 = 0; i2 < len; ++i2) {
                h2 = 31 * h2 + s2.charAt(i2);
            }
        }
        return h2;
    }
}

