/*
 * Copyright (c) 2007-2012 The Broad Institute, Inc.
 * SOFTWARE COPYRIGHT NOTICE
 * This software and its documentation are the copyright of the Broad Institute, Inc. All rights are reserved.
 *
 * This software is supplied without any warranty or guaranteed support whatsoever. The Broad Institute is not responsible for its use, misuse, or functionality.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL),
 * Version 2.1 which is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 */
package org.broad.igv.ui;

import java.beans.*;

import com.jidesoft.dialog.ButtonPanel;
import org.broad.igv.DirectoryManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.data.expression.ProbeToLocusMap;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.AlignmentTrack.ShadeBasesOption;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.legend.ColorMapEditor;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.FontChooser;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CollUtils;

import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author jrobinso
 */
public class PreferencesEditor extends javax.swing.JDialog {

    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = Collections.synchronizedMap(new HashMap<String, String>() {
        @Override
        public String put(String k, String v) {
            String oldValue = prefMgr.get(k);
            if ((v == null && oldValue != null) || !v.equals(oldValue)) {
                return super.put(k, v);
            }
            return v;
        }
    });
    PreferenceManager prefMgr = PreferenceManager.getInstance();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    private static int lastSelectedIndex = 0;
    boolean proxySettingsChanged = false;
    boolean tooltipSettingsChanged = false;
    private File newIGVDirectory;
    private boolean updateCoverageTrack = false;


    public PreferencesEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initValues();

        tabbedPane.setSelectedIndex(lastSelectedIndex);

        // Conditionally remove database panel
        if (!prefMgr.getAsBoolean(PreferenceManager.DB_ENABLED)) {
            int idx = tabbedPane.indexOfTab("Database");
            if (idx > 0) {
                tabbedPane.remove(idx);
            }
        }

        setLocationRelativeTo(parent);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    // Generated using JFormDesigner non-commercial license
    private void initComponents() {
        tabbedPane = new JTabbedPane();
        generalPanel = new JPanel();
        vSpacer7 = new JPanel(null);
        jPanel10 = new JPanel();
        missingDataExplanation = new JLabel();
        showDefaultTrackAttributesCB = new JCheckBox();
        combinePanelsCB = new JCheckBox();
        showAttributesDisplayCheckBox = new JCheckBox();
        searchZoomCB = new JCheckBox();
        label4 = new JLabel();
        geneListFlankingField = new JTextField();
        zoomToFeatureExplanation2 = new JLabel();
        label6 = new JLabel();
        seqResolutionThreshold = new JTextField();
        label10 = new JLabel();
        defaultFontField = new JTextField();
        fontChangeButton = new JButton();
        showRegionBoundariesCB = new JCheckBox();
        label7 = new JLabel();
        backgroundColorPanel = new JPanel();
        resetBackgroundButton = new JButton();
        showMissingDataCB = new JCheckBox();
        label32 = new JLabel();
        textField1 = new JLabel();
        featureVisibilityWindowField = new JTextField();
        zoomToFeatureExplanation3 = new JLabel();
        tracksPanel = new JPanel();
        vSpacer1 = new JPanel(null);
        jLabel5 = new JLabel();
        defaultChartTrackHeightField = new JTextField();
        trackNameAttributeLabel = new JLabel();
        trackNameAttributeField = new JTextField();
        jLabel8 = new JLabel();
        defaultTrackHeightField = new JTextField();
        hSpacer1 = new JPanel(null);
        expandCB = new JCheckBox();
        normalizeCoverageCB = new JCheckBox();
        missingDataExplanation8 = new JLabel();
        expandIconCB = new JCheckBox();
        overlaysPanel = new JPanel();
        jPanel5 = new JPanel();
        jLabel3 = new JLabel();
        overlayAttributeTextField = new JTextField();
        overlayTrackCB = new JCheckBox();
        jLabel2 = new JLabel();
        jLabel4 = new JLabel();
        colorCodeMutationsCB = new JCheckBox();
        chooseMutationColorsButton = new JButton();
        label11 = new JLabel();
        showOrphanedMutationsCB = new JCheckBox();
        label12 = new JLabel();
        chartPanel = new JPanel();
        jPanel4 = new JPanel();
        topBorderCB = new JCheckBox();
        label1 = new JLabel();
        chartDrawTrackNameCB = new JCheckBox();
        bottomBorderCB = new JCheckBox();
        jLabel7 = new JLabel();
        colorBordersCB = new JCheckBox();
        labelYAxisCB = new JCheckBox();
        autoscaleCB = new JCheckBox();
        jLabel9 = new JLabel();
        showDatarangeCB = new JCheckBox();
        panel1 = new JPanel();
        label13 = new JLabel();
        showAllHeatmapFeauresCB = new JCheckBox();
        label14 = new JLabel();
        alignmentPanel = new JPanel();
        vSpacer2 = new JPanel(null);
        jPanel11 = new JPanel();
        jLabel11 = new JLabel();
        samMaxWindowSizeField = new JTextField();
        jLabel12 = new JLabel();
        vSpacer3 = new JPanel(null);
        panel4 = new JPanel();
        downsampleReadsCB = new JCheckBox();
        hSpacer3 = new JPanel(null);
        label23 = new JLabel();
        samDownsampleCountField = new JTextField();
        jLabel13 = new JLabel();
        samSamplingWindowField = new JTextField();
        vSpacer4 = new JPanel(null);
        jPanel12 = new JPanel();
        panel8 = new JPanel();
        panel5 = new JPanel();
        jLabel26 = new JLabel();
        snpThresholdField = new JTextField();
        hSpacer2 = new JPanel(null);
        showCovTrackCB = new JCheckBox();
        samFilterDuplicatesCB = new JCheckBox();
        samFlagUnmappedPairCB = new JCheckBox();
        filterFailedReadsCB = new JCheckBox();
        showSoftClippedCB = new JCheckBox();
        showCenterLineCB = new JCheckBox();
        filterSecondaryAlignmentsCB = new JCheckBox();
        filterSupplementaryAlignmentsCB = new JCheckBox();
        useAlleleQualityCB = new JCheckBox();
        panel13 = new JPanel();
        panel12 = new JPanel();
        jLabel15 = new JLabel();
        mappingQualityThresholdField = new JTextField();
        panel11 = new JPanel();
        samShadeMismatchedBaseCB = new JCheckBox();
        samMinBaseQualityField = new JTextField();
        label2 = new JLabel();
        samMaxBaseQualityField = new JTextField();
        panel9 = new JPanel();
        filterCB = new JCheckBox();
        filterURL = new JTextField();
        panel10 = new JPanel();
        samFlagInsertionsCB = new JCheckBox();
        samFlagInsertionsThresholdField = new JTextField();
        label31 = new JLabel();
        vSpacer5 = new JPanel(null);
        panel3 = new JPanel();
        showJunctionTrackCB = new JCheckBox();
        showJunctionFlankingRegionsCB = new JCheckBox();
        junctionFlankingTextField = new JTextField();
        label15 = new JLabel();
        label16 = new JLabel();
        junctionCoverageTextField = new JTextField();
        vSpacer6 = new JPanel(null);
        panel2 = new JPanel();
        panel19 = new JPanel();
        panel16 = new JPanel();
        label9 = new JLabel();
        jLabel20 = new JLabel();
        insertSizeMinThresholdField = new JTextField();
        jLabel17 = new JLabel();
        insertSizeThresholdField = new JTextField();
        panel15 = new JPanel();
        isizeComputeCB = new JCheckBox();
        jLabel30 = new JLabel();
        insertSizeMinPercentileField = new JTextField();
        jLabel18 = new JLabel();
        insertSizeMaxPercentileField = new JTextField();
        expressionPane = new JPanel();
        jPanel8 = new JPanel();
        panel18 = new JPanel();
        jLabel24 = new JLabel();
        jLabel21 = new JLabel();
        expMapToLociCB = new JRadioButton();
        expMapToGeneCB = new JRadioButton();
        panel17 = new JPanel();
        useProbeMappingCB = new JCheckBox();
        label22 = new JLabel();
        panel14 = new JPanel();
        probeMappingFileTextField = new JTextField();
        probeMappingBrowseButton = new JButton();
        proxyPanel = new JPanel();
        jPanel15 = new JPanel();
        jPanel16 = new JPanel();
        proxyUsernameField = new JTextField();
        jLabel28 = new JLabel();
        authenticateProxyCB = new JCheckBox();
        jLabel29 = new JLabel();
        proxyPasswordField = new JPasswordField();
        jPanel17 = new JPanel();
        proxyHostField = new JTextField();
        proxyPortField = new JTextField();
        jLabel27 = new JLabel();
        jLabel23 = new JLabel();
        useProxyCB = new JCheckBox();
        proxyTypeCB = new JComboBox();
        label27 = new JLabel();
        label3 = new JLabel();
        clearProxySettingsButton = new JButton();
        ionTorrentPanel = new JPanel();
        panel6 = new JPanel();
        hideFirstHP = new JCheckBox();
        binSizeText = new JTextField();
        label28 = new JLabel();
        label29 = new JLabel();
        radioLine = new JRadioButton();
        radioArea = new JRadioButton();
        radioBar = new JRadioButton();
        radioStacked = new JRadioButton();
        panel7 = new JPanel();
        label30 = new JLabel();
        textServer = new JTextField();
        advancedPanel = new JPanel();
        clearGenomeCacheButton = new JButton();
        enablePortCB = new JCheckBox();
        portField = new JTextField();
        jLabel22 = new JLabel();
        genomeUpdateCB = new JCheckBox();
        jLabel6 = new JLabel();
        dataServerURLTextField = new JTextField();
        jLabel1 = new JLabel();
        genomeServerURLTextField = new JTextField();
        editServerPropertiesCB = new JCheckBox();
        jButton1 = new JButton();
        igvDirectoryButton = new JButton();
        igvDirectoryField = new JLabel();
        label21 = new JLabel();
        tooltipOptionsPanel = new JPanel();
        label24 = new JLabel();
        label25 = new JLabel();
        label26 = new JLabel();
        toolTipInitialDelayField = new JTextField();
        tooltipReshowDelayField = new JTextField();
        tooltipDismissDelayField = new JTextField();
        antialiasingCB = new JCheckBox();
        label5 = new JLabel();
        blatURLField = new JTextField();
        dbPanel = new JPanel();
        label20 = new JLabel();
        panel21 = new JPanel();
        label17 = new JLabel();
        label19 = new JLabel();
        dbNameField = new JTextField();
        dbHostField = new JTextField();
        label18 = new JLabel();
        dbPortField = new JTextField();
        okCancelButtonPanel = new ButtonPanel();
        okButton = new JButton();
        cancelButton = new JButton();

        //======== this ========
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout(0, 10));

        //======== tabbedPane ========
        {

            //======== generalPanel ========
            {
                generalPanel.setLayout(new BorderLayout());

                //---- vSpacer7 ----
                vSpacer7.setPreferredSize(new Dimension(10, 20));
                generalPanel.add(vSpacer7, BorderLayout.NORTH);

                //======== jPanel10 ========
                {
                    jPanel10.setBorder(null);
                    jPanel10.setLayout(new GridBagLayout());
                    ((GridBagLayout)jPanel10.getLayout()).columnWidths = new int[] {0, 0, 0, 0, 0, 0, 0, 0, 0};
                    ((GridBagLayout)jPanel10.getLayout()).rowHeights = new int[] {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    ((GridBagLayout)jPanel10.getLayout()).columnWeights = new double[] {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
                    ((GridBagLayout)jPanel10.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};

                    //---- missingDataExplanation ----
                    missingDataExplanation.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation.setText("(NAME, DATA_TYPE, and DATA_FILE).");
                    jPanel10.add(missingDataExplanation, new GridBagConstraints(3, 4, 5, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 0), 0, 0));

                    //---- showDefaultTrackAttributesCB ----
                    showDefaultTrackAttributesCB.setText("Show default track attributes");
                    showDefaultTrackAttributesCB.setToolTipText("Display default track attributes (NAME, DATA_TYPE, and DATA_FILE) in the attribute panel.");
                    showDefaultTrackAttributesCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showDefaultTrackAttributesCBActionPerformed(e);
                        }
                    });
                    jPanel10.add(showDefaultTrackAttributesCB, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- combinePanelsCB ----
                    combinePanelsCB.setText("Display all tracks in a single panel");
                    combinePanelsCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            combinePanelsCBActionPerformed(e);
                        }
                    });
                    jPanel10.add(combinePanelsCB, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- showAttributesDisplayCheckBox ----
                    showAttributesDisplayCheckBox.setText("Show attribute panel");
                    showAttributesDisplayCheckBox.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showAttributesDisplayCheckBoxActionPerformed(e);
                        }
                    });
                    jPanel10.add(showAttributesDisplayCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- searchZoomCB ----
                    searchZoomCB.setText("Zoom to features");
                    searchZoomCB.setToolTipText("This option controls the behavior of feature searchs.  If true, the zoom level is changed as required to size the view to the feature size.  If false the zoom level is unchanged.");
                    searchZoomCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            searchZoomCBActionPerformed(e);
                        }
                    });
                    jPanel10.add(searchZoomCB, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- label4 ----
                    label4.setText("Feature flanking region (bp or %): ");
                    label4.setToolTipText("Added before and after feature locus when zooming to a feature.  Also used when defining panel extents in gene/loci list views.  A negative number is interpreted as a percentage.");
                    jPanel10.add(label4, new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- geneListFlankingField ----
                    geneListFlankingField.setToolTipText("Added before and after feature locus when zooming to a feature.  Also used when defining panel extents in gene/loci list views.  A negative number is interpreted as a percentage.");
                    geneListFlankingField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            geneListFlankingFieldFocusLost(e);
                        }
                    });
                    geneListFlankingField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            geneListFlankingFieldActionPerformed(e);
                        }
                    });
                    jPanel10.add(geneListFlankingField, new GridBagConstraints(4, 7, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- zoomToFeatureExplanation2 ----
                    zoomToFeatureExplanation2.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    zoomToFeatureExplanation2.setText("<html><i>&lt; 0 is interpreted as a percentage.</b>");
                    zoomToFeatureExplanation2.setVerticalAlignment(SwingConstants.TOP);
                    jPanel10.add(zoomToFeatureExplanation2, new GridBagConstraints(7, 7, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL,
                        new Insets(0, 0, 15, 0), 0, 0));

                    //---- label6 ----
                    label6.setText("Sequence resolution threshold (bp/pixel):");
                    jPanel10.add(label6, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- seqResolutionThreshold ----
                    seqResolutionThreshold.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            seqResolutionThresholdFocusLost(e);
                        }
                    });
                    seqResolutionThreshold.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            seqResolutionThresholdActionPerformed(e);
                        }
                    });
                    jPanel10.add(seqResolutionThreshold, new GridBagConstraints(4, 9, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- label10 ----
                    label10.setText("Default font: ");
                    label10.setLabelFor(defaultFontField);
                    jPanel10.add(label10, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- defaultFontField ----
                    defaultFontField.setEditable(false);
                    jPanel10.add(defaultFontField, new GridBagConstraints(1, 10, 5, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- fontChangeButton ----
                    fontChangeButton.setText("Change...");
                    fontChangeButton.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            fontChangeButtonActionPerformed(e);
                        }
                    });
                    jPanel10.add(fontChangeButton, new GridBagConstraints(6, 10, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- showRegionBoundariesCB ----
                    showRegionBoundariesCB.setText("Show region boundaries");
                    showRegionBoundariesCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showRegionBoundariesCBActionPerformed(e);
                        }
                    });
                    jPanel10.add(showRegionBoundariesCB, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- label7 ----
                    label7.setText("Background color click to change): ");
                    jPanel10.add(label7, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //======== backgroundColorPanel ========
                    {
                        backgroundColorPanel.setPreferredSize(new Dimension(20, 20));
                        backgroundColorPanel.setBorder(new BevelBorder(BevelBorder.RAISED));
                        backgroundColorPanel.addMouseListener(new MouseAdapter() {
                            @Override
                            public void mouseClicked(MouseEvent e) {
                                backgroundColorPanelMouseClicked(e);
                            }
                        });
                        backgroundColorPanel.setLayout(null);
                    }
                    jPanel10.add(backgroundColorPanel, new GridBagConstraints(3, 11, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- resetBackgroundButton ----
                    resetBackgroundButton.setText("Reset to default");
                    resetBackgroundButton.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            resetBackgroundButtonActionPerformed(e);
                        }
                    });
                    jPanel10.add(resetBackgroundButton, new GridBagConstraints(5, 11, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- showMissingDataCB ----
                    showMissingDataCB.setText("Distinguish missing data");
                    showMissingDataCB.setToolTipText("Distinguish regions with zero values from regions with  no data on plots (e.g. bar charts).  Regions with no data are indicated with a gray background.");
                    showMissingDataCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showMissingDataCBActionPerformed(e);
                        }
                    });
                    jPanel10.add(showMissingDataCB, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- label32 ----
                    label32.setText("<html><i>Distinguish regions with value of zero from regions with  no data.  ");
                    jPanel10.add(label32, new GridBagConstraints(2, 1, 6, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 0), 0, 0));

                    //---- textField1 ----
                    textField1.setText("Default visibility window (kilobases):");
                    textField1.setToolTipText("A value > 0 will set a default threshold windows size in kilobases above which features from indexed files are not loaded.   The threshold (\"visibility window\") can be overriden explicitly for individual tracks via the track menu.");
                    jPanel10.add(textField1, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- featureVisibilityWindowField ----
                    featureVisibilityWindowField.setToolTipText("A value > 0 will set a default threshold windows size in kilobases above which features from indexed files are not loaded.   The threshold (\"visibility window\") can be overriden explicitly for individual tracks via the track menu.");
                    featureVisibilityWindowField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            featureVisibilityWindowFieldActionPerformed(e);
                        }
                    });
                    featureVisibilityWindowField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            featureVisibilityWindowFieldFocusLost(e);
                        }
                    });
                    jPanel10.add(featureVisibilityWindowField, new GridBagConstraints(4, 8, 3, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 15, 5), 0, 0));

                    //---- zoomToFeatureExplanation3 ----
                    zoomToFeatureExplanation3.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    zoomToFeatureExplanation3.setText("<html><i>&lt; 0 disables visibility window.</b>");
                    zoomToFeatureExplanation3.setVerticalAlignment(SwingConstants.TOP);
                    jPanel10.add(zoomToFeatureExplanation3, new GridBagConstraints(7, 8, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL,
                        new Insets(0, 0, 15, 0), 0, 0));
                }
                generalPanel.add(jPanel10, BorderLayout.CENTER);
            }
            tabbedPane.addTab("General", generalPanel);

            //======== tracksPanel ========
            {
                tracksPanel.setMinimumSize(new Dimension(700, 407));
                tracksPanel.setLayout(new GridBagLayout());
                ((GridBagLayout)tracksPanel.getLayout()).columnWidths = new int[] {0, 0, 0, 0, 0, 0, 0, 0, 0};
                ((GridBagLayout)tracksPanel.getLayout()).rowHeights = new int[] {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                ((GridBagLayout)tracksPanel.getLayout()).columnWeights = new double[] {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
                ((GridBagLayout)tracksPanel.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
                tracksPanel.add(vSpacer1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- jLabel5 ----
                jLabel5.setText("Default Track Height, Charts (Pixels)");
                tracksPanel.add(jLabel5, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- defaultChartTrackHeightField ----
                defaultChartTrackHeightField.setText("40");
                defaultChartTrackHeightField.setMinimumSize(new Dimension(60, 28));
                defaultChartTrackHeightField.setToolTipText("Default height of chart tracks (barcharts, scatterplots, etc)");
                defaultChartTrackHeightField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        defaultChartTrackHeightFieldActionPerformed(e);
                    }
                });
                defaultChartTrackHeightField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        defaultChartTrackHeightFieldFocusLost(e);
                    }
                });
                tracksPanel.add(defaultChartTrackHeightField, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- trackNameAttributeLabel ----
                trackNameAttributeLabel.setText("Track Name Attribute");
                trackNameAttributeLabel.setToolTipText("Name of an attribute to be used to label  tracks.  If provided tracks will be labeled with the corresponding attribute values from the sample information file");
                tracksPanel.add(trackNameAttributeLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- trackNameAttributeField ----
                trackNameAttributeField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        trackNameAttributeFieldActionPerformed(e);
                    }
                });
                trackNameAttributeField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        trackNameAttributeFieldFocusLost(e);
                    }
                });
                tracksPanel.add(trackNameAttributeField, new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- jLabel8 ----
                jLabel8.setText("Default Track Height, Other (Pixels)");
                tracksPanel.add(jLabel8, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- defaultTrackHeightField ----
                defaultTrackHeightField.setText("15");
                defaultTrackHeightField.setMinimumSize(new Dimension(60, 28));
                defaultTrackHeightField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        defaultTrackHeightFieldActionPerformed(e);
                    }
                });
                defaultTrackHeightField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        defaultTrackHeightFieldFocusLost(e);
                    }
                });
                tracksPanel.add(defaultTrackHeightField, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));
                tracksPanel.add(hSpacer1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- expandCB ----
                expandCB.setText("Expand Feature Tracks");
                expandCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        expandCBActionPerformed(e);
                    }
                });
                tracksPanel.add(expandCB, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- normalizeCoverageCB ----
                normalizeCoverageCB.setText("Normalize Coverage Data");
                normalizeCoverageCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        normalizeCoverageCBActionPerformed(e);
                    }
                });
                normalizeCoverageCB.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        normalizeCoverageCBFocusLost(e);
                    }
                });
                tracksPanel.add(normalizeCoverageCB, new GridBagConstraints(2, 7, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));

                //---- missingDataExplanation8 ----
                missingDataExplanation8.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                missingDataExplanation8.setText("<html><i> Applies to coverage tracks computed with igvtools (.tdf files).  If selected coverage values are scaled by (1,000,000 / totalCount),  where totalCount is the total number of features or alignments.");
                missingDataExplanation8.setVerticalAlignment(SwingConstants.TOP);
                tracksPanel.add(missingDataExplanation8, new GridBagConstraints(2, 8, 6, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 0), 0, 0));

                //---- expandIconCB ----
                expandIconCB.setText("Show Expand Icon");
                expandIconCB.setToolTipText("If checked displays an expand/collapse icon on feature tracks.");
                expandIconCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        expandIconCBActionPerformed(e);
                    }
                });
                tracksPanel.add(expandIconCB, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0,
                    GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                    new Insets(0, 0, 15, 10), 0, 0));
            }
            tabbedPane.addTab("Tracks", tracksPanel);

            //======== overlaysPanel ========
            {
                overlaysPanel.setLayout(null);

                //======== jPanel5 ========
                {
                    jPanel5.setLayout(null);

                    //---- jLabel3 ----
                    jLabel3.setText("Linking attribute column:");
                    jPanel5.add(jLabel3);
                    jLabel3.setBounds(new Rectangle(new Point(65, 86), jLabel3.getPreferredSize()));

                    //---- overlayAttributeTextField ----
                    overlayAttributeTextField.setText("LINKING_ID");
                    overlayAttributeTextField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            overlayAttributeTextFieldActionPerformed(e);
                        }
                    });
                    overlayAttributeTextField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            overlayAttributeTextFieldFocusLost(e);
                        }
                    });
                    jPanel5.add(overlayAttributeTextField);
                    overlayAttributeTextField.setBounds(240, 80, 228, overlayAttributeTextField.getPreferredSize().height);

                    //---- overlayTrackCB ----
                    overlayTrackCB.setSelected(true);
                    overlayTrackCB.setText("Overlay mutation tracks");
                    overlayTrackCB.setActionCommand("overlayTracksCB");
                    overlayTrackCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            overlayTrackCBActionPerformed(e);
                        }
                    });
                    jPanel5.add(overlayTrackCB);
                    overlayTrackCB.setBounds(new Rectangle(new Point(6, 51), overlayTrackCB.getPreferredSize()));

                    //---- jLabel2 ----
                    jLabel2.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    jPanel5.add(jLabel2);
                    jLabel2.setBounds(new Rectangle(new Point(6, 6), jLabel2.getPreferredSize()));

                    //---- jLabel4 ----
                    jLabel4.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    jPanel5.add(jLabel4);
                    jLabel4.setBounds(new Rectangle(new Point(6, 12), jLabel4.getPreferredSize()));

                    //---- colorCodeMutationsCB ----
                    colorCodeMutationsCB.setText("Color code mutations");
                    colorCodeMutationsCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            colorMutationsCBActionPerformed(e);
                        }
                    });
                    jPanel5.add(colorCodeMutationsCB);
                    colorCodeMutationsCB.setBounds(new Rectangle(new Point(0, 295), colorCodeMutationsCB.getPreferredSize()));

                    //---- chooseMutationColorsButton ----
                    chooseMutationColorsButton.setText("Choose colors");
                    chooseMutationColorsButton.setFont(UIManager.getFont("Button.font"));
                    chooseMutationColorsButton.setVerticalTextPosition(SwingConstants.BOTTOM);
                    chooseMutationColorsButton.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            chooseMutationColorsButtonActionPerformed(e);
                        }
                    });
                    jPanel5.add(chooseMutationColorsButton);
                    chooseMutationColorsButton.setBounds(new Rectangle(new Point(185, 292), chooseMutationColorsButton.getPreferredSize()));

                    //---- label11 ----
                    label11.setText("<html><i>Name of a sample attribute column to link mutation and data tracks");
                    label11.setVerticalAlignment(SwingConstants.TOP);
                    jPanel5.add(label11);
                    label11.setBounds(110, 115, 360, 50);

                    //---- showOrphanedMutationsCB ----
                    showOrphanedMutationsCB.setText("Show orphaned mutation tracks");
                    showOrphanedMutationsCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showOrphanedMutationsCBActionPerformed(e);
                        }
                    });
                    jPanel5.add(showOrphanedMutationsCB);
                    showOrphanedMutationsCB.setBounds(new Rectangle(new Point(70, 180), showOrphanedMutationsCB.getPreferredSize()));

                    //---- label12 ----
                    label12.setText("<html><i>Select to show mutation tracks with no corresponding data track.");
                    label12.setVerticalAlignment(SwingConstants.TOP);
                    jPanel5.add(label12);
                    label12.setBounds(110, 210, 360, 55);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < jPanel5.getComponentCount(); i++) {
                            Rectangle bounds = jPanel5.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = jPanel5.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        jPanel5.setMinimumSize(preferredSize);
                        jPanel5.setPreferredSize(preferredSize);
                    }
                }
                overlaysPanel.add(jPanel5);
                jPanel5.setBounds(28, 55, 673, 394);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < overlaysPanel.getComponentCount(); i++) {
                        Rectangle bounds = overlaysPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = overlaysPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    overlaysPanel.setMinimumSize(preferredSize);
                    overlaysPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Mutations", overlaysPanel);

            //======== chartPanel ========
            {
                chartPanel.setLayout(null);

                //======== jPanel4 ========
                {
                    jPanel4.setBorder(LineBorder.createBlackLineBorder());
                    jPanel4.setLayout(null);

                    //---- topBorderCB ----
                    topBorderCB.setText("Draw Top Border");
                    topBorderCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            topBorderCBActionPerformed(e);
                            topBorderCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(topBorderCB);
                    topBorderCB.setBounds(new Rectangle(new Point(30, 36), topBorderCB.getPreferredSize()));

                    //---- label1 ----
                    label1.setFont(label1.getFont());
                    label1.setText("<html><b>Default settings for barcharts and scatterplots:");
                    jPanel4.add(label1);
                    label1.setBounds(10, 10, 380, 25);

                    //---- chartDrawTrackNameCB ----
                    chartDrawTrackNameCB.setText("Draw Track Label");
                    chartDrawTrackNameCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            chartDrawTrackNameCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(chartDrawTrackNameCB);
                    chartDrawTrackNameCB.setBounds(new Rectangle(new Point(30, 126), chartDrawTrackNameCB.getPreferredSize()));

                    //---- bottomBorderCB ----
                    bottomBorderCB.setText("Draw Bottom Border");
                    bottomBorderCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            bottomBorderCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(bottomBorderCB);
                    bottomBorderCB.setBounds(new Rectangle(new Point(30, 66), bottomBorderCB.getPreferredSize()));

                    //---- jLabel7 ----
                    jLabel7.setText("<html><i>Dynamically rescale to the range of the data in view.");
                    jPanel4.add(jLabel7);
                    jLabel7.setBounds(220, 170, 371, 50);

                    //---- colorBordersCB ----
                    colorBordersCB.setText("Color Borders");
                    colorBordersCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            colorBordersCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(colorBordersCB);
                    colorBordersCB.setBounds(new Rectangle(new Point(30, 96), colorBordersCB.getPreferredSize()));

                    //---- labelYAxisCB ----
                    labelYAxisCB.setText("Label Y Axis");
                    labelYAxisCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            labelYAxisCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(labelYAxisCB);
                    labelYAxisCB.setBounds(new Rectangle(new Point(30, 156), labelYAxisCB.getPreferredSize()));

                    //---- autoscaleCB ----
                    autoscaleCB.setText("Continuous Autoscale");
                    autoscaleCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            autoscaleCBActionPerformed(e);
                        }
                    });
                    jPanel4.add(autoscaleCB);
                    autoscaleCB.setBounds(new Rectangle(new Point(30, 186), autoscaleCB.getPreferredSize()));

                    //---- jLabel9 ----
                    jLabel9.setText("<html><i>Draw a label centered over the track. ");
                    jPanel4.add(jLabel9);
                    jLabel9.setBounds(220, 159, 355, jLabel9.getPreferredSize().height);

                    //---- showDatarangeCB ----
                    showDatarangeCB.setText("Show Data Range");
                    showDatarangeCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showDatarangeCBActionPerformed(e);
                        }
                    });
                    showDatarangeCB.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            showDatarangeCBFocusLost(e);
                        }
                    });
                    jPanel4.add(showDatarangeCB);
                    showDatarangeCB.setBounds(30, 216, showDatarangeCB.getPreferredSize().width, 26);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < jPanel4.getComponentCount(); i++) {
                            Rectangle bounds = jPanel4.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = jPanel4.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        jPanel4.setMinimumSize(preferredSize);
                        jPanel4.setPreferredSize(preferredSize);
                    }
                }
                chartPanel.add(jPanel4);
                jPanel4.setBounds(20, 20, 650, 290);

                //======== panel1 ========
                {
                    panel1.setBorder(LineBorder.createBlackLineBorder());
                    panel1.setLayout(null);

                    //---- label13 ----
                    label13.setText("<html><b>Default settings for heatmaps:");
                    panel1.add(label13);
                    label13.setBounds(10, 5, 250, 30);

                    //---- showAllHeatmapFeauresCB ----
                    showAllHeatmapFeauresCB.setText("Show all features");
                    showAllHeatmapFeauresCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showAllHeatmapFeauresCBActionPerformed(e);
                        }
                    });
                    panel1.add(showAllHeatmapFeauresCB);
                    showAllHeatmapFeauresCB.setBounds(new Rectangle(new Point(20, 45), showAllHeatmapFeauresCB.getPreferredSize()));

                    //---- label14 ----
                    label14.setText("<html><i>Paint all features/segments with a minimum width of 1 pixel.   If not checked features/segments with screen widths less than 1 pixel are not drawn.");
                    panel1.add(label14);
                    label14.setBounds(200, 35, 425, 60);
                }
                chartPanel.add(panel1);
                panel1.setBounds(20, 340, 650, 135);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < chartPanel.getComponentCount(); i++) {
                        Rectangle bounds = chartPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = chartPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    chartPanel.setMinimumSize(preferredSize);
                    chartPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Charts", chartPanel);

            //======== alignmentPanel ========
            {
                alignmentPanel.setLayout(new BoxLayout(alignmentPanel, BoxLayout.Y_AXIS));

                //---- vSpacer2 ----
                vSpacer2.setPreferredSize(new Dimension(10, 20));
                alignmentPanel.add(vSpacer2);

                //======== jPanel11 ========
                {
                    jPanel11.setBorder(new TitledBorder(""));
                    jPanel11.setLayout(new FlowLayout(FlowLayout.LEFT));

                    //---- jLabel11 ----
                    jLabel11.setText("Visibility range threshold (kb):");
                    jLabel11.setPreferredSize(new Dimension(250, 16));
                    jPanel11.add(jLabel11);

                    //---- samMaxWindowSizeField ----
                    samMaxWindowSizeField.setText("jTextField1");
                    samMaxWindowSizeField.setPreferredSize(new Dimension(80, 28));
                    samMaxWindowSizeField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            samMaxWindowSizeFieldActionPerformed(e);
                        }
                    });
                    samMaxWindowSizeField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            samMaxWindowSizeFieldFocusLost(e);
                        }
                    });
                    jPanel11.add(samMaxWindowSizeField);

                    //---- jLabel12 ----
                    jLabel12.setText("<html><i>Range at which alignments become visible");
                    jPanel11.add(jLabel12);
                }
                alignmentPanel.add(jPanel11);

                //---- vSpacer3 ----
                vSpacer3.setPreferredSize(new Dimension(10, 20));
                alignmentPanel.add(vSpacer3);

                //======== panel4 ========
                {
                    panel4.setBorder(new TitledBorder(""));
                    panel4.setLayout(new FlowLayout(FlowLayout.LEFT));

                    //---- downsampleReadsCB ----
                    downsampleReadsCB.setText("Downsample reads");
                    downsampleReadsCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            downsampleReadsCBActionPerformed(e);
                        }
                    });
                    panel4.add(downsampleReadsCB);
                    panel4.add(hSpacer3);

                    //---- label23 ----
                    label23.setText("Max read count:");
                    panel4.add(label23);

                    //---- samDownsampleCountField ----
                    samDownsampleCountField.setPreferredSize(new Dimension(100, 28));
                    samDownsampleCountField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            samDownsampleCountFieldActionPerformed(e);
                        }
                    });
                    samDownsampleCountField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            samDownsampleCountFieldFocusLost(e);
                        }
                    });
                    panel4.add(samDownsampleCountField);

                    //---- jLabel13 ----
                    jLabel13.setText("per window size (bases):");
                    panel4.add(jLabel13);

                    //---- samSamplingWindowField ----
                    samSamplingWindowField.setText("jTextField1");
                    samSamplingWindowField.setPreferredSize(new Dimension(100, 28));
                    samSamplingWindowField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            samSamplingWindowFieldActionPerformed(e);
                        }
                    });
                    samSamplingWindowField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            samSamplingWindowFieldFocusLost(e);
                        }
                    });
                    panel4.add(samSamplingWindowField);
                }
                alignmentPanel.add(panel4);

                //---- vSpacer4 ----
                vSpacer4.setPreferredSize(new Dimension(10, 20));
                alignmentPanel.add(vSpacer4);

                //======== jPanel12 ========
                {
                    jPanel12.setBorder(new TitledBorder("Filter and shading options"));
                    jPanel12.setLayout(new BoxLayout(jPanel12, BoxLayout.Y_AXIS));

                    //======== panel8 ========
                    {
                        panel8.setLayout(new GridLayout(5, 1));

                        //======== panel5 ========
                        {
                            panel5.setLayout(new FlowLayout());

                            //---- jLabel26 ----
                            jLabel26.setText("Coverage allele-fraction threshold:");
                            panel5.add(jLabel26);

                            //---- snpThresholdField ----
                            snpThresholdField.setText("0");
                            snpThresholdField.setPreferredSize(new Dimension(60, 28));
                            snpThresholdField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    snpThresholdFieldActionPerformed(e);
                                }
                            });
                            snpThresholdField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    snpThresholdFieldFocusLost(e);
                                }
                            });
                            panel5.add(snpThresholdField);

                            //---- hSpacer2 ----
                            hSpacer2.setPreferredSize(new Dimension(50, 10));
                            panel5.add(hSpacer2);
                        }
                        panel8.add(panel5);

                        //---- showCovTrackCB ----
                        showCovTrackCB.setText("Show coverage track");
                        showCovTrackCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                showCovTrackCBActionPerformed(e);
                            }
                        });
                        panel8.add(showCovTrackCB);

                        //---- samFilterDuplicatesCB ----
                        samFilterDuplicatesCB.setText("Filter duplicate reads");
                        samFilterDuplicatesCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                samShowDuplicatesCBActionPerformed(e);
                            }
                        });
                        panel8.add(samFilterDuplicatesCB);

                        //---- samFlagUnmappedPairCB ----
                        samFlagUnmappedPairCB.setText("Flag unmapped pairs");
                        samFlagUnmappedPairCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                samFlagUnmappedPairCBActionPerformed(e);
                            }
                        });
                        panel8.add(samFlagUnmappedPairCB);

                        //---- filterFailedReadsCB ----
                        filterFailedReadsCB.setText("Filter vendor failed reads");
                        filterFailedReadsCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                filterVendorFailedReadsCBActionPerformed(e);
                            }
                        });
                        panel8.add(filterFailedReadsCB);

                        //---- showSoftClippedCB ----
                        showSoftClippedCB.setText("Show soft-clipped bases");
                        showSoftClippedCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                showSoftClippedCBActionPerformed(e);
                            }
                        });
                        panel8.add(showSoftClippedCB);

                        //---- showCenterLineCB ----
                        showCenterLineCB.setText("Show center line");
                        showCenterLineCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                showCenterLineCBActionPerformed(e);
                            }
                        });
                        panel8.add(showCenterLineCB);

                        //---- filterSecondaryAlignmentsCB ----
                        filterSecondaryAlignmentsCB.setText("Filter secondary alignments");
                        filterSecondaryAlignmentsCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                filterSecondaryAlignmentsCBActionPerformed(e);
                            }
                        });
                        panel8.add(filterSecondaryAlignmentsCB);

                        //---- filterSupplementaryAlignmentsCB ----
                        filterSupplementaryAlignmentsCB.setText("Filter supplementary alignments");
                        filterSupplementaryAlignmentsCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                filterSupplementaryAlignmentsCBActionPerformed(e);
                            }
                        });
                        panel8.add(filterSupplementaryAlignmentsCB);

                        //---- useAlleleQualityCB ----
                        useAlleleQualityCB.setText("Quality weight allele fraction");
                        useAlleleQualityCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                useAlleleQualityCBActionPerformed(e);
                            }
                        });
                        panel8.add(useAlleleQualityCB);
                    }
                    jPanel12.add(panel8);

                    //======== panel13 ========
                    {
                        panel13.setLayout(new BoxLayout(panel13, BoxLayout.Y_AXIS));

                        //======== panel12 ========
                        {
                            panel12.setLayout(new FlowLayout(FlowLayout.LEFT));

                            //---- jLabel15 ----
                            jLabel15.setText("Mapping quality threshold:");
                            panel12.add(jLabel15);

                            //---- mappingQualityThresholdField ----
                            mappingQualityThresholdField.setText("0");
                            mappingQualityThresholdField.setPreferredSize(new Dimension(60, 28));
                            mappingQualityThresholdField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    mappingQualityThresholdFieldActionPerformed(e);
                                }
                            });
                            mappingQualityThresholdField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    mappingQualityThresholdFieldFocusLost(e);
                                }
                            });
                            panel12.add(mappingQualityThresholdField);
                        }
                        panel13.add(panel12);

                        //======== panel11 ========
                        {
                            panel11.setLayout(new FlowLayout(FlowLayout.LEFT));

                            //---- samShadeMismatchedBaseCB ----
                            samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality:");
                            samShadeMismatchedBaseCB.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    samShadeMismatchedBaseCBActionPerformed(e);
                                }
                            });
                            panel11.add(samShadeMismatchedBaseCB);

                            //---- samMinBaseQualityField ----
                            samMinBaseQualityField.setText("0");
                            samMinBaseQualityField.setPreferredSize(new Dimension(60, 28));
                            samMinBaseQualityField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    samMinBaseQualityFieldActionPerformed(e);
                                }
                            });
                            samMinBaseQualityField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    samMinBaseQualityFieldFocusLost(e);
                                }
                            });
                            panel11.add(samMinBaseQualityField);

                            //---- label2 ----
                            label2.setText("to");
                            panel11.add(label2);

                            //---- samMaxBaseQualityField ----
                            samMaxBaseQualityField.setText("0");
                            samMaxBaseQualityField.setPreferredSize(new Dimension(60, 28));
                            samMaxBaseQualityField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    samMaxBaseQualityFieldActionPerformed(e);
                                }
                            });
                            samMaxBaseQualityField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    samMaxBaseQualityFieldFocusLost(e);
                                }
                            });
                            panel11.add(samMaxBaseQualityField);
                        }
                        panel13.add(panel11);

                        //======== panel9 ========
                        {
                            panel9.setLayout(new FlowLayout(FlowLayout.LEFT));

                            //---- filterCB ----
                            filterCB.setText("Filter alignments by read group");
                            filterCB.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    filterCBActionPerformed(e);
                                }
                            });
                            panel9.add(filterCB);

                            //---- filterURL ----
                            filterURL.setText("URL or path to filter file");
                            filterURL.setEnabled(false);
                            filterURL.setPreferredSize(new Dimension(500, 28));
                            filterURL.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    filterURLActionPerformed(e);
                                }
                            });
                            filterURL.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    filterURLFocusLost(e);
                                }
                            });
                            panel9.add(filterURL);
                        }
                        panel13.add(panel9);

                        //======== panel10 ========
                        {
                            panel10.setLayout(new FlowLayout(FlowLayout.LEFT));

                            //---- samFlagInsertionsCB ----
                            samFlagInsertionsCB.setText("Flag insertions larger than: ");
                            samFlagInsertionsCB.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    samFlagInsertionsCBActionPerformed(e);
                                }
                            });
                            panel10.add(samFlagInsertionsCB);

                            //---- samFlagInsertionsThresholdField ----
                            samFlagInsertionsThresholdField.setPreferredSize(new Dimension(60, 28));
                            samFlagInsertionsThresholdField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    samFlagInsertionsThresholdFieldActionPerformed(e);
                                }
                            });
                            samFlagInsertionsThresholdField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    samFlagInsertionsThresholdFieldFocusLost(e);
                                }
                            });
                            panel10.add(samFlagInsertionsThresholdField);

                            //---- label31 ----
                            label31.setText("bases");
                            panel10.add(label31);
                        }
                        panel13.add(panel10);
                    }
                    jPanel12.add(panel13);
                }
                alignmentPanel.add(jPanel12);

                //---- vSpacer5 ----
                vSpacer5.setPreferredSize(new Dimension(10, 20));
                alignmentPanel.add(vSpacer5);

                //======== panel3 ========
                {
                    panel3.setBorder(new TitledBorder("Splice Junction Track Options"));
                    panel3.setLayout(new GridBagLayout());
                    ((GridBagLayout)panel3.getLayout()).columnWidths = new int[] {0, 0, 0, 0, 0, 0};
                    ((GridBagLayout)panel3.getLayout()).rowHeights = new int[] {0, 0, 0};
                    ((GridBagLayout)panel3.getLayout()).columnWeights = new double[] {0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
                    ((GridBagLayout)panel3.getLayout()).rowWeights = new double[] {0.0, 0.0, 1.0E-4};

                    //---- showJunctionTrackCB ----
                    showJunctionTrackCB.setText("Show junction track");
                    showJunctionTrackCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showJunctionTrackCBActionPerformed(e);
                        }
                    });
                    panel3.add(showJunctionTrackCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- showJunctionFlankingRegionsCB ----
                    showJunctionFlankingRegionsCB.setText("Show flanking regions");
                    showJunctionFlankingRegionsCB.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showJunctionFlankingRegionsCBActionPerformed(e);
                        }
                    });
                    panel3.add(showJunctionFlankingRegionsCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 0, 5), 0, 0));

                    //---- junctionFlankingTextField ----
                    junctionFlankingTextField.setPreferredSize(new Dimension(80, 28));
                    junctionFlankingTextField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            junctionFlankingTextFieldActionPerformed(e);
                        }
                    });
                    junctionFlankingTextField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            junctionFlankingTextFieldFocusLost(e);
                        }
                    });
                    panel3.add(junctionFlankingTextField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- label15 ----
                    label15.setText("Min flanking width:");
                    panel3.add(label15, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- label16 ----
                    label16.setText("Min junction coverage:");
                    panel3.add(label16, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- junctionCoverageTextField ----
                    junctionCoverageTextField.setPreferredSize(new Dimension(80, 28));
                    junctionCoverageTextField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            junctionCoverageTextFieldActionPerformed(e);
                        }
                    });
                    junctionCoverageTextField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            junctionCoverageTextFieldFocusLost(e);
                        }
                    });
                    panel3.add(junctionCoverageTextField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 0), 0, 0));
                }
                alignmentPanel.add(panel3);

                //---- vSpacer6 ----
                vSpacer6.setPreferredSize(new Dimension(10, 20));
                alignmentPanel.add(vSpacer6);

                //======== panel2 ========
                {
                    panel2.setBorder(new TitledBorder("Insert Size Options"));
                    panel2.setToolTipText("These options control the color coding of paired alignments by inferred insert size.   Base pair values set default values.  If \"compute\" is selected  values are computed from the actual size distribution of each library.");
                    panel2.setLayout(new GridLayout());

                    //======== panel19 ========
                    {
                        panel19.setLayout(new GridLayout());

                        //======== panel16 ========
                        {
                            panel16.setLayout(new GridBagLayout());
                            ((GridBagLayout)panel16.getLayout()).columnWidths = new int[] {0, 0, 0, 0};
                            ((GridBagLayout)panel16.getLayout()).rowHeights = new int[] {0, 0, 0};
                            ((GridBagLayout)panel16.getLayout()).columnWeights = new double[] {0.0, 0.0, 0.0, 1.0E-4};
                            ((GridBagLayout)panel16.getLayout()).rowWeights = new double[] {0.0, 0.0, 1.0E-4};

                            //---- label9 ----
                            label9.setText("Defaults ");
                            panel16.add(label9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 5), 0, 0));

                            //---- jLabel20 ----
                            jLabel20.setText("Minimum (bp):");
                            panel16.add(jLabel20, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 5), 0, 0));

                            //---- insertSizeMinThresholdField ----
                            insertSizeMinThresholdField.setText("0");
                            insertSizeMinThresholdField.setPreferredSize(new Dimension(60, 28));
                            insertSizeMinThresholdField.setMinimumSize(new Dimension(60, 28));
                            insertSizeMinThresholdField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    insertSizeThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                }
                            });
                            insertSizeMinThresholdField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    insertSizeThresholdFieldFocusLost(e);
                                    insertSizeMinThresholdFieldFocusLost(e);
                                }
                            });
                            panel16.add(insertSizeMinThresholdField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 0), 0, 0));

                            //---- jLabel17 ----
                            jLabel17.setText("Maximum (bp):");
                            panel16.add(jLabel17, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 0, 5), 0, 0));

                            //---- insertSizeThresholdField ----
                            insertSizeThresholdField.setText("0");
                            insertSizeThresholdField.setPreferredSize(new Dimension(60, 28));
                            insertSizeThresholdField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    insertSizeThresholdFieldActionPerformed(e);
                                    insertSizeThresholdFieldActionPerformed(e);
                                }
                            });
                            insertSizeThresholdField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    insertSizeThresholdFieldFocusLost(e);
                                }
                            });
                            panel16.add(insertSizeThresholdField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 0, 0), 0, 0));
                        }
                        panel19.add(panel16);

                        //======== panel15 ========
                        {
                            panel15.setLayout(new GridBagLayout());
                            ((GridBagLayout)panel15.getLayout()).columnWidths = new int[] {0, 0, 0, 0};
                            ((GridBagLayout)panel15.getLayout()).rowHeights = new int[] {0, 0, 0};
                            ((GridBagLayout)panel15.getLayout()).columnWeights = new double[] {0.0, 0.0, 0.0, 1.0E-4};
                            ((GridBagLayout)panel15.getLayout()).rowWeights = new double[] {0.0, 0.0, 1.0E-4};

                            //---- isizeComputeCB ----
                            isizeComputeCB.setText("Compute");
                            isizeComputeCB.setToolTipText("Min and max values are computed from the actual size distribution of each library.");
                            isizeComputeCB.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    isizeComputeCBActionPerformed(e);
                                    isizeComputeCBActionPerformed(e);
                                    isizeComputeCBActionPerformed(e);
                                }
                            });
                            panel15.add(isizeComputeCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 5), 0, 0));

                            //---- jLabel30 ----
                            jLabel30.setText("Minimum (percentile):");
                            panel15.add(jLabel30, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 5), 0, 0));

                            //---- insertSizeMinPercentileField ----
                            insertSizeMinPercentileField.setText("0");
                            insertSizeMinPercentileField.setPreferredSize(new Dimension(60, 28));
                            insertSizeMinPercentileField.setMinimumSize(new Dimension(60, 28));
                            insertSizeMinPercentileField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    insertSizeThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                    insertSizeMinThresholdFieldActionPerformed(e);
                                    insertSizeMinPercentileFieldActionPerformed(e);
                                }
                            });
                            insertSizeMinPercentileField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    insertSizeThresholdFieldFocusLost(e);
                                    insertSizeMinThresholdFieldFocusLost(e);
                                    insertSizeMinPercentileFieldFocusLost(e);
                                }
                            });
                            panel15.add(insertSizeMinPercentileField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 5, 0), 0, 0));

                            //---- jLabel18 ----
                            jLabel18.setText("Maximum (percentile):");
                            panel15.add(jLabel18, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 0, 5), 0, 0));

                            //---- insertSizeMaxPercentileField ----
                            insertSizeMaxPercentileField.setText("0");
                            insertSizeMaxPercentileField.setPreferredSize(new Dimension(60, 28));
                            insertSizeMaxPercentileField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    insertSizeThresholdFieldActionPerformed(e);
                                    insertSizeThresholdFieldActionPerformed(e);
                                    insertSizeMaxPercentileFieldActionPerformed(e);
                                }
                            });
                            insertSizeMaxPercentileField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    insertSizeThresholdFieldFocusLost(e);
                                    insertSizeMaxPercentileFieldFocusLost(e);
                                }
                            });
                            panel15.add(insertSizeMaxPercentileField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,
                                GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                                new Insets(0, 0, 0, 0), 0, 0));
                        }
                        panel19.add(panel15);
                    }
                    panel2.add(panel19);
                }
                alignmentPanel.add(panel2);
            }
            tabbedPane.addTab("Alignments", alignmentPanel);

            //======== expressionPane ========
            {
                expressionPane.setLayout(null);

                //======== jPanel8 ========
                {
                    jPanel8.setLayout(null);

                    //======== panel18 ========
                    {
                        panel18.setLayout(new GridBagLayout());
                        ((GridBagLayout)panel18.getLayout()).columnWidths = new int[] {0, 0};
                        ((GridBagLayout)panel18.getLayout()).rowHeights = new int[] {0, 0, 0, 0, 0};
                        ((GridBagLayout)panel18.getLayout()).columnWeights = new double[] {0.0, 1.0E-4};
                        ((GridBagLayout)panel18.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 0.0, 1.0E-4};

                        //---- jLabel24 ----
                        jLabel24.setText("Expression probe mapping options: ");
                        panel18.add(jLabel24, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 15, 0), 0, 0));

                        //---- jLabel21 ----
                        jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");
                        panel18.add(jLabel21, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 15, 0), 0, 0));

                        //---- expMapToLociCB ----
                        expMapToLociCB.setText("<html>Map probes to target loci");
                        expMapToLociCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                expMapToLociCBActionPerformed(e);
                            }
                        });
                        panel18.add(expMapToLociCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 15, 0), 0, 0));

                        //---- expMapToGeneCB ----
                        expMapToGeneCB.setText("Map probes to genes");
                        expMapToGeneCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                expMapToGeneCBActionPerformed(e);
                                expMapToGeneCBActionPerformed(e);
                            }
                        });
                        panel18.add(expMapToGeneCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 0, 0), 0, 0));
                    }
                    jPanel8.add(panel18);
                    panel18.setBounds(new Rectangle(new Point(20, 20), panel18.getPreferredSize()));

                    //======== panel17 ========
                    {
                        panel17.setLayout(new GridLayout(3, 1));

                        //---- useProbeMappingCB ----
                        useProbeMappingCB.setText("Use probe mapping file");
                        useProbeMappingCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                useProbeMappingCBActionPerformed(e);
                            }
                        });
                        panel17.add(useProbeMappingCB);

                        //---- label22 ----
                        label22.setText("<html><i>File path or URL to BED file containing genomic locations of probes:");
                        panel17.add(label22);

                        //======== panel14 ========
                        {
                            panel14.setLayout(null);

                            //---- probeMappingFileTextField ----
                            probeMappingFileTextField.addFocusListener(new FocusAdapter() {
                                @Override
                                public void focusLost(FocusEvent e) {
                                    probeMappingFileTextFieldFocusLost(e);
                                }
                            });
                            probeMappingFileTextField.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    probeMappingFileTextFieldActionPerformed(e);
                                }
                            });
                            panel14.add(probeMappingFileTextField);
                            probeMappingFileTextField.setBounds(0, 0, 581, probeMappingFileTextField.getPreferredSize().height);

                            //---- probeMappingBrowseButton ----
                            probeMappingBrowseButton.setText("Browse");
                            probeMappingBrowseButton.addActionListener(new ActionListener() {
                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    probeMappingBrowseButtonActionPerformed(e);
                                }
                            });
                            panel14.add(probeMappingBrowseButton);
                            probeMappingBrowseButton.setBounds(new Rectangle(new Point(592, 0), probeMappingBrowseButton.getPreferredSize()));

                            { // compute preferred size
                                Dimension preferredSize = new Dimension();
                                for(int i = 0; i < panel14.getComponentCount(); i++) {
                                    Rectangle bounds = panel14.getComponent(i).getBounds();
                                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                                }
                                Insets insets = panel14.getInsets();
                                preferredSize.width += insets.right;
                                preferredSize.height += insets.bottom;
                                panel14.setMinimumSize(preferredSize);
                                panel14.setPreferredSize(preferredSize);
                            }
                        }
                        panel17.add(panel14);
                    }
                    jPanel8.add(panel17);
                    panel17.setBounds(20, 247, 735, panel17.getPreferredSize().height);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < jPanel8.getComponentCount(); i++) {
                            Rectangle bounds = jPanel8.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = jPanel8.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        jPanel8.setMinimumSize(preferredSize);
                        jPanel8.setPreferredSize(preferredSize);
                    }
                }
                expressionPane.add(jPanel8);
                jPanel8.setBounds(10, 30, 755, 470);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < expressionPane.getComponentCount(); i++) {
                        Rectangle bounds = expressionPane.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = expressionPane.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    expressionPane.setMinimumSize(preferredSize);
                    expressionPane.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Probes", expressionPane);

            //======== proxyPanel ========
            {
                proxyPanel.setLayout(new BoxLayout(proxyPanel, BoxLayout.X_AXIS));

                //======== jPanel15 ========
                {
                    jPanel15.setLayout(null);

                    //======== jPanel16 ========
                    {
                        jPanel16.setLayout(new GridBagLayout());
                        ((GridBagLayout)jPanel16.getLayout()).columnWidths = new int[] {0, 0, 0};
                        ((GridBagLayout)jPanel16.getLayout()).rowHeights = new int[] {0, 0, 0, 0};
                        ((GridBagLayout)jPanel16.getLayout()).columnWeights = new double[] {0.0, 0.0, 1.0E-4};
                        ((GridBagLayout)jPanel16.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 1.0E-4};

                        //---- proxyUsernameField ----
                        proxyUsernameField.setText("jTextField1");
                        proxyUsernameField.setEnabled(false);
                        proxyUsernameField.setPreferredSize(new Dimension(500, 28));
                        proxyUsernameField.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                proxyUsernameFieldActionPerformed(e);
                            }
                        });
                        proxyUsernameField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyUsernameFieldFocusLost(e);
                            }
                        });
                        jPanel16.add(proxyUsernameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 0), 0, 0));

                        //---- jLabel28 ----
                        jLabel28.setText("Username:");
                        jPanel16.add(jLabel28, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 5), 0, 0));

                        //---- authenticateProxyCB ----
                        authenticateProxyCB.setText("Authentication required");
                        authenticateProxyCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                authenticateProxyCBActionPerformed(e);
                            }
                        });
                        jPanel16.add(authenticateProxyCB, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 0), 0, 0));

                        //---- jLabel29 ----
                        jLabel29.setText("Password:");
                        jPanel16.add(jLabel29, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 0, 5), 0, 0));

                        //---- proxyPasswordField ----
                        proxyPasswordField.setText("jPasswordField1");
                        proxyPasswordField.setEnabled(false);
                        proxyPasswordField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyPasswordFieldFocusLost(e);
                            }
                        });
                        jPanel16.add(proxyPasswordField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 0, 0), 0, 0));
                    }
                    jPanel15.add(jPanel16);
                    jPanel16.setBounds(20, 315, 741, jPanel16.getPreferredSize().height);

                    //======== jPanel17 ========
                    {
                        jPanel17.setLayout(new GridBagLayout());
                        ((GridBagLayout)jPanel17.getLayout()).columnWidths = new int[] {0, 0, 0};
                        ((GridBagLayout)jPanel17.getLayout()).rowHeights = new int[] {0, 0, 0, 0, 0};
                        ((GridBagLayout)jPanel17.getLayout()).columnWeights = new double[] {0.0, 0.0, 1.0E-4};
                        ((GridBagLayout)jPanel17.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 0.0, 1.0E-4};

                        //---- proxyHostField ----
                        proxyHostField.setText("jTextField1");
                        proxyHostField.setPreferredSize(new Dimension(500, 28));
                        proxyHostField.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                proxyHostFieldActionPerformed(e);
                            }
                        });
                        proxyHostField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyHostFieldFocusLost(e);
                            }
                        });
                        jPanel17.add(proxyHostField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 0), 0, 0));

                        //---- proxyPortField ----
                        proxyPortField.setText("jTextField1");
                        proxyPortField.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                proxyPortFieldActionPerformed(e);
                            }
                        });
                        proxyPortField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyPortFieldFocusLost(e);
                            }
                        });
                        jPanel17.add(proxyPortField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 0), 0, 0));

                        //---- jLabel27 ----
                        jLabel27.setText("Proxy port:");
                        jPanel17.add(jLabel27, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 5), 0, 0));

                        //---- jLabel23 ----
                        jLabel23.setText("Proxy host:");
                        jPanel17.add(jLabel23, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 5), 0, 0));

                        //---- useProxyCB ----
                        useProxyCB.setText("Use proxy");
                        useProxyCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                useProxyCBActionPerformed(e);
                            }
                        });
                        jPanel17.add(useProxyCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 20, 5), 0, 0));

                        //---- proxyTypeCB ----
                        proxyTypeCB.setModel(new DefaultComboBoxModel(new String[] {
                            "HTTP",
                            "SOCKS",
                            "DIRECT"
                        }));
                        proxyTypeCB.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                proxyTypeCBActionPerformed(e);
                            }
                        });
                        jPanel17.add(proxyTypeCB, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 0, 0), 0, 0));

                        //---- label27 ----
                        label27.setText("Proxy type:");
                        jPanel17.add(label27, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
                            GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                            new Insets(0, 0, 0, 5), 0, 0));
                    }
                    jPanel15.add(jPanel17);
                    jPanel17.setBounds(20, 91, 770, 199);

                    //---- label3 ----
                    label3.setText("<html>Note:  do not use these settings unless you receive error or warning messages about server connections.  On most systems the correct settings will be automatically copied from your web browser.");
                    jPanel15.add(label3);
                    label3.setBounds(22, 20, 630, 63);

                    //---- clearProxySettingsButton ----
                    clearProxySettingsButton.setText("Clear All");
                    clearProxySettingsButton.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            clearProxySettingsButtonActionPerformed(e);
                        }
                    });
                    jPanel15.add(clearProxySettingsButton);
                    clearProxySettingsButton.setBounds(new Rectangle(new Point(10, 485), clearProxySettingsButton.getPreferredSize()));

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < jPanel15.getComponentCount(); i++) {
                            Rectangle bounds = jPanel15.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = jPanel15.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        jPanel15.setMinimumSize(preferredSize);
                        jPanel15.setPreferredSize(preferredSize);
                    }
                }
                proxyPanel.add(jPanel15);
            }
            tabbedPane.addTab("Proxy", proxyPanel);

            //======== ionTorrentPanel ========
            {
                ionTorrentPanel.setLayout(new BoxLayout(ionTorrentPanel, BoxLayout.Y_AXIS));

                //======== panel6 ========
                {
                    panel6.setBorder(new TitledBorder("Flow signal distribution chart options"));
                    panel6.setLayout(null);

                    //---- hideFirstHP ----
                    hideFirstHP.setText("skip flow signals for homo polymers at start or end of read (including HP of size 1)");
                    hideFirstHP.setToolTipText("discards flow signals from HP at beginning or end of reads (including HP of size 1), in order to not skew the results due to short reads");
                    hideFirstHP.setSelected(true);
                    hideFirstHP.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            showJunctionTrackCBActionPerformed(e);
                            hideFirstHPActionPerformed(e);
                        }
                    });
                    panel6.add(hideFirstHP);
                    hideFirstHP.setBounds(new Rectangle(new Point(5, 25), hideFirstHP.getPreferredSize()));

                    //---- binSizeText ----
                    binSizeText.setToolTipText("The size of the bins by which the data in the chart is grouped. Small bin size means small granularity, large bin size means smoother chart");
                    binSizeText.setText("15");
                    binSizeText.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            junctionFlankingTextFieldActionPerformed(e);
                            binSizeTextActionPerformed(e);
                            binSizeTextActionPerformed(e);
                        }
                    });
                    binSizeText.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            junctionFlankingTextFieldFocusLost(e);
                            binSizeTextFocusLost(e);
                        }
                    });
                    panel6.add(binSizeText);
                    binSizeText.setBounds(135, 55, 95, 25);

                    //---- label28 ----
                    label28.setText("Bin size in chart:");
                    panel6.add(label28);
                    label28.setBounds(10, 55, 125, label28.getPreferredSize().height);

                    //---- label29 ----
                    label29.setText("Default chart type:");
                    panel6.add(label29);
                    label29.setBounds(new Rectangle(new Point(10, 90), label29.getPreferredSize()));

                    //---- radioLine ----
                    radioLine.setText("line chart");
                    radioLine.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            radioButton1ActionPerformed(e);
                            radioLineActionPerformed(e);
                        }
                    });
                    panel6.add(radioLine);
                    radioLine.setBounds(new Rectangle(new Point(135, 90), radioLine.getPreferredSize()));

                    //---- radioArea ----
                    radioArea.setText("area chart");
                    radioArea.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            radioAreaActionPerformed(e);
                        }
                    });
                    panel6.add(radioArea);
                    radioArea.setBounds(new Rectangle(new Point(135, 115), radioArea.getPreferredSize()));

                    //---- radioBar ----
                    radioBar.setText("bar chart");
                    radioBar.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            radioBarActionPerformed(e);
                        }
                    });
                    panel6.add(radioBar);
                    radioBar.setBounds(new Rectangle(new Point(135, 140), radioBar.getPreferredSize()));

                    //---- radioStacked ----
                    radioStacked.setText("(stacked bar chart)");
                    radioStacked.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            radioStackedActionPerformed(e);
                        }
                    });
                    panel6.add(radioStacked);
                    radioStacked.setBounds(new Rectangle(new Point(135, 165), radioStacked.getPreferredSize()));

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < panel6.getComponentCount(); i++) {
                            Rectangle bounds = panel6.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = panel6.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        panel6.setMinimumSize(preferredSize);
                        panel6.setPreferredSize(preferredSize);
                    }
                }
                ionTorrentPanel.add(panel6);

                //======== panel7 ========
                {
                    panel7.setBorder(new TitledBorder("Server settings"));
                    panel7.setLayout(null);

                    //---- label30 ----
                    label30.setText("Default Ion Torrent Server:");
                    panel7.add(label30);
                    label30.setBounds(new Rectangle(new Point(15, 25), label30.getPreferredSize()));

                    //---- textServer ----
                    textServer.setText("ioneast.ite");
                    textServer.setToolTipText("Used to launch other applications (such as Torrent Scout Light)");
                    textServer.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            textServerActionPerformed(e);
                        }
                    });
                    panel7.add(textServer);
                    textServer.setBounds(220, 20, 475, textServer.getPreferredSize().height);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < panel7.getComponentCount(); i++) {
                            Rectangle bounds = panel7.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = panel7.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        panel7.setMinimumSize(preferredSize);
                        panel7.setPreferredSize(preferredSize);
                    }
                }
                ionTorrentPanel.add(panel7);
            }
            tabbedPane.addTab("IonTorrent", ionTorrentPanel);

            //======== advancedPanel ========
            {
                advancedPanel.setBorder(new EmptyBorder(1, 10, 1, 10));
                advancedPanel.setLayout(null);

                //---- clearGenomeCacheButton ----
                clearGenomeCacheButton.setText("Clear  Genome Cache");
                clearGenomeCacheButton.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        clearGenomeCacheButtonActionPerformed(e);
                    }
                });
                advancedPanel.add(clearGenomeCacheButton);
                clearGenomeCacheButton.setBounds(new Rectangle(new Point(390, 95), clearGenomeCacheButton.getPreferredSize()));

                //---- enablePortCB ----
                enablePortCB.setText("Enable port");
                enablePortCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        enablePortCBActionPerformed(e);
                    }
                });
                advancedPanel.add(enablePortCB);
                enablePortCB.setBounds(new Rectangle(new Point(35, 30), enablePortCB.getPreferredSize()));

                //---- portField ----
                portField.setText("60151");
                portField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        portFieldActionPerformed(e);
                    }
                });
                portField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        portFieldFocusLost(e);
                    }
                });
                advancedPanel.add(portField);
                portField.setBounds(175, 27, 126, portField.getPreferredSize().height);

                //---- jLabel22 ----
                jLabel22.setFont(new Font("Lucida Grande", Font.ITALIC, 13));
                jLabel22.setText("Enable port to send commands and http requests to IGV. ");
                advancedPanel.add(jLabel22);
                jLabel22.setBounds(new Rectangle(new Point(315, 33), jLabel22.getPreferredSize()));

                //---- genomeUpdateCB ----
                genomeUpdateCB.setText("<html>Automatically check for updated genomes.    &nbsp;&nbsp;&nbsp;   <i>Most users should leave this checked.");
                genomeUpdateCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        genomeUpdateCBActionPerformed(e);
                    }
                });
                advancedPanel.add(genomeUpdateCB);
                genomeUpdateCB.setBounds(new Rectangle(new Point(35, 205), genomeUpdateCB.getPreferredSize()));

                //---- jLabel6 ----
                jLabel6.setText("Data Registry URL");
                advancedPanel.add(jLabel6);
                jLabel6.setBounds(new Rectangle(new Point(70, 170), jLabel6.getPreferredSize()));

                //---- dataServerURLTextField ----
                dataServerURLTextField.setEnabled(false);
                dataServerURLTextField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dataServerURLTextFieldActionPerformed(e);
                    }
                });
                dataServerURLTextField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        dataServerURLTextFieldFocusLost(e);
                    }
                });
                advancedPanel.add(dataServerURLTextField);
                dataServerURLTextField.setBounds(225, 165, 494, dataServerURLTextField.getPreferredSize().height);

                //---- jLabel1 ----
                jLabel1.setText("Genome Server URL");
                advancedPanel.add(jLabel1);
                jLabel1.setBounds(new Rectangle(new Point(70, 135), jLabel1.getPreferredSize()));

                //---- genomeServerURLTextField ----
                genomeServerURLTextField.setText("jTextField1");
                genomeServerURLTextField.setEnabled(false);
                genomeServerURLTextField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        genomeServerURLTextFieldActionPerformed(e);
                    }
                });
                genomeServerURLTextField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        genomeServerURLTextFieldFocusLost(e);
                    }
                });
                advancedPanel.add(genomeServerURLTextField);
                genomeServerURLTextField.setBounds(225, 130, 494, genomeServerURLTextField.getPreferredSize().height);

                //---- editServerPropertiesCB ----
                editServerPropertiesCB.setText("Edit server properties");
                editServerPropertiesCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        editServerPropertiesCBActionPerformed(e);
                    }
                });
                advancedPanel.add(editServerPropertiesCB);
                editServerPropertiesCB.setBounds(new Rectangle(new Point(35, 95), editServerPropertiesCB.getPreferredSize()));

                //---- jButton1 ----
                jButton1.setText("Reset to Defaults");
                jButton1.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        jButton1ActionPerformed(e);
                    }
                });
                advancedPanel.add(jButton1);
                jButton1.setBounds(new Rectangle(new Point(225, 95), jButton1.getPreferredSize()));

                //---- igvDirectoryButton ----
                igvDirectoryButton.setText("Move...");
                igvDirectoryButton.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        igvDirectoryButtonActionPerformed(e);
                    }
                });
                advancedPanel.add(igvDirectoryButton);
                igvDirectoryButton.setBounds(615, 510, 100, igvDirectoryButton.getPreferredSize().height);

                //---- igvDirectoryField ----
                igvDirectoryField.setBorder(new BevelBorder(BevelBorder.LOWERED));
                advancedPanel.add(igvDirectoryField);
                igvDirectoryField.setBounds(55, 515, 550, 25);

                //---- label21 ----
                label21.setText("IGV Directory: ");
                advancedPanel.add(label21);
                label21.setBounds(45, 485, 105, label21.getPreferredSize().height);

                //======== tooltipOptionsPanel ========
                {
                    tooltipOptionsPanel.setLayout(null);

                    //---- label24 ----
                    label24.setText("Tooltip initial delay (ms)");
                    tooltipOptionsPanel.add(label24);
                    label24.setBounds(0, 11, 185, label24.getPreferredSize().height);

                    //---- label25 ----
                    label25.setText("Tooltip reshow delay (ms)");
                    tooltipOptionsPanel.add(label25);
                    label25.setBounds(0, 38, 185, 23);

                    //---- label26 ----
                    label26.setText("Tooltip dismiss delay (ms)");
                    tooltipOptionsPanel.add(label26);
                    label26.setBounds(0, 70, 185, 16);

                    //---- toolTipInitialDelayField ----
                    toolTipInitialDelayField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            toolTipInitialDelayFieldActionPerformed(e);
                        }
                    });
                    toolTipInitialDelayField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            toolTipInitialDelayFieldFocusLost(e);
                        }
                    });
                    tooltipOptionsPanel.add(toolTipInitialDelayField);
                    toolTipInitialDelayField.setBounds(220, 5, 455, toolTipInitialDelayField.getPreferredSize().height);

                    //---- tooltipReshowDelayField ----
                    tooltipReshowDelayField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tooltipReshowDelayFieldActionPerformed(e);
                        }
                    });
                    tooltipReshowDelayField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            tooltipReshowDelayFieldFocusLost(e);
                        }
                    });
                    tooltipOptionsPanel.add(tooltipReshowDelayField);
                    tooltipReshowDelayField.setBounds(220, 35, 455, 28);

                    //---- tooltipDismissDelayField ----
                    tooltipDismissDelayField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tooltipDismissDelayFieldActionPerformed(e);
                        }
                    });
                    tooltipDismissDelayField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            tooltipDismissDelayFieldFocusLost(e);
                        }
                    });
                    tooltipOptionsPanel.add(tooltipDismissDelayField);
                    tooltipDismissDelayField.setBounds(220, 64, 455, 28);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < tooltipOptionsPanel.getComponentCount(); i++) {
                            Rectangle bounds = tooltipOptionsPanel.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = tooltipOptionsPanel.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        tooltipOptionsPanel.setMinimumSize(preferredSize);
                        tooltipOptionsPanel.setPreferredSize(preferredSize);
                    }
                }
                advancedPanel.add(tooltipOptionsPanel);
                tooltipOptionsPanel.setBounds(45, 295, tooltipOptionsPanel.getPreferredSize().width, 105);

                //---- antialiasingCB ----
                antialiasingCB.setText("Enable antialiasing");
                antialiasingCB.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        antialiasingCBActionPerformed(e);
                    }
                });
                advancedPanel.add(antialiasingCB);
                antialiasingCB.setBounds(new Rectangle(new Point(35, 250), antialiasingCB.getPreferredSize()));

                //---- label5 ----
                label5.setText("BLAT URL");
                advancedPanel.add(label5);
                label5.setBounds(new Rectangle(new Point(45, 435), label5.getPreferredSize()));

                //---- blatURLField ----
                blatURLField.addFocusListener(new FocusAdapter() {
                    @Override
                    public void focusLost(FocusEvent e) {
                        blatURLFieldFocusLost(e);
                    }
                });
                blatURLField.addActionListener(new ActionListener() {
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        blatURLFieldActionPerformed(e);
                    }
                });
                advancedPanel.add(blatURLField);
                blatURLField.setBounds(139, 430, 580, blatURLField.getPreferredSize().height);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < advancedPanel.getComponentCount(); i++) {
                        Rectangle bounds = advancedPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = advancedPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    advancedPanel.setMinimumSize(preferredSize);
                    advancedPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Advanced", advancedPanel);

            //======== dbPanel ========
            {
                dbPanel.setLayout(null);

                //---- label20 ----
                label20.setText("<html><b>Database configuration  <i>(experimental, subject to change)");
                label20.setFont(new Font("Lucida Grande", Font.PLAIN, 14));
                dbPanel.add(label20);
                label20.setBounds(new Rectangle(new Point(50, 20), label20.getPreferredSize()));

                //======== panel21 ========
                {
                    panel21.setLayout(new GridBagLayout());
                    ((GridBagLayout)panel21.getLayout()).columnWidths = new int[] {0, 0, 0};
                    ((GridBagLayout)panel21.getLayout()).rowHeights = new int[] {0, 0, 0, 0};
                    ((GridBagLayout)panel21.getLayout()).columnWeights = new double[] {0.0, 0.0, 1.0E-4};
                    ((GridBagLayout)panel21.getLayout()).rowWeights = new double[] {0.0, 0.0, 0.0, 1.0E-4};

                    //---- label17 ----
                    label17.setText("Host:");
                    panel21.add(label17, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- label19 ----
                    label19.setText("Name:");
                    panel21.add(label19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 5), 0, 0));

                    //---- dbNameField ----
                    dbNameField.setPreferredSize(new Dimension(500, 28));
                    dbNameField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dbNameFieldActionPerformed(e);
                        }
                    });
                    dbNameField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            dbNameFieldFocusLost(e);
                        }
                    });
                    panel21.add(dbNameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 0), 0, 0));

                    //---- dbHostField ----
                    dbHostField.setPreferredSize(new Dimension(500, 28));
                    dbHostField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dbHostFieldActionPerformed(e);
                        }
                    });
                    dbHostField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            dbHostFieldFocusLost(e);
                        }
                    });
                    panel21.add(dbHostField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 5, 0), 0, 0));

                    //---- label18 ----
                    label18.setText("Port:");
                    panel21.add(label18, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 0, 5), 0, 0));

                    //---- dbPortField ----
                    dbPortField.setPreferredSize(new Dimension(500, 28));
                    dbPortField.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dbPortFieldActionPerformed(e);
                        }
                    });
                    dbPortField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            dbPortFieldFocusLost(e);
                        }
                    });
                    panel21.add(dbPortField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,
                        GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                        new Insets(0, 0, 0, 0), 0, 0));
                }
                dbPanel.add(panel21);
                panel21.setBounds(new Rectangle(new Point(20, 76), panel21.getPreferredSize()));

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < dbPanel.getComponentCount(); i++) {
                        Rectangle bounds = dbPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = dbPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    dbPanel.setMinimumSize(preferredSize);
                    dbPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Database", dbPanel);
        }
        contentPane.add(tabbedPane, BorderLayout.NORTH);

        //======== okCancelButtonPanel ========
        {

            //---- okButton ----
            okButton.setText("OK");
            okButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    okButtonActionPerformed(e);
                }
            });
            okCancelButtonPanel.add(okButton);

            //---- cancelButton ----
            cancelButton.setText("Cancel");
            cancelButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    cancelButtonActionPerformed(e);
                }
            });
            okCancelButtonPanel.add(cancelButton);
        }
        contentPane.add(okCancelButtonPanel, BorderLayout.SOUTH);
        setSize(830, 840);
        setLocationRelativeTo(getOwner());

        //---- buttonGroup1 ----
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(expMapToLociCB);
        buttonGroup1.add(expMapToGeneCB);
        buttonGroup1.add(radioLine);
        buttonGroup1.add(radioArea);
        buttonGroup1.add(radioBar);
        buttonGroup1.add(radioStacked);
    }// </editor-fold>//GEN-END:initComponents

    private void backgroundColorPanelMouseClicked(MouseEvent e) {
        final PreferenceManager prefMgr = PreferenceManager.getInstance();
        Color backgroundColor = UIUtilities.showColorChooserDialog("Choose background color",
                prefMgr.getAsColor(PreferenceManager.BACKGROUND_COLOR));
        if (backgroundColor != null) {
            prefMgr.put(PreferenceManager.BACKGROUND_COLOR, ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            backgroundColorPanel.setBackground(backgroundColor);
        }

    }

    private void extractBinSize() {
        String sbin = this.binSizeText.getText();
        if (sbin != null) {
            sbin = sbin.trim();
            try {
                Integer.parseInt(sbin);
                updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_BINSIZE, sbin);
            } catch (NumberFormatException numberFormatException) {
                inputValidated = false;
                MessageUtils.showMessage(
                        "Bin size must be an integer.");
            }
        }
    }

    private void resetBackgroundButtonActionPerformed(ActionEvent e) {
        final PreferenceManager prefMgr = PreferenceManager.getInstance();
        prefMgr.remove(PreferenceManager.BACKGROUND_COLOR);
        Color backgroundColor = prefMgr.getAsColor(PreferenceManager.BACKGROUND_COLOR);
        if (backgroundColor != null) {
            prefMgr.put(PreferenceManager.BACKGROUND_COLOR, ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            backgroundColorPanel.setBackground(backgroundColor);
        }

    }

    private void binSizeTextActionPerformed(ActionEvent e) {
        extractBinSize();
    }

    private void hideFirstHPActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.IONTORRENT_FLOWDIST_HIDE_FIRST_HP,
                String.valueOf(this.hideFirstHP.isSelected()));
    }

    private void radioButton1ActionPerformed(ActionEvent e) {
        if (this.radioLine.isSelected()) {
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE, "LINE");
        }
    }

    private void radioLineActionPerformed(ActionEvent e) {
        if (this.radioLine.isSelected()) {
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE, "LINE");
        }
    }

    private void radioAreaActionPerformed(ActionEvent e) {
        if (this.radioArea.isSelected()) {
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE, "AREA");
        }
    }

    private void radioBarActionPerformed(ActionEvent e) {
        if (this.radioBar.isSelected()) {
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE, "BAR");
        }
    }


    private void radioStackedActionPerformed(ActionEvent e) {
        if (this.radioStacked.isSelected()) {
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE, "STACKED");
        }
    }

    private void textServerActionPerformed(ActionEvent e) {
        String server = this.textServer.getText();
        if (server != null) {
            server = server.trim();
            updatedPreferenceMap.put(PreferenceManager.IONTORRENT_SERVER, server);
        }
    }

    private void binSizeTextFocusLost(FocusEvent e) {
        extractBinSize();
    }

    private void filterSecondaryAlignmentsCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_FILTER_SECONDARY_ALIGNMENTS,
                String.valueOf(filterSecondaryAlignmentsCB.isSelected()));
    }


    private void filterSupplementaryAlignmentsCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_FILTER_SUPPLEMENTARY_ALIGNMENTS,
                String.valueOf(filterSupplementaryAlignmentsCB.isSelected()));
    }

    private void antialiasingCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.ENABLE_ANTIALISING,
                String.valueOf(antialiasingCB.isSelected()));

    }

    private void showMissingDataCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_MISSING_DATA_KEY, String.valueOf(
                showMissingDataCB.isSelected()));
    }

    private void useAlleleQualityCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SAM_ALLELE_USE_QUALITY, String.valueOf(
                useAlleleQualityCB.isSelected()));
        this.updateCoverageTrack = true;
    }

    private void featureVisibilityWindowFieldActionPerformed(ActionEvent e) {
        boolean valid = false;
        String vw = featureVisibilityWindowField.getText().trim();
        try {
            double val = Double.parseDouble(vw);
            valid = true;
            updatedPreferenceMap.put(PreferenceManager.DEFAULT_VISIBILITY_WINDOW, vw);
        } catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid && e != null) {
            junctionFlankingTextField.setText(prefMgr.get(PreferenceManager.DEFAULT_VISIBILITY_WINDOW));
            MessageUtils.showMessage("Visibility window must be a number");
        }
    }


    private void featureVisibilityWindowFieldFocusLost(FocusEvent e) {
        this.featureVisibilityWindowFieldActionPerformed(null);
    }


    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        canceled = true;
        setVisible(false);
    }

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed

        if (inputValidated) {

            checkForProbeChanges();

            lastSelectedIndex = tabbedPane.getSelectedIndex();

            // Store the changed preferences
            prefMgr.putAll(updatedPreferenceMap);

            if (updatedPreferenceMap.containsKey(PreferenceManager.PORT_ENABLED) ||
                    updatedPreferenceMap.containsKey(PreferenceManager.PORT_NUMBER)) {
                CommandListener.halt();
                if (enablePortCB.isSelected()) {
                    int port = Integer.parseInt(updatedPreferenceMap.get(PreferenceManager.PORT_NUMBER));
                    CommandListener.start(port);
                }
            }

            checkForSAMChanges();

            // Overlays
            if (updateOverlays) {
                IGV.getInstance().resetOverlayTracks();
            }

            // Proxies
            if (proxySettingsChanged) {
                HttpUtils.getInstance().updateProxySettings();
            }

            // IGV directory
            if (newIGVDirectory != null) {
                moveIGVDirectory();

            }

            // Tooltip
            if (tooltipSettingsChanged) {
                Main.updateTooltipSettings();
            }

            updatedPreferenceMap.clear();
            IGV.getInstance().doRefresh();
            setVisible(false);
        } else {
            resetValidation();
        }
    }

    /**
     * Move the IGV directory to a new location.
     */
    private void moveIGVDirectory() {

        // DO this in a swing worker, so we can invoke a wait cursor.  This might take some time.
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>() {
            @Override
            protected Boolean doInBackground() throws Exception {
                setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                return DirectoryManager.moveIGVDirectory(newIGVDirectory);
            }

            @Override
            protected void done() {
                setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            }
        };


        worker.execute();
        try {
            Boolean success = worker.get(30, TimeUnit.SECONDS);
            if (success == Boolean.TRUE) {
                MessageUtils.showMessage("<html>The IGV directory has been successfully moved to: " +
                        newIGVDirectory.getAbsolutePath() +
                        "<br>Some files might need to be manually removed from the previous directory." +
                        "<br/><b><i>It is recommended that you restart IGV.");
            }

        } catch (Exception ex) {
            MessageUtils.showMessage("<html>Unexpected error occurred while moving IGV directory:  " +
                    newIGVDirectory.getAbsolutePath() + " " + ex.getMessage() +
                    "<br/><b><i>It is recommended that you restart IGV.");

        }
    }


    private void fontChangeButtonActionPerformed(ActionEvent e) {
        Font defaultFont = FontManager.getDefaultFont();
        FontChooser chooser = new FontChooser(this, defaultFont);
        chooser.setModal(true);
        chooser.setVisible(true);
        if (!chooser.isCanceled()) {
            Font font = chooser.getSelectedFont();
            if (font != null) {
                prefMgr.put(PreferenceManager.DEFAULT_FONT_FAMILY, font.getFamily());
                prefMgr.put(PreferenceManager.DEFAULT_FONT_SIZE, String.valueOf(font.getSize()));
                int attrs = Font.PLAIN;
                if (font.isBold()) attrs = Font.BOLD;
                if (font.isItalic()) attrs |= Font.ITALIC;
                prefMgr.put(PreferenceManager.DEFAULT_FONT_ATTRIBUTE, String.valueOf(attrs));
                FontManager.updateDefaultFont();
                updateFontField();
                IGV.getInstance().repaint();
            }
        }
    }


    private void expMapToLociCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToLociCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(expMapToGeneCB.isSelected()));
    }

    private void clearGenomeCacheButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearGenomeCacheButtonActionPerformed
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }

    private void editServerPropertiesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editServerPropertiesCBActionPerformed
        boolean edit = editServerPropertiesCB.isSelected();
        dataServerURLTextField.setEnabled(edit);
        genomeServerURLTextField.setEnabled(edit);
    }

    private void dataServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldFocusLost
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }


    private void igvDirectoryButtonActionPerformed(ActionEvent e) {
        final File igvDirectory = DirectoryManager.getIgvDirectory();
        final File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
        if (newDirectory != null && !newDirectory.equals(igvDirectory.getParentFile())) {
            newIGVDirectory = new File(newDirectory, "igv");
            igvDirectoryField.setText(newIGVDirectory.getAbsolutePath());

        }

    }

    private void dataServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldActionPerformed
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }

    private void genomeServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldFocusLost
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SERVER_URL, attributeName);
    }

    private void genomeServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldActionPerformed
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SERVER_URL, attributeName);
    }


    private void blatURLFieldFocusLost(FocusEvent e) {
        String attributeName = blatURLField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.BLAT_URL, attributeName);

    }

    private void blatURLFieldActionPerformed(ActionEvent e) {
       blatURLFieldFocusLost(null);
    }

    private void expandIconCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_EXPAND_ICON, String.valueOf(expandIconCB.isSelected()));

    }

    private void normalizeCoverageCBFocusLost(FocusEvent e) {
        // TODO add your code here
    }


    private void showJunctionTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showCovTrackCBActionPerformed
        final boolean junctionTrackEnabled = showJunctionTrackCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.SAM_SHOW_JUNCTION_TRACK, String.valueOf(junctionTrackEnabled));
        junctionFlankingTextField.setEnabled(junctionTrackEnabled);
        junctionCoverageTextField.setEnabled(junctionTrackEnabled);
        showJunctionFlankingRegionsCB.setEnabled(junctionTrackEnabled);
    }

    private void showJunctionFlankingRegionsCBActionPerformed(java.awt.event.ActionEvent evt) {
        final boolean junctionFlankingRegionsEnabled = showJunctionFlankingRegionsCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.SAM_SHOW_JUNCTION_FLANKINGREGIONS,
                String.valueOf(junctionFlankingRegionsEnabled));
    }

    private void junctionFlankingTextFieldFocusLost(FocusEvent e) {
        junctionFlankingTextFieldActionPerformed(null);
    }

    private void junctionFlankingTextFieldActionPerformed(ActionEvent e) {
        boolean valid = false;
        String flankingWidth = junctionFlankingTextField.getText().trim();
        try {
            int val = Integer.parseInt(flankingWidth);
            if (val >= 0) {
                valid = true;
                updatedPreferenceMap.put(PreferenceManager.SAM_JUNCTION_MIN_FLANKING_WIDTH, flankingWidth);
            }

        } catch (NumberFormatException numberFormatException) {
        }
        if (!valid && e != null) {
            junctionFlankingTextField.setText(prefMgr.get(PreferenceManager.SAM_JUNCTION_MIN_FLANKING_WIDTH));
            MessageUtils.showMessage("Flanking width must be a positive integer.");
        }
    }

    private void junctionCoverageTextFieldActionPerformed(ActionEvent e) {
        junctionCoverageTextFieldFocusLost(null);
    }

    private void junctionCoverageTextFieldFocusLost(FocusEvent e) {
        boolean valid = false;
        String minCoverage = junctionCoverageTextField.getText().trim();
        try {
            int val = Integer.parseInt(minCoverage);
            if (val >= 0) {
                valid = true;
                updatedPreferenceMap.put(PreferenceManager.SAM_JUNCTION_MIN_COVERAGE, minCoverage);
            }
        } catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid && e != null) {
            junctionCoverageTextField.setText(prefMgr.get(PreferenceManager.SAM_JUNCTION_MIN_COVERAGE));
            MessageUtils.showMessage("Minimum junction coverage must be a positive integer.");

        }
    }


    private void insertSizeThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {
        this.insertSizeThresholdFieldActionPerformed(null);
    }

    private void insertSizeThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String insertThreshold = insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAM_MAX_INSERT_SIZE_THRESHOLD, insertThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void insertSizeMinThresholdFieldFocusLost(FocusEvent e) {
        insertSizeMinThresholdFieldActionPerformed(null);
    }

    private void insertSizeMinThresholdFieldActionPerformed(ActionEvent e) {
        String insertThreshold = insertSizeMinThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAM_MIN_INSERT_SIZE_THRESHOLD, insertThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }


    private void mappingQualityThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {
        mappingQualityThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_mappingQualityThresholdFieldFocusLost

    private void mappingQualityThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String qualityThreshold = mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAM_QUALITY_THRESHOLD, qualityThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage(
                    "BlastMapping quality threshold must be an integer.");
        }
    }

    private void samFlagInsertionsCBActionPerformed(ActionEvent e) {
        final boolean flagInsertions = samFlagInsertionsCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.SAM_FLAG_LARGE_INSERTIONS, String.valueOf(flagInsertions));
        samFlagInsertionsThresholdField.setEnabled(flagInsertions);
    }


    private void samFlagInsertionsThresholdFieldActionPerformed(ActionEvent e) {
        String insertionThreshold = samFlagInsertionsThresholdField.getText().trim();
        try {
            int tmp = Integer.parseInt(insertionThreshold);
            if (tmp <= 0) {
                inputValidated = false;
                MessageUtils.showMessage("Insertion threshold must be a positive integer.");
            } else {
                updatedPreferenceMap.put(PreferenceManager.SAM_LARGE_INSERTIONS_THRESHOLD, insertionThreshold);
            }
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Insertion threshold must be a positive integer.");
        }
    }

    private void samFlagInsertionsThresholdFieldFocusLost(FocusEvent e) {
        samFlagInsertionsThresholdFieldActionPerformed(null);
    }

    private void downsampleReadsCBActionPerformed(ActionEvent e) {
        final boolean downsample = downsampleReadsCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.SAM_DOWNSAMPLE_READS, String.valueOf(downsample));
        samSamplingWindowField.setEnabled(downsample);
        samDownsampleCountField.setEnabled(downsample);
    }

    private void samSamplingWindowFieldFocusLost(FocusEvent e) {
        samSamplingWindowFieldActionPerformed(null);
    }

    private void samSamplingWindowFieldActionPerformed(ActionEvent e) {
        String samplingWindowString = samSamplingWindowField.getText().trim();
        try {
            int samplingWindow = Integer.parseInt(samplingWindowString);
            if (samplingWindow <= 0) {
                inputValidated = false;
                MessageUtils.showMessage("Down-sampling window must be a positive integer.");
            } else {
                updatedPreferenceMap.put(PreferenceManager.SAM_SAMPLING_WINDOW, samplingWindowString);
            }
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Down-sampling window  must be a positive integer.");
        }
    }


    private void samDownsampleCountFieldFocusLost(java.awt.event.FocusEvent evt) {
        samDownsampleCountFieldActionPerformed(null);
    }

    private void samDownsampleCountFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String maxLevelString = samDownsampleCountField.getText().trim();
        try {
            int maxLevel = Integer.parseInt(maxLevelString);
            if (maxLevel <= 0) {
                inputValidated = false;
                MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
            } else {
                updatedPreferenceMap.put(PreferenceManager.SAM_SAMPLING_COUNT, maxLevelString);
            }
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
        }
    }

    private void samShadeMismatchedBaseCBActionPerformed(java.awt.event.ActionEvent evt) {
        if (samShadeMismatchedBaseCB.isSelected()) {
            updatedPreferenceMap.put(
                    PreferenceManager.SAM_SHADE_BASES,
                    ShadeBasesOption.QUALITY.toString());
            samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
            samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        } else {
            PreferenceManager prefMgr = PreferenceManager.getInstance();
            if (ShadeBasesOption.QUALITY ==
                    CollUtils.valueOf(ShadeBasesOption.class, prefMgr.get(PreferenceManager.SAM_SHADE_BASES), ShadeBasesOption.QUALITY)) {
                updatedPreferenceMap.put(
                        PreferenceManager.SAM_SHADE_BASES,
                        ShadeBasesOption.NONE.toString());
                samMinBaseQualityField.setEnabled(false);
                samMaxBaseQualityField.setEnabled(false);
            }
        }
    }

    private void showCenterLineCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_SHOW_CENTER_LINE,
                String.valueOf(showCenterLineCB.isSelected()));

    }

    private void genomeUpdateCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.AUTO_UPDATE_GENOMES,
                String.valueOf(this.genomeUpdateCB.isSelected()));
    }


    private void samFlagUnmappedPairCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_FLAG_UNMAPPED_PAIR,
                String.valueOf(samFlagUnmappedPairCB.isSelected()));
    }

    private void samShowDuplicatesCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_SHOW_DUPLICATES,
                String.valueOf(!samFilterDuplicatesCB.isSelected()));
    }

    private void showSoftClippedCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_SHOW_SOFT_CLIPPED,
                String.valueOf(showSoftClippedCB.isSelected()));
    }


    private void isizeComputeCBActionPerformed(ActionEvent e) {
        final boolean selected = isizeComputeCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.SAM_COMPUTE_ISIZES, String.valueOf(selected));
        insertSizeThresholdField.setEnabled(!selected);
        insertSizeMinThresholdField.setEnabled(!selected);
        insertSizeMinPercentileField.setEnabled(selected);
        insertSizeMaxPercentileField.setEnabled(selected);
    }

    public void selectTab(String tabname) {
        if (tabname == null) return;
        for (int i = 0; i < tabbedPane.getTabCount(); i++) {
            if (tabbedPane.getTitleAt(i).equalsIgnoreCase(tabname)) {
                tabbedPane.setSelectedIndex(i);
                return;
            }
        }
    }

    private void insertSizeMinPercentileFieldFocusLost(FocusEvent e) {
        insertSizeMinPercentileFieldActionPerformed(null);
    }

    private void insertSizeMinPercentileFieldActionPerformed(ActionEvent e) {
        String valueString = insertSizeMinPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            updatedPreferenceMap.put(PreferenceManager.SAM_MIN_INSERT_SIZE_PERCENTILE, valueString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Minimum insert size percentile must be a number.");
        }
    }


    private void insertSizeMaxPercentileFieldFocusLost(FocusEvent e) {
        insertSizeMaxPercentileFieldActionPerformed(null);
    }

    private void insertSizeMaxPercentileFieldActionPerformed(ActionEvent e) {
        String valueString = insertSizeMaxPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            updatedPreferenceMap.put(PreferenceManager.SAM_MAX_INSERT_SIZE_PERCENTILE, valueString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Maximum insert size percentile must be a number.");
        }
    }


    private void samMaxWindowSizeFieldFocusLost(java.awt.event.FocusEvent evt) {
        samMaxWindowSizeFieldActionPerformed(null);
    }

    private void samMaxWindowSizeFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String maxSAMWindowSize = String.valueOf(samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAM_MAX_VISIBLE_RANGE, maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }


    private void seqResolutionThresholdActionPerformed(ActionEvent e) {
        samMaxWindowSizeFieldFocusLost(null);
    }

    private void seqResolutionThresholdFocusLost(FocusEvent e) {
        String seqResolutionSize = String.valueOf(seqResolutionThreshold.getText());
        try {
            float value = Float.parseFloat(seqResolutionSize.replace(",", ""));
            if (value < 1 || value > 10000) {
                MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
            } else {
                updatedPreferenceMap.put(PreferenceManager.MAX_SEQUENCE_RESOLUTION, seqResolutionSize);
            }
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
        }

    }


    private void chartDrawTrackNameCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.CHART_DRAW_TRACK_NAME,
                String.valueOf(chartDrawTrackNameCB.isSelected()));
    }

    private void autoscaleCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.CHART_AUTOSCALE, String.valueOf(autoscaleCB.isSelected()));
    }


    private void colorBordersCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(
                PreferenceManager.CHART_COLOR_BORDERS,
                String.valueOf(colorBordersCB.isSelected()));
    }

    private void bottomBorderCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(
                PreferenceManager.CHART_DRAW_BOTTOM_BORDER,
                String.valueOf(bottomBorderCB.isSelected()));
    }

    private void topBorderCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(
                PreferenceManager.CHART_DRAW_TOP_BORDER,
                String.valueOf(topBorderCB.isSelected()));
    }

    private void showAllHeatmapFeauresCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.CHART_SHOW_ALL_HEATMAP,
                String.valueOf(showAllHeatmapFeauresCB.isSelected()));
    }


    private void chooseMutationColorsButtonActionPerformed(ActionEvent e) {
        PaletteColorTable ct = PreferenceManager.getInstance().getMutationColorScheme();
        ColorMapEditor editor = new ColorMapEditor(IGV.getMainFrame(), ct.getColorMap());
        editor.setVisible(true);

        Map<String, Color> changedColors = editor.getChangedColors();
        if (!changedColors.isEmpty()) {
            for (Map.Entry<String, Color> entry : changedColors.entrySet()) {
                ct.getColorMap().put(entry.getKey(), entry.getValue());
            }
            String mapString = ct.getMapAsString();
            PreferenceManager.getInstance().put(PreferenceManager.MUTATION_COLOR_TABLE, mapString);
        }
    }


    private void colorMutationsCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.COLOR_MUTATIONS, String.valueOf(
                colorCodeMutationsCB.isSelected()));
    }

    private void showOrphanedMutationsCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_ORPHANED_MUTATIONS, String.valueOf(
                showOrphanedMutationsCB.isSelected()));
    }

    private void overlayTrackCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_MUTATION_TRACKS, String.valueOf(
                overlayTrackCB.isSelected()));
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        showOrphanedMutationsCB.setEnabled(overlayTrackCB.isSelected());
        updateOverlays = true;
    }//GEN-LAST:event_overlayTrackCBActionPerformed


    private void overlayAttributeTextFieldFocusLost(java.awt.event.FocusEvent evt) {
        String attributeName = String.valueOf(overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, attributeName);
        updateOverlays = true;
    }//GEN-LAST:event_overlayAttributeTextFieldFocusLost

    private void overlayAttributeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, String.valueOf(
                overlayAttributeTextField.getText()));
        updateOverlays = true;
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldActionPerformed

    private void defaultTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldFocusLost

    private void defaultTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }


    private void trackNameAttributeFieldFocusLost(java.awt.event.FocusEvent evt) {
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }

    private void trackNameAttributeFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }

    private void defaultChartTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {
        defaultChartTrackHeightFieldActionPerformed(null);
    }

    private void defaultChartTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }


    private void geneListFlankingFieldFocusLost(FocusEvent e) {
        geneListFlankingFieldActionPerformed(null);
    }


    private void geneListFlankingFieldActionPerformed(ActionEvent e) {
        String flankingRegion = String.valueOf(geneListFlankingField.getText());
        try {
            Integer.parseInt(flankingRegion);
            updatedPreferenceMap.put(PreferenceManager.FLANKING_REGION, flankingRegion);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Flanking region must be an integer number.");
        }

    }


    private void showAttributesDisplayCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {
        boolean state = ((JCheckBox) evt.getSource()).isSelected();
        updatedPreferenceMap.put(PreferenceManager.SHOW_ATTRIBUTE_VIEWS_KEY, String.valueOf(state));
        IGV.getInstance().doShowAttributeDisplay(state);
    }

    private void combinePanelsCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_SINGLE_TRACK_PANE_KEY, String.valueOf(
                combinePanelsCB.isSelected()));
    }

    private void showDefaultTrackAttributesCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_DEFAULT_TRACK_ATTRIBUTES, String.valueOf(
                showDefaultTrackAttributesCB.isSelected()));
    }


    private void showRegionBoundariesCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_REGION_BARS, String.valueOf(
                showRegionBoundariesCB.isSelected()));
    }

    private void filterVendorFailedReadsCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAM_FILTER_FAILED_READS,
                String.valueOf(filterFailedReadsCB.isSelected()));
    }


    private void samMinBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String baseQuality = samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAM_BASE_QUALITY_MIN, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }//GEN-LAST:event_samMinBaseQualityFieldActionPerformed

    private void samMinBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {
        samMinBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMinBaseQualityFieldFocusLost

    private void samMaxBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String baseQuality = samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAM_BASE_QUALITY_MAX, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }

    }//GEN-LAST:event_samMaxBaseQualityFieldActionPerformed

    private void samMaxBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldFocusLost
        samMaxBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxBaseQualityFieldFocusLost

    private void expMapToGeneCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToGeneCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(expMapToGeneCB.isSelected()));

    }//GEN-LAST:event_expMapToGeneCBActionPerformed

    private void labelYAxisCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_labelYAxisCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.CHART_DRAW_Y_AXIS, String.valueOf(labelYAxisCB.isSelected()));
    }


    private void showCovTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showCovTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAM_SHOW_COV_TRACK, String.valueOf(showCovTrackCB.isSelected()));
    }

    private void filterCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAM_FILTER_ALIGNMENTS, String.valueOf(filterCB.isSelected()));
        filterURL.setEnabled(filterCB.isSelected());
    }

    private void filterURLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterURLActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAM_FILTER_URL,
                String.valueOf(filterURL.getText()));

    }

    private void filterURLFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_filterURLFocusLost
        filterURLActionPerformed(null);
    }

    private void portFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_portFieldActionPerformed
        String portString = portField.getText().trim();
        try {
            Integer.parseInt(portString);
            updatedPreferenceMap.put(PreferenceManager.PORT_NUMBER, portString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Port must be an integer.");
        }
    }

    private void portFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_portFieldFocusLost
        portFieldActionPerformed(null);
    }

    private void enablePortCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enablePortCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PORT_ENABLED, String.valueOf(enablePortCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }

    private void expandCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expandCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.EXPAND_FEAUTRE_TRACKS,
                String.valueOf(expandCB.isSelected()));
    }

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        genomeServerURLTextField.setEnabled(true);
        genomeServerURLTextField.setText(PreferenceManager.DEFAULT_GENOME_URL);
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SERVER_URL, null);
        dataServerURLTextField.setEnabled(true);
        dataServerURLTextField.setText(PreferenceManager.DEFAULT_DATA_URL);
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, null);
    }

    private void searchZoomCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchZoomCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SEARCH_ZOOM, String.valueOf(searchZoomCB.isSelected()));
    }

    private void showDatarangeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showDatarangeCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.CHART_SHOW_DATA_RANGE, String.valueOf(showDatarangeCB.isSelected()));
    }

    private void showDatarangeCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_showDatarangeCBFocusLost
        showDatarangeCBActionPerformed(null);
    }

    private void snpThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String snpThreshold = snpThresholdField.getText().trim();
        try {
            Double.parseDouble(snpThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAM_ALLELE_THRESHOLD, snpThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Allele frequency threshold must be a number.");
        }
    }

    private void snpThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {
        snpThresholdFieldActionPerformed(null);
    }

    private void normalizeCoverageCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.NORMALIZE_COVERAGE, String.valueOf(normalizeCoverageCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }


    // Proxy settings


    private void clearProxySettingsButtonActionPerformed(ActionEvent e) {
        if (MessageUtils.confirm("This will immediately clear all proxy settings.  Are you sure?")) {
            this.proxyHostField.setText("");
            this.proxyPortField.setText("");
            this.proxyUsernameField.setText("");
            this.proxyPasswordField.setText("");
            this.proxyTypeCB.setSelectedIndex(0);
            this.useProxyCB.setSelected(false);
            PreferenceManager.getInstance().clearProxySettings();
        }
    }


    private void useProxyCBActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.USE_PROXY, String.valueOf(useProxy));

    }


    private void authenticateProxyCBActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.PROXY_AUTHENTICATE, String.valueOf(authenticateProxy));

        proxyUsernameField.setEnabled(authenticateProxy);
        proxyPasswordField.setEnabled(authenticateProxy);

    }


    private void proxyHostFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyHostFieldActionPerformed(null);
    }

    private void proxyHostFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        updatedPreferenceMap.put(PreferenceManager.PROXY_HOST, proxyHostField.getText());
    }

    private void proxyPortFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyPortFieldActionPerformed(null);
    }

    private void proxyPortFieldActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            Integer.parseInt(proxyPortField.getText());
            proxySettingsChanged = true;
            updatedPreferenceMap.put(PreferenceManager.PROXY_PORT, proxyPortField.getText());
        } catch (NumberFormatException e) {
            MessageUtils.showMessage("Proxy port must be an integer.");
        }
    }


    private void proxyTypeCBActionPerformed(ActionEvent e) {
        proxySettingsChanged = true;
        String proxyTypeString = proxyTypeCB.getSelectedItem().toString();
        updatedPreferenceMap.put(PreferenceManager.PROXY_TYPE, proxyTypeString);
    }


    // Username

    private void proxyUsernameFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyUsernameFieldActionPerformed(null);
    }

    private void proxyUsernameFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        String user = proxyUsernameField.getText();
        updatedPreferenceMap.put(PreferenceManager.PROXY_USER, user);

    }

    // Password

    private void proxyPasswordFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyPasswordFieldActionPerformed(null);
    }

    private void proxyPasswordFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        String pw = new String(proxyPasswordField.getPassword());
        String pwEncoded = Utilities.base64Encode(pw);
        updatedPreferenceMap.put(PreferenceManager.PROXY_PW, pwEncoded);

    }


    private void updateProxyState(boolean useProxy, boolean authenticateProxy) {
        proxyHostField.setEnabled(useProxy);
        proxyPortField.setEnabled(useProxy);
        proxyUsernameField.setEnabled(useProxy && authenticateProxy);
        proxyPasswordField.setEnabled(useProxy && authenticateProxy);
    }

    private void resetValidation() {
        // Assume valid input until proven otherwise
        inputValidated = true;
    }

    private void dbHostFieldFocusLost(FocusEvent e) {
        dbHostFieldActionPerformed(null);
    }

    private void dbHostFieldActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.DB_HOST, dbHostField.getText());
    }

    private void dbNameFieldFocusLost(FocusEvent e) {
        dbNameFieldActionPerformed(null);
    }

    private void dbNameFieldActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.DB_NAME, dbNameField.getText());
    }

    private void dbPortFieldActionPerformed(ActionEvent e) {
        dbPortFieldFocusLost(null);
    }

    private void dbPortFieldFocusLost(FocusEvent e) {

        String portText = dbPortField.getText().trim();
        if (portText.length() == 0) {
            updatedPreferenceMap.put(PreferenceManager.DB_PORT, "-1");
        } else {
            try {
                Integer.parseInt(portText);
                updatedPreferenceMap.put(PreferenceManager.DB_PORT, portText);
            } catch (NumberFormatException e1) {
                updatedPreferenceMap.put(PreferenceManager.DB_PORT, "-1");
            }
        }

    }


    private void probeMappingBrowseButtonActionPerformed(ActionEvent e) {
        File f = FileDialogUtils.chooseFile("Probe mapping file (BED format)");
        if (f != null) {
            probeMappingFileTextField.setText(f.getAbsolutePath());
            updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_FILE, f.getAbsolutePath());
        }

    }


    private void useProbeMappingCBActionPerformed(ActionEvent e) {
        boolean isSelected = useProbeMappingCB.isSelected();
        updatedPreferenceMap.put(PreferenceManager.USE_PROBE_MAPPING_FILE, String.valueOf(isSelected));
        updateProbeMappingOptions(isSelected);
    }


    private void updateProbeMappingOptions(boolean isSelected) {
        probeMappingFileTextField.setEnabled(isSelected);
        probeMappingBrowseButton.setEnabled(isSelected);
        expMapToGeneCB.setEnabled(!isSelected);
        expMapToLociCB.setEnabled(!isSelected);
    }


    private void probeMappingFileTextFieldFocusLost(FocusEvent e) {
        probeMappingFileTextFieldActionPerformed(null);
    }


    private void probeMappingFileTextFieldActionPerformed(ActionEvent e) {
        String name = probeMappingFileTextField.getText();
        if (name != null) {
            name = name.trim();
            updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_FILE, name);
        }

    }

    private void toolTipInitialDelayFieldFocusLost(FocusEvent e) {
        toolTipInitialDelayFieldActionPerformed(null);
    }


    private void toolTipInitialDelayFieldActionPerformed(ActionEvent e) {
        String ttText = toolTipInitialDelayField.getText();
        try {
            Integer.parseInt(ttText);
            updatedPreferenceMap.put(PreferenceManager.TOOLTIP_INITIAL_DELAY, ttText);
            tooltipSettingsChanged = true;
        } catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip initial delay must be a number.");
        }
    }

    private void tooltipReshowDelayFieldFocusLost(FocusEvent e) {
        tooltipReshowDelayFieldActionPerformed(null);
    }

    private void tooltipReshowDelayFieldActionPerformed(ActionEvent e) {
        String ttText = tooltipReshowDelayField.getText();
        try {
            Integer.parseInt(ttText);
            updatedPreferenceMap.put(PreferenceManager.TOOLTIP_RESHOW_DELAY, ttText);
            tooltipSettingsChanged = true;
        } catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip reshow delay must be a number.");
        }

    }


    private void tooltipDismissDelayFieldFocusLost(FocusEvent e) {
        tooltipDismissDelayFieldActionPerformed(null);
    }

    private void tooltipDismissDelayFieldActionPerformed(ActionEvent e) {
        String ttText = tooltipDismissDelayField.getText();
        try {
            Integer.parseInt(ttText);
            updatedPreferenceMap.put(PreferenceManager.TOOLTIP_DISMISS_DELAY, ttText);
            tooltipSettingsChanged = true;
        } catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip dismiss delay must be a number.");
        }

    }

    /*
   *    Object selection = geneMappingFile.getSelectedItem();
  String filename = (selection == null ? null : selection.toString().trim());
  updatedPreferenceMap.put(
  PreferenceManager.USER_PROBE_MAP_KEY,
  filename);
   * */

    private void initValues() {
        combinePanelsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_SINGLE_TRACK_PANE_KEY));
        //drawExonNumbersCB.setSelected(preferenceManager.getDrawExonNumbers());

        showRegionBoundariesCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_REGION_BARS));
        defaultChartTrackHeightField.setText(prefMgr.get(PreferenceManager.CHART_TRACK_HEIGHT_KEY));
        defaultTrackHeightField.setText(prefMgr.get(PreferenceManager.TRACK_HEIGHT_KEY));
        showOrphanedMutationsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_ORPHANED_MUTATIONS));
        overlayAttributeTextField.setText(prefMgr.get(PreferenceManager.OVERLAY_ATTRIBUTE_KEY));
        overlayTrackCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.OVERLAY_MUTATION_TRACKS));
        showMissingDataCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_MISSING_DATA_KEY));
        showDefaultTrackAttributesCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_DEFAULT_TRACK_ATTRIBUTES));
        colorCodeMutationsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.COLOR_MUTATIONS));
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        showOrphanedMutationsCB.setEnabled(overlayTrackCB.isSelected());
        seqResolutionThreshold.setText(prefMgr.get(PreferenceManager.MAX_SEQUENCE_RESOLUTION));


        geneListFlankingField.setText(prefMgr.get(PreferenceManager.FLANKING_REGION));

        enablePortCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.PORT_ENABLED));
        portField.setText(String.valueOf(prefMgr.getAsInt(PreferenceManager.PORT_NUMBER)));
        portField.setEnabled(enablePortCB.isSelected());

        expandCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.EXPAND_FEAUTRE_TRACKS));
        searchZoomCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SEARCH_ZOOM));

        showAttributesDisplayCheckBox.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_ATTRIBUTE_VIEWS_KEY));
        trackNameAttributeField.setText(prefMgr.get(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY));

        genomeServerURLTextField.setText(prefMgr.getGenomeListURL());
        dataServerURLTextField.setText(prefMgr.getDataServerURL());

        blatURLField.setText(prefMgr.get(PreferenceManager.BLAT_URL));

        // Chart panel
        topBorderCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_DRAW_TOP_BORDER));
        bottomBorderCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_DRAW_BOTTOM_BORDER));
        colorBordersCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_COLOR_BORDERS));
        chartDrawTrackNameCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_DRAW_TRACK_NAME));
        autoscaleCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_AUTOSCALE));
        showDatarangeCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_SHOW_DATA_RANGE));
        labelYAxisCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_DRAW_Y_AXIS));
        showAllHeatmapFeauresCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.CHART_SHOW_ALL_HEATMAP));

        /** Ion Torrent (Chantal Roth) */
        this.binSizeText.setText(prefMgr.get(PreferenceManager.IONTORRENT_FLOWDIST_BINSIZE));
        boolean hideHp = prefMgr.getAsBoolean(PreferenceManager.IONTORRENT_FLOWDIST_HIDE_FIRST_HP);
        this.hideFirstHP.setSelected(hideHp);
        String type = PreferenceManager.getInstance().get(PreferenceManager.IONTORRENT_FLOWDIST_CHARTTYPE);
        if (type == null) type = "LINE";
        if (type != null) {
            type = type.trim().toUpperCase();
            if (type.equals("LINE")) this.radioLine.setSelected(true);
            else if (type.equals("AREA")) this.radioArea.setSelected(true);
            else if (type.equals("BAR")) this.radioBar.setSelected(true);
            else if (type.equals("STACKED")) this.radioStacked.setSelected(true);
        }
        String server = PreferenceManager.getInstance().get(PreferenceManager.IONTORRENT_SERVER);
        if (server != null) this.textServer.setText(server);

        //this.r.setText(prefMgr.get(PreferenceManager.IONTORRENT_FLOWDIST_BINSIZE));
        //this..setText(prefMgr.get(PreferenceManager.IONTORRENT_FLOWDIST_BINSIZE));

        samMaxWindowSizeField.setText(prefMgr.get(PreferenceManager.SAM_MAX_VISIBLE_RANGE));
        samSamplingWindowField.setText(prefMgr.get(PreferenceManager.SAM_SAMPLING_WINDOW));
        samDownsampleCountField.setText(prefMgr.get(PreferenceManager.SAM_SAMPLING_COUNT));

        boolean downsample = prefMgr.getAsBoolean(PreferenceManager.SAM_DOWNSAMPLE_READS);
        downsampleReadsCB.setSelected(downsample);
        samSamplingWindowField.setEnabled(downsample);
        samDownsampleCountField.setEnabled(downsample);

        mappingQualityThresholdField.setText(prefMgr.get(PreferenceManager.SAM_QUALITY_THRESHOLD));
        insertSizeThresholdField.setText(prefMgr.get(PreferenceManager.SAM_MAX_INSERT_SIZE_THRESHOLD));
        insertSizeMinThresholdField.setText(prefMgr.get(PreferenceManager.SAM_MIN_INSERT_SIZE_THRESHOLD));
        insertSizeMinPercentileField.setText(prefMgr.get(PreferenceManager.SAM_MIN_INSERT_SIZE_PERCENTILE));
        insertSizeMaxPercentileField.setText(prefMgr.get(PreferenceManager.SAM_MAX_INSERT_SIZE_PERCENTILE));

        final boolean isizeComputeSelected = prefMgr.getAsBoolean(PreferenceManager.SAM_COMPUTE_ISIZES);
        isizeComputeCB.setSelected(isizeComputeSelected);
        insertSizeThresholdField.setEnabled(!isizeComputeSelected);
        insertSizeMinThresholdField.setEnabled(!isizeComputeSelected);
        insertSizeMinPercentileField.setEnabled(isizeComputeSelected);
        insertSizeMaxPercentileField.setEnabled(isizeComputeSelected);

        snpThresholdField.setText((String.valueOf(prefMgr.getAsFloat(PreferenceManager.SAM_ALLELE_THRESHOLD))));
        //samShowZeroQualityCB.setSelected(samPrefs.isShowZeroQuality());
        useAlleleQualityCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_ALLELE_USE_QUALITY));
        samFilterDuplicatesCB.setSelected(!prefMgr.getAsBoolean(PreferenceManager.SAM_SHOW_DUPLICATES));
        filterFailedReadsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_FILTER_FAILED_READS));
        filterSecondaryAlignmentsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_FILTER_SECONDARY_ALIGNMENTS));
        filterSupplementaryAlignmentsCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_FILTER_SUPPLEMENTARY_ALIGNMENTS));
        showSoftClippedCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_SHOW_SOFT_CLIPPED));
        samFlagUnmappedPairCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_FLAG_UNMAPPED_PAIR));
        showCenterLineCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_SHOW_CENTER_LINE));
        samShadeMismatchedBaseCB.setSelected(ShadeBasesOption.QUALITY ==
                CollUtils.valueOf(ShadeBasesOption.class, prefMgr.get(PreferenceManager.SAM_SHADE_BASES), ShadeBasesOption.QUALITY));
        samMinBaseQualityField.setText((String.valueOf(prefMgr.getAsInt(PreferenceManager.SAM_BASE_QUALITY_MIN))));
        samMaxBaseQualityField.setText((String.valueOf(prefMgr.getAsInt(PreferenceManager.SAM_BASE_QUALITY_MAX))));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        showCovTrackCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_SHOW_COV_TRACK));
        filterCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SAM_FILTER_ALIGNMENTS));
        if (prefMgr.get(PreferenceManager.SAM_FILTER_URL) != null) {
            filterURL.setText(prefMgr.get(PreferenceManager.SAM_FILTER_URL));
        }

        final boolean junctionTrackEnabled = prefMgr.getAsBoolean(PreferenceManager.SAM_SHOW_JUNCTION_TRACK);
        showJunctionTrackCB.setSelected(junctionTrackEnabled);
        showJunctionFlankingRegionsCB.setSelected(prefMgr.getAsBoolean(
                PreferenceManager.SAM_SHOW_JUNCTION_FLANKINGREGIONS));
        showJunctionFlankingRegionsCB.setEnabled(junctionTrackEnabled);
        junctionFlankingTextField.setText(prefMgr.get(PreferenceManager.SAM_JUNCTION_MIN_FLANKING_WIDTH));
        junctionCoverageTextField.setText(prefMgr.get(PreferenceManager.SAM_JUNCTION_MIN_COVERAGE));
        junctionFlankingTextField.setEnabled(junctionTrackEnabled);
        junctionCoverageTextField.setEnabled(junctionTrackEnabled);

        genomeUpdateCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.AUTO_UPDATE_GENOMES));
        antialiasingCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.ENABLE_ANTIALISING));

        final boolean mapProbesToGenes = PreferenceManager.getInstance().getAsBoolean(PreferenceManager.PROBE_MAPPING_KEY);
        expMapToGeneCB.setSelected(mapProbesToGenes);
        expMapToLociCB.setSelected(!mapProbesToGenes);

        probeMappingFileTextField.setText(prefMgr.get(PreferenceManager.PROBE_MAPPING_FILE));
        boolean useProbeMapping = prefMgr.getAsBoolean(PreferenceManager.USE_PROBE_MAPPING_FILE);
        useProbeMappingCB.setSelected(useProbeMapping);
        updateProbeMappingOptions(useProbeMapping);

        normalizeCoverageCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.NORMALIZE_COVERAGE));


        expandIconCB.setSelected(prefMgr.getAsBoolean(PreferenceManager.SHOW_EXPAND_ICON));

        boolean useProxy = prefMgr.getAsBoolean(PreferenceManager.USE_PROXY);
        useProxyCB.setSelected(useProxy);

        boolean authenticateProxy = prefMgr.getAsBoolean(PreferenceManager.PROXY_AUTHENTICATE);
        authenticateProxyCB.setSelected(authenticateProxy);

        proxyHostField.setText(prefMgr.get(PreferenceManager.PROXY_HOST, ""));
        proxyPortField.setText(prefMgr.get(PreferenceManager.PROXY_PORT, ""));
        proxyUsernameField.setText(prefMgr.get(PreferenceManager.PROXY_USER, ""));
        String pwCoded = prefMgr.get(PreferenceManager.PROXY_PW, "");
        proxyPasswordField.setText(Utilities.base64Decode(pwCoded));

        String proxyTypeString = prefMgr.get(PreferenceManager.PROXY_TYPE, null);
        if (proxyTypeString != null) {
            proxyTypeCB.setSelectedItem(proxyTypeString);
        }

        backgroundColorPanel.setBackground(
                PreferenceManager.getInstance().getAsColor(PreferenceManager.BACKGROUND_COLOR));

        dbHostField.setText(prefMgr.get(PreferenceManager.DB_HOST));
        dbNameField.setText(prefMgr.get(PreferenceManager.DB_NAME));
        String portText = prefMgr.get(PreferenceManager.DB_PORT);
        if (!portText.equals("-1")) {
            dbPortField.setText(portText);
        }


        final File igvDirectory = DirectoryManager.getIgvDirectory();
        if (igvDirectory != null) {
            igvDirectoryField.setText(igvDirectory.getAbsolutePath());
        }

        tooltipDismissDelayField.setText(prefMgr.get(PreferenceManager.TOOLTIP_DISMISS_DELAY));
        tooltipReshowDelayField.setText(prefMgr.get(PreferenceManager.TOOLTIP_RESHOW_DELAY));
        toolTipInitialDelayField.setText(prefMgr.get(PreferenceManager.TOOLTIP_INITIAL_DELAY));

        featureVisibilityWindowField.setText(prefMgr.get(PreferenceManager.DEFAULT_VISIBILITY_WINDOW));

        updateFontField();

        updateProxyState(useProxy, authenticateProxy);
    }

    private void updateFontField() {
        Font font = FontManager.getDefaultFont();
        StringBuffer buf = new StringBuffer();
        buf.append(font.getFamily());
        if (font.isBold()) {
            buf.append(" bold");
        }
        if (font.isItalic()) {
            buf.append(" italic");
        }
        buf.append(" " + font.getSize());
        defaultFontField.setText(buf.toString());

    }

    /**
     * Scan preference updates for changes affecting alignment tracks.  If any force reload of all alignment tracks.
     */
    private void checkForSAMChanges() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            boolean reloadSAM = false;
            for (String key : SAM_PREFERENCE_KEYS) {
                if (updatedPreferenceMap.containsKey(key)) {
                    reloadSAM = true;
                    break;
                }

            }
            if (updatedPreferenceMap.containsKey(PreferenceManager.SAM_ALLELE_THRESHOLD)) {
                updateCoverageTrack = true;
            }

            boolean updateSpliceJunctions = false;
            for (String key : SPLICE_JUNCTION_KEYS) {
                if (updatedPreferenceMap.containsKey(key)) {
                    updateSpliceJunctions = true;
                    break;
                }
            }


            final IGV igv = IGV.getInstance();
            if (updateSpliceJunctions) {
                igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.SPLICE_JUNCTION);
            }
            if (reloadSAM) {
                if (updatedPreferenceMap.containsKey(PreferenceManager.SAM_MAX_VISIBLE_RANGE)) {
                    igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.VISIBILITY_WINDOW);
                }
                igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.RELOAD);
            }
            if (updateCoverageTrack) {
                igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.ALLELE_THRESHOLD);
                updateCoverageTrack = false;
            }
        } finally {
            WaitCursorManager.removeWaitCursor(token);
        }

    }


    private void checkForProbeChanges() {
        if (updatedPreferenceMap.containsKey(PreferenceManager.PROBE_MAPPING_KEY)) {
            ProbeToLocusMap.getInstance().clearProbeMappings();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                PreferencesEditor dialog = new PreferencesEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    //TODO move this to another class,  or resource bundle
    static String overlayText = "<html>These options control the treatment of mutation tracks.  " +
            "Mutation data may optionally<br>be overlayed on other tracks that have a matching attribute value " +
            "from the sample info <br>file. " +
            "This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in the" +
            "text field below.";

    public String getOverlayText() {
        return overlayText;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // Generated using JFormDesigner non-commercial license
    private JTabbedPane tabbedPane;
    private JPanel generalPanel;
    private JPanel vSpacer7;
    private JPanel jPanel10;
    private JLabel missingDataExplanation;
    private JCheckBox showDefaultTrackAttributesCB;
    private JCheckBox combinePanelsCB;
    private JCheckBox showAttributesDisplayCheckBox;
    private JCheckBox searchZoomCB;
    private JLabel label4;
    private JTextField geneListFlankingField;
    private JLabel zoomToFeatureExplanation2;
    private JLabel label6;
    private JTextField seqResolutionThreshold;
    private JLabel label10;
    private JTextField defaultFontField;
    private JButton fontChangeButton;
    private JCheckBox showRegionBoundariesCB;
    private JLabel label7;
    private JPanel backgroundColorPanel;
    private JButton resetBackgroundButton;
    private JCheckBox showMissingDataCB;
    private JLabel label32;
    private JLabel textField1;
    private JTextField featureVisibilityWindowField;
    private JLabel zoomToFeatureExplanation3;
    private JPanel tracksPanel;
    private JPanel vSpacer1;
    private JLabel jLabel5;
    private JTextField defaultChartTrackHeightField;
    private JLabel trackNameAttributeLabel;
    private JTextField trackNameAttributeField;
    private JLabel jLabel8;
    private JTextField defaultTrackHeightField;
    private JPanel hSpacer1;
    private JCheckBox expandCB;
    private JCheckBox normalizeCoverageCB;
    private JLabel missingDataExplanation8;
    private JCheckBox expandIconCB;
    private JPanel overlaysPanel;
    private JPanel jPanel5;
    private JLabel jLabel3;
    private JTextField overlayAttributeTextField;
    private JCheckBox overlayTrackCB;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JCheckBox colorCodeMutationsCB;
    private JButton chooseMutationColorsButton;
    private JLabel label11;
    private JCheckBox showOrphanedMutationsCB;
    private JLabel label12;
    private JPanel chartPanel;
    private JPanel jPanel4;
    private JCheckBox topBorderCB;
    private JLabel label1;
    private JCheckBox chartDrawTrackNameCB;
    private JCheckBox bottomBorderCB;
    private JLabel jLabel7;
    private JCheckBox colorBordersCB;
    private JCheckBox labelYAxisCB;
    private JCheckBox autoscaleCB;
    private JLabel jLabel9;
    private JCheckBox showDatarangeCB;
    private JPanel panel1;
    private JLabel label13;
    private JCheckBox showAllHeatmapFeauresCB;
    private JLabel label14;
    private JPanel alignmentPanel;
    private JPanel vSpacer2;
    private JPanel jPanel11;
    private JLabel jLabel11;
    private JTextField samMaxWindowSizeField;
    private JLabel jLabel12;
    private JPanel vSpacer3;
    private JPanel panel4;
    private JCheckBox downsampleReadsCB;
    private JPanel hSpacer3;
    private JLabel label23;
    private JTextField samDownsampleCountField;
    private JLabel jLabel13;
    private JTextField samSamplingWindowField;
    private JPanel vSpacer4;
    private JPanel jPanel12;
    private JPanel panel8;
    private JPanel panel5;
    private JLabel jLabel26;
    private JTextField snpThresholdField;
    private JPanel hSpacer2;
    private JCheckBox showCovTrackCB;
    private JCheckBox samFilterDuplicatesCB;
    private JCheckBox samFlagUnmappedPairCB;
    private JCheckBox filterFailedReadsCB;
    private JCheckBox showSoftClippedCB;
    private JCheckBox showCenterLineCB;
    private JCheckBox filterSecondaryAlignmentsCB;
    private JCheckBox filterSupplementaryAlignmentsCB;
    private JCheckBox useAlleleQualityCB;
    private JPanel panel13;
    private JPanel panel12;
    private JLabel jLabel15;
    private JTextField mappingQualityThresholdField;
    private JPanel panel11;
    private JCheckBox samShadeMismatchedBaseCB;
    private JTextField samMinBaseQualityField;
    private JLabel label2;
    private JTextField samMaxBaseQualityField;
    private JPanel panel9;
    private JCheckBox filterCB;
    private JTextField filterURL;
    private JPanel panel10;
    private JCheckBox samFlagInsertionsCB;
    private JTextField samFlagInsertionsThresholdField;
    private JLabel label31;
    private JPanel vSpacer5;
    private JPanel panel3;
    private JCheckBox showJunctionTrackCB;
    private JCheckBox showJunctionFlankingRegionsCB;
    private JTextField junctionFlankingTextField;
    private JLabel label15;
    private JLabel label16;
    private JTextField junctionCoverageTextField;
    private JPanel vSpacer6;
    private JPanel panel2;
    private JPanel panel19;
    private JPanel panel16;
    private JLabel label9;
    private JLabel jLabel20;
    private JTextField insertSizeMinThresholdField;
    private JLabel jLabel17;
    private JTextField insertSizeThresholdField;
    private JPanel panel15;
    private JCheckBox isizeComputeCB;
    private JLabel jLabel30;
    private JTextField insertSizeMinPercentileField;
    private JLabel jLabel18;
    private JTextField insertSizeMaxPercentileField;
    private JPanel expressionPane;
    private JPanel jPanel8;
    private JPanel panel18;
    private JLabel jLabel24;
    private JLabel jLabel21;
    private JRadioButton expMapToLociCB;
    private JRadioButton expMapToGeneCB;
    private JPanel panel17;
    private JCheckBox useProbeMappingCB;
    private JLabel label22;
    private JPanel panel14;
    private JTextField probeMappingFileTextField;
    private JButton probeMappingBrowseButton;
    private JPanel proxyPanel;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JTextField proxyUsernameField;
    private JLabel jLabel28;
    private JCheckBox authenticateProxyCB;
    private JLabel jLabel29;
    private JPasswordField proxyPasswordField;
    private JPanel jPanel17;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JLabel jLabel27;
    private JLabel jLabel23;
    private JCheckBox useProxyCB;
    private JComboBox proxyTypeCB;
    private JLabel label27;
    private JLabel label3;
    private JButton clearProxySettingsButton;
    private JPanel ionTorrentPanel;
    private JPanel panel6;
    private JCheckBox hideFirstHP;
    private JTextField binSizeText;
    private JLabel label28;
    private JLabel label29;
    private JRadioButton radioLine;
    private JRadioButton radioArea;
    private JRadioButton radioBar;
    private JRadioButton radioStacked;
    private JPanel panel7;
    private JLabel label30;
    private JTextField textServer;
    private JPanel advancedPanel;
    private JButton clearGenomeCacheButton;
    private JCheckBox enablePortCB;
    private JTextField portField;
    private JLabel jLabel22;
    private JCheckBox genomeUpdateCB;
    private JLabel jLabel6;
    private JTextField dataServerURLTextField;
    private JLabel jLabel1;
    private JTextField genomeServerURLTextField;
    private JCheckBox editServerPropertiesCB;
    private JButton jButton1;
    private JButton igvDirectoryButton;
    private JLabel igvDirectoryField;
    private JLabel label21;
    private JPanel tooltipOptionsPanel;
    private JLabel label24;
    private JLabel label25;
    private JLabel label26;
    private JTextField toolTipInitialDelayField;
    private JTextField tooltipReshowDelayField;
    private JTextField tooltipDismissDelayField;
    private JCheckBox antialiasingCB;
    private JLabel label5;
    private JTextField blatURLField;
    private JPanel dbPanel;
    private JLabel label20;
    private JPanel panel21;
    private JLabel label17;
    private JLabel label19;
    private JTextField dbNameField;
    private JTextField dbHostField;
    private JLabel label18;
    private JTextField dbPortField;
    private ButtonPanel okCancelButtonPanel;
    JButton okButton;
    private JButton cancelButton;
    // End of variables declaration//GEN-END:variables

    public boolean isCanceled() {
        return canceled;
    }

    /**
     * List of keys that affect the alignments loaded.  This list is used to trigger a reload, if required.
     * Not all alignment preferences need trigger a reload, this is a subset.
     */
    static java.util.List<String> SAM_PREFERENCE_KEYS = Arrays.asList(
            PreferenceManager.SAM_QUALITY_THRESHOLD,
            PreferenceManager.SAM_FILTER_ALIGNMENTS,
            PreferenceManager.SAM_FILTER_URL,
            PreferenceManager.SAM_MAX_VISIBLE_RANGE,
            PreferenceManager.SAM_SHOW_DUPLICATES,
            PreferenceManager.SAM_SHOW_SOFT_CLIPPED,
            PreferenceManager.SAM_SAMPLING_COUNT,
            PreferenceManager.SAM_SAMPLING_WINDOW,
            PreferenceManager.SAM_FILTER_FAILED_READS,
            PreferenceManager.SAM_DOWNSAMPLE_READS,
            PreferenceManager.SAM_FILTER_SECONDARY_ALIGNMENTS,
            PreferenceManager.SAM_FILTER_SUPPLEMENTARY_ALIGNMENTS
    );

    static java.util.List<String> SPLICE_JUNCTION_KEYS = Arrays.asList(
            PreferenceManager.SAM_SHOW_JUNCTION_TRACK,
            PreferenceManager.SAM_JUNCTION_MIN_FLANKING_WIDTH,
            PreferenceManager.SAM_JUNCTION_MIN_COVERAGE

    );


}
