/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextReader;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

@Deprecated
public class SAMFileReader
implements SamReader,
SamReader.Indexing {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean mIsBinary = false;
    private BAMIndex mIndex = null;
    private SAMRecordFactory samRecordFactory = new DefaultSAMRecordFactory();
    private ReaderImplementation mReader = null;
    private File samFile = null;

    public static ValidationStringency getDefaultValidationStringency() {
        return defaultValidationStringency;
    }

    public static void setDefaultValidationStringency(ValidationStringency defaultValidationStringency) {
        SAMFileReader.defaultValidationStringency = defaultValidationStringency;
    }

    public static SAMSequenceDictionary getSequenceDictionary(File dictionaryFile) {
        SAMFileReader samFileReader = new SAMFileReader(dictionaryFile);
        SAMSequenceDictionary dict = samFileReader.getFileHeader().getSequenceDictionary();
        CloserUtil.close(dictionaryFile);
        return dict;
    }

    public SAMFileReader(InputStream stream) {
        this(stream, false);
    }

    public SAMFileReader(File file) {
        this(file, null, false);
    }

    public SAMFileReader(File file, File indexFile) {
        this(file, indexFile, false);
    }

    public SAMFileReader(InputStream stream, boolean eagerDecode) {
        this.init(stream, null, null, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(File file, boolean eagerDecode) {
        this(file, null, eagerDecode);
    }

    public SAMFileReader(File file, File indexFile, boolean eagerDecode) {
        this.init(null, file, indexFile, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(URL url, File indexFile, boolean eagerDecode) {
        this.init((SeekableStream)new SeekableBufferedStream(new SeekableHTTPStream(url)), indexFile, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream strm, File indexFile, boolean eagerDecode) {
        this.init(strm, indexFile, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream strm, SeekableStream indexStream, boolean eagerDecode) {
        this.init(strm, indexStream, eagerDecode, defaultValidationStringency);
    }

    @Override
    public void close() {
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mIndex = null;
    }

    public void enableFileSource(boolean enabled) {
        this.mReader.enableFileSource(this, enabled);
    }

    public void enableIndexCaching(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mReader.enableIndexCaching(enabled);
    }

    public void enableIndexMemoryMapping(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mReader.enableIndexMemoryMapping(enabled);
    }

    public void enableCrcChecking(boolean enabled) {
        this.mReader.enableCrcChecking(enabled);
    }

    public void setSAMRecordFactory(SAMRecordFactory factory) {
        this.samRecordFactory = factory;
        this.mReader.setSAMRecordFactory(factory);
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    @Override
    public boolean hasIndex() {
        return this.mReader.hasIndex();
    }

    @Override
    public SamReader.Indexing indexing() {
        return this;
    }

    @Override
    public BAMIndex getIndex() {
        return this.mReader.getIndex();
    }

    @Override
    public boolean hasBrowseableIndex() {
        return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        BAMIndex index = this.getIndex();
        if (!(index instanceof BrowseableBAMIndex)) {
            throw new SAMException("Cannot return index: index created by BAM is not browseable.");
        }
        return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(index);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.mReader.getFileHeader();
    }

    @Override
    public SamReader.Type type() {
        return this.mReader.type();
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mReader.setValidationStringency(validationStringency);
    }

    @Override
    public SAMRecordIterator iterator() {
        return new SamReader.AssertingIterator(this.mReader.getIterator());
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan chunks) {
        return new SamReader.AssertingIterator(this.mReader.getIterator(chunks));
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return this.mReader.getFilePointerSpanningReads();
    }

    @Override
    public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
        CloseableIterator<SAMRecord> currentIterator;
        int referenceIndex = this.getFileHeader().getSequenceIndex(sequence);
        if (referenceIndex == -1) {
            currentIterator = new EmptySamIterator();
        } else {
            QueryInterval[] queryIntervals = new QueryInterval[]{new QueryInterval(referenceIndex, start, end)};
            currentIterator = this.mReader.query(queryIntervals, contained);
        }
        return new SamReader.AssertingIterator(currentIterator);
    }

    @Override
    public SAMRecordIterator queryOverlapping(String sequence, int start, int end) {
        return this.query(sequence, start, end, false);
    }

    @Override
    public SAMRecordIterator queryContained(String sequence, int start, int end) {
        return this.query(sequence, start, end, true);
    }

    @Override
    public SAMRecordIterator query(QueryInterval[] intervals, boolean contained) {
        return new SamReader.AssertingIterator(this.mReader.query(intervals, contained));
    }

    @Override
    public SAMRecordIterator queryOverlapping(QueryInterval[] intervals) {
        return this.query(intervals, false);
    }

    @Override
    public SAMRecordIterator queryContained(QueryInterval[] intervals) {
        return this.query(intervals, true);
    }

    @Override
    public SAMRecordIterator queryUnmapped() {
        return new SamReader.AssertingIterator(this.mReader.queryUnmapped());
    }

    @Override
    public SAMRecordIterator queryAlignmentStart(String sequence, int start) {
        return new SamReader.AssertingIterator(this.mReader.queryAlignmentStart(sequence, start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAMRecord queryMate(SAMRecord rec) {
        if (!rec.getReadPairedFlag()) {
            throw new IllegalArgumentException("queryMate called for unpaired read.");
        }
        if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
            throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
        }
        boolean firstOfPair = rec.getFirstOfPairFlag();
        SAMRecordIterator it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());
        try {
            SAMRecord mateRec = null;
            while (it.hasNext()) {
                SAMRecord next = (SAMRecord)it.next();
                if (!next.getReadPairedFlag()) {
                    if (!rec.getReadName().equals(next.getReadName())) continue;
                    throw new SAMFormatException("Paired and unpaired reads with same name: " + rec.getReadName());
                }
                if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                if (mateRec != null) {
                    throw new SAMFormatException("Multiple SAMRecord with read name " + rec.getReadName() + " for " + (firstOfPair ? "second" : "first") + " end.");
                }
                mateRec = next;
            }
            SAMRecord sAMRecord = mateRec;
            return sAMRecord;
        }
        finally {
            it.close();
        }
    }

    private void init(SeekableStream strm, File indexFile, boolean eagerDecode, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(strm)) {
                throw new SAMFormatException("Unrecognized file format: " + strm);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(strm, indexFile, eagerDecode, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void init(SeekableStream strm, SeekableStream indexStream, boolean eagerDecode, ValidationStringency validationStringency) {
        try {
            if (!this.streamLooksLikeBam(strm)) {
                throw new SAMFormatException("Unrecognized file format: " + strm);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(strm, indexStream, eagerDecode, validationStringency, this.samRecordFactory);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private boolean streamLooksLikeBam(SeekableStream strm) {
        String source = strm.getSource();
        if (source == null) {
            return true;
        }
        return (source = source.toLowerCase()).endsWith(".bam") || source.contains(".bam?") || source.contains(".bam&") || source.contains(".bam%26");
    }

    private void init(InputStream stream, File file, File indexFile, boolean eagerDecode, ValidationStringency validationStringency) {
        if (stream != null && file != null) {
            throw new IllegalArgumentException("stream and file are mutually exclusive");
        }
        this.samFile = file;
        try {
            int bufferSize = Math.max(Defaults.BUFFER_SIZE, 65536);
            BufferedInputStream bufferedStream = file != null ? new BufferedInputStream(new FileInputStream(file), bufferSize) : IOUtil.toBufferedStream(stream);
            if (this.isBAMFile(bufferedStream)) {
                this.mIsBinary = true;
                if (file == null || !file.isFile()) {
                    this.mReader = new BAMFileReader(bufferedStream, indexFile, eagerDecode, validationStringency, this.samRecordFactory);
                } else {
                    bufferedStream.close();
                    this.mReader = new BAMFileReader(file, indexFile, eagerDecode, validationStringency, this.samRecordFactory);
                }
            } else if (BlockCompressedInputStream.isValidFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new BlockCompressedInputStream(bufferedStream), validationStringency, this.samRecordFactory);
            } else if (this.isGzippedSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedStream), validationStringency, this.samRecordFactory);
            } else if (this.isSAMFile(bufferedStream)) {
                if (indexFile != null) {
                    bufferedStream.close();
                    throw new RuntimeException("Cannot use index file with textual SAM file");
                }
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedStream, file, validationStringency, this.samRecordFactory);
            } else {
                bufferedStream.close();
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(validationStringency);
            this.mReader.setSAMRecordFactory(this.samRecordFactory);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private boolean isBAMFile(InputStream stream) throws IOException {
        if (!BlockCompressedInputStream.isValidFile(stream)) {
            return false;
        }
        int buffSize = 65536;
        stream.mark(65536);
        byte[] buffer = new byte[65536];
        SAMFileReader.readBytes(stream, buffer, 0, 65536);
        stream.reset();
        byte[] magicBuf = new byte[4];
        int magicLength = SAMFileReader.readBytes(new BlockCompressedInputStream(new ByteArrayInputStream(buffer)), magicBuf, 0, 4);
        return magicLength == BAMFileConstants.BAM_MAGIC.length && Arrays.equals(BAMFileConstants.BAM_MAGIC, magicBuf);
    }

    private static int readBytes(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        int count;
        for (bytesRead = 0; bytesRead < length && (count = stream.read(buffer, offset + bytesRead, length - bytesRead)) > 0; bytesRead += count) {
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzippedSAMFile(BufferedInputStream stream) {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        stream.mark(8000);
        try {
            GZIPInputStream gunzip = new GZIPInputStream(stream);
            int ch = gunzip.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }

    private boolean isSAMFile(InputStream stream) {
        return true;
    }

    public String toString() {
        if (this.samFile == null) {
            return this.getClass().getSimpleName() + "{initialized with stream}";
        }
        return this.getClass().getSimpleName() + "{" + this.samFile.getAbsolutePath() + "}";
    }

    public QueryInterval makeQueryInterval(String sequence, int start, int end) {
        int referenceIndex = this.getFileHeader().getSequenceIndex(sequence);
        if (referenceIndex < 0) {
            throw new IllegalArgumentException(String.format("Sequence '%s' not found in sequence dictionary", sequence));
        }
        if (start < 1) {
            throw new IllegalArgumentException("Start position must be >= 1");
        }
        return new QueryInterval(referenceIndex, start, end);
    }

    public QueryInterval makeQueryInterval(String sequence, int start) {
        return this.makeQueryInterval(sequence, start, 0);
    }

    public static abstract class ReaderImplementation
    implements SamReader.PrimitiveSamReader {
        abstract void enableFileSource(SamReader var1, boolean var2);

        abstract void enableIndexCaching(boolean var1);

        abstract void enableIndexMemoryMapping(boolean var1);

        abstract void enableCrcChecking(boolean var1);

        abstract void setSAMRecordFactory(SAMRecordFactory var1);

        abstract void setValidationStringency(ValidationStringency var1);
    }

    private static class EmptySamIterator
    implements CloseableIterator<SAMRecord> {
        private EmptySamIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new NoSuchElementException("next called on empty iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        @Override
        public void close() {
        }
    }
}

