/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.WeightCombiner;

public class GraphUnion<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = -740199233080172450L;
    private static final String READ_ONLY = "union of graphs is read-only";
    private G g1;
    private G g2;
    private WeightCombiner operator;

    public GraphUnion(G g2, G g3, WeightCombiner weightCombiner) {
        if (g2 == null) {
            throw new NullPointerException("g1 is null");
        }
        if (g3 == null) {
            throw new NullPointerException("g2 is null");
        }
        if (g2 == g3) {
            throw new IllegalArgumentException("g1 is equal to g2");
        }
        this.g1 = g2;
        this.g2 = g3;
        this.operator = weightCombiner;
    }

    public GraphUnion(G g2, G g3) {
        this(g2, g3, WeightCombiner.SUM);
    }

    @Override
    public Set<E> getAllEdges(V v2, V v3) {
        HashSet hashSet = new HashSet();
        if (this.g1.containsVertex(v2) && this.g1.containsVertex(v3)) {
            hashSet.addAll(this.g1.getAllEdges(v2, v3));
        }
        if (this.g2.containsVertex(v2) && this.g2.containsVertex(v3)) {
            hashSet.addAll(this.g2.getAllEdges(v2, v3));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public E getEdge(V v2, V v3) {
        E e2 = null;
        if (this.g1.containsVertex(v2) && this.g1.containsVertex(v3)) {
            e2 = this.g1.getEdge(v2, v3);
        }
        if (e2 == null && this.g2.containsVertex(v2) && this.g2.containsVertex(v3)) {
            e2 = this.g2.getEdge(v2, v3);
        }
        return e2;
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public E addEdge(V v2, V v3) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addEdge(V v2, V v3, E e2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addVertex(V v2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.g1.containsEdge(e2) || this.g2.containsEdge(e2);
    }

    @Override
    public boolean containsVertex(V v2) {
        return this.g1.containsVertex(v2) || this.g2.containsVertex(v2);
    }

    @Override
    public Set<E> edgeSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.g1.edgeSet());
        hashSet.addAll(this.g2.edgeSet());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<E> edgesOf(V v2) {
        HashSet hashSet = new HashSet();
        if (this.g1.containsVertex(v2)) {
            hashSet.addAll(this.g1.edgesOf(v2));
        }
        if (this.g2.containsVertex(v2)) {
            hashSet.addAll(this.g2.edgesOf(v2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public E removeEdge(V v2, V v3) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeEdge(E e2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeVertex(V v2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Set<V> vertexSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.g1.vertexSet());
        hashSet.addAll(this.g2.vertexSet());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public V getEdgeSource(E e2) {
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeSource(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeSource(e2);
        }
        return null;
    }

    @Override
    public V getEdgeTarget(E e2) {
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeTarget(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeTarget(e2);
        }
        return null;
    }

    @Override
    public double getEdgeWeight(E e2) {
        if (this.g1.containsEdge(e2) && this.g2.containsEdge(e2)) {
            return this.operator.combine(this.g1.getEdgeWeight(e2), this.g2.getEdgeWeight(e2));
        }
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeWeight(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeWeight(e2);
        }
        throw new IllegalArgumentException("no such edge in the union");
    }

    public G getG1() {
        return this.g1;
    }

    public G getG2() {
        return this.g2;
    }
}

