/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.exceptions;

import java.lang.reflect.InvocationTargetException;
import org.broadinstitute.gatk.utils.exceptions.UserException;

public class DynamicClassResolutionException
extends UserException {
    public DynamicClassResolutionException(Class c2, Exception ex) {
        super(String.format("Could not create module %s because %s caused by exception %s", c2.getSimpleName(), DynamicClassResolutionException.moreInfo(ex), ex.getMessage()));
    }

    private static String moreInfo(Exception ex) {
        try {
            throw ex;
        }
        catch (InstantiationException e2) {
            return "BUG: cannot instantiate class: must be concrete class";
        }
        catch (NoSuchMethodException e3) {
            return "BUG: Cannot find expected constructor for class";
        }
        catch (IllegalAccessException e4) {
            return "Cannot instantiate class (Illegal Access)";
        }
        catch (InvocationTargetException e5) {
            return "Cannot instantiate class (Invocation failure)";
        }
        catch (Exception e6) {
            return String.format("an exception of type %s occurred", e6.getClass().getSimpleName());
        }
    }
}

