/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;

public class NaccacheSternKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static int[] smallPrimes = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557};
    private NaccacheSternKeyGenerationParameters param;
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    public void init(KeyGenerationParameters param) {
        this.param = (NaccacheSternKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger g2;
        BigInteger q2;
        BigInteger q_;
        BigInteger p2;
        BigInteger p_;
        int i2;
        int strength = this.param.getStrength();
        SecureRandom rand = this.param.getRandom();
        int certainty = this.param.getCertainty();
        boolean debug = this.param.isDebug();
        if (debug) {
            System.out.println("Fetching first " + this.param.getCntSmallPrimes() + " primes.");
        }
        Vector smallPrimes = NaccacheSternKeyPairGenerator.findFirstPrimes(this.param.getCntSmallPrimes());
        smallPrimes = NaccacheSternKeyPairGenerator.permuteList(smallPrimes, rand);
        BigInteger u2 = ONE;
        BigInteger v2 = ONE;
        for (i2 = 0; i2 < smallPrimes.size() / 2; ++i2) {
            u2 = u2.multiply((BigInteger)smallPrimes.elementAt(i2));
        }
        for (i2 = smallPrimes.size() / 2; i2 < smallPrimes.size(); ++i2) {
            v2 = v2.multiply((BigInteger)smallPrimes.elementAt(i2));
        }
        BigInteger sigma = u2.multiply(v2);
        int remainingStrength = strength - sigma.bitLength() - 48;
        BigInteger a2 = NaccacheSternKeyPairGenerator.generatePrime(remainingStrength / 2 + 1, certainty, rand);
        BigInteger b2 = NaccacheSternKeyPairGenerator.generatePrime(remainingStrength / 2 + 1, certainty, rand);
        long tries = 0L;
        if (debug) {
            System.out.println("generating p and q");
        }
        BigInteger _2au = a2.multiply(u2).shiftLeft(1);
        BigInteger _2bv = b2.multiply(v2).shiftLeft(1);
        while (true) {
            ++tries;
            p_ = NaccacheSternKeyPairGenerator.generatePrime(24, certainty, rand);
            p2 = p_.multiply(_2au).add(ONE);
            if (!p2.isProbablePrime(certainty)) continue;
            while (p_.equals(q_ = NaccacheSternKeyPairGenerator.generatePrime(24, certainty, rand)) || !(q2 = q_.multiply(_2bv).add(ONE)).isProbablePrime(certainty)) {
            }
            if (!sigma.gcd(p_.multiply(q_)).equals(ONE)) continue;
            if (p2.multiply(q2).bitLength() >= strength) break;
            if (!debug) continue;
            System.out.println("key size too small. Should be " + strength + " but is actually " + p2.multiply(q2).bitLength());
        }
        if (debug) {
            System.out.println("needed " + tries + " tries to generate p and q.");
        }
        BigInteger n2 = p2.multiply(q2);
        BigInteger phi_n = p2.subtract(ONE).multiply(q2.subtract(ONE));
        tries = 0L;
        if (debug) {
            System.out.println("generating g");
        }
        while (true) {
            Vector<BigInteger> gParts = new Vector<BigInteger>();
            for (int ind = 0; ind != smallPrimes.size(); ++ind) {
                BigInteger i3 = (BigInteger)smallPrimes.elementAt(ind);
                BigInteger e2 = phi_n.divide(i3);
                do {
                    ++tries;
                } while ((g2 = new BigInteger(strength, certainty, rand)).modPow(e2, n2).equals(ONE));
                gParts.addElement(g2);
            }
            g2 = ONE;
            for (int i4 = 0; i4 < smallPrimes.size(); ++i4) {
                g2 = g2.multiply(((BigInteger)gParts.elementAt(i4)).modPow(sigma.divide((BigInteger)smallPrimes.elementAt(i4)), n2)).mod(n2);
            }
            boolean divisible = false;
            for (int i5 = 0; i5 < smallPrimes.size(); ++i5) {
                if (!g2.modPow(phi_n.divide((BigInteger)smallPrimes.elementAt(i5)), n2).equals(ONE)) continue;
                if (debug) {
                    System.out.println("g has order phi(n)/" + smallPrimes.elementAt(i5) + "\n g: " + g2);
                }
                divisible = true;
                break;
            }
            if (divisible) continue;
            if (g2.modPow(phi_n.divide(BigInteger.valueOf(4L)), n2).equals(ONE)) {
                if (!debug) continue;
                System.out.println("g has order phi(n)/4\n g:" + g2);
                continue;
            }
            if (g2.modPow(phi_n.divide(p_), n2).equals(ONE)) {
                if (!debug) continue;
                System.out.println("g has order phi(n)/p'\n g: " + g2);
                continue;
            }
            if (g2.modPow(phi_n.divide(q_), n2).equals(ONE)) {
                if (!debug) continue;
                System.out.println("g has order phi(n)/q'\n g: " + g2);
                continue;
            }
            if (g2.modPow(phi_n.divide(a2), n2).equals(ONE)) {
                if (!debug) continue;
                System.out.println("g has order phi(n)/a\n g: " + g2);
                continue;
            }
            if (!g2.modPow(phi_n.divide(b2), n2).equals(ONE)) break;
            if (!debug) continue;
            System.out.println("g has order phi(n)/b\n g: " + g2);
        }
        if (debug) {
            System.out.println("needed " + tries + " tries to generate g");
            System.out.println();
            System.out.println("found new NaccacheStern cipher variables:");
            System.out.println("smallPrimes: " + smallPrimes);
            System.out.println("sigma:...... " + sigma + " (" + sigma.bitLength() + " bits)");
            System.out.println("a:.......... " + a2);
            System.out.println("b:.......... " + b2);
            System.out.println("p':......... " + p_);
            System.out.println("q':......... " + q_);
            System.out.println("p:.......... " + p2);
            System.out.println("q:.......... " + q2);
            System.out.println("n:.......... " + n2);
            System.out.println("phi(n):..... " + phi_n);
            System.out.println("g:.......... " + g2);
            System.out.println();
        }
        return new AsymmetricCipherKeyPair(new NaccacheSternKeyParameters(false, g2, n2, sigma.bitLength()), new NaccacheSternPrivateKeyParameters(g2, n2, sigma.bitLength(), smallPrimes, phi_n));
    }

    private static BigInteger generatePrime(int bitLength, int certainty, SecureRandom rand) {
        BigInteger p_ = new BigInteger(bitLength, certainty, rand);
        while (p_.bitLength() != bitLength) {
            p_ = new BigInteger(bitLength, certainty, rand);
        }
        return p_;
    }

    private static Vector permuteList(Vector arr, SecureRandom rand) {
        Vector retval = new Vector();
        Vector tmp = new Vector();
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            tmp.addElement(arr.elementAt(i2));
        }
        retval.addElement(tmp.elementAt(0));
        tmp.removeElementAt(0);
        while (tmp.size() != 0) {
            retval.insertElementAt(tmp.elementAt(0), NaccacheSternKeyPairGenerator.getInt(rand, retval.size() + 1));
            tmp.removeElementAt(0);
        }
        return retval;
    }

    private static int getInt(SecureRandom rand, int n2) {
        int val;
        int bits;
        if ((n2 & -n2) == n2) {
            return (int)((long)n2 * (long)(rand.nextInt() & Integer.MAX_VALUE) >> 31);
        }
        while ((bits = rand.nextInt() & Integer.MAX_VALUE) - (val = bits % n2) + (n2 - 1) < 0) {
        }
        return val;
    }

    private static Vector findFirstPrimes(int count) {
        Vector<BigInteger> primes = new Vector<BigInteger>(count);
        for (int i2 = 0; i2 != count; ++i2) {
            primes.addElement(BigInteger.valueOf(smallPrimes[i2]));
        }
        return primes;
    }
}

