/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontSizeManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    public StringMap getIdentifiers() {
        return values;
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-size";
    }

    public int getPropertyType() {
        return 39;
    }

    public Value getDefaultValue() {
        return ValueConstants.MEDIUM_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String s2 = lu.getStringValue().toLowerCase().intern();
                Object v2 = values.get(s2);
                if (v2 == null) {
                    throw this.createInvalidIdentifierDOMException(s2);
                }
                return (Value)v2;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value createStringValue(short type, String value, CSSEngine engine) throws DOMException {
        if (type != 21) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object v2 = values.get(value.toLowerCase().intern());
        if (v2 == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return (Value)v2;
    }

    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        float scale = 1.0f;
        boolean doParentRelative = false;
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext ctx = engine.getCSSContext();
                float v2 = value.getFloatValue();
                return new FloatValue(1, v2 / ctx.getPixelUnitToMillimeter());
            }
            case 6: {
                CSSContext ctx = engine.getCSSContext();
                float v2 = value.getFloatValue();
                return new FloatValue(1, v2 * 10.0f / ctx.getPixelUnitToMillimeter());
            }
            case 8: {
                CSSContext ctx = engine.getCSSContext();
                float v2 = value.getFloatValue();
                return new FloatValue(1, v2 * 25.4f / ctx.getPixelUnitToMillimeter());
            }
            case 9: {
                CSSContext ctx = engine.getCSSContext();
                float v2 = value.getFloatValue();
                return new FloatValue(1, v2 * 25.4f / (72.0f * ctx.getPixelUnitToMillimeter()));
            }
            case 10: {
                CSSContext ctx = engine.getCSSContext();
                float v2 = value.getFloatValue();
                return new FloatValue(1, v2 * 25.4f / (6.0f * ctx.getPixelUnitToMillimeter()));
            }
            case 3: {
                doParentRelative = true;
                scale = value.getFloatValue();
                break;
            }
            case 4: {
                doParentRelative = true;
                scale = value.getFloatValue() * 0.5f;
                break;
            }
            case 2: {
                doParentRelative = true;
                scale = value.getFloatValue() * 0.01f;
                break;
            }
        }
        if (value == ValueConstants.LARGER_VALUE) {
            doParentRelative = true;
            scale = 1.2f;
        } else if (value == ValueConstants.SMALLER_VALUE) {
            doParentRelative = true;
            scale = 0.8333333f;
        }
        if (doParentRelative) {
            float fs;
            sm.putParentRelative(idx, true);
            CSSStylableElement p2 = CSSEngine.getParentCSSStylableElement(elt);
            if (p2 == null) {
                CSSContext ctx = engine.getCSSContext();
                fs = ctx.getMediumFontSize();
            } else {
                fs = engine.getComputedStyle(p2, null, idx).getFloatValue();
            }
            return new FloatValue(1, fs * scale);
        }
        CSSContext ctx = engine.getCSSContext();
        float fs = ctx.getMediumFontSize();
        String s2 = value.getStringValue();
        block11 : switch (s2.charAt(0)) {
            case 'm': {
                break;
            }
            case 's': {
                fs = (float)((double)fs / 1.2);
                break;
            }
            case 'l': {
                fs = (float)((double)fs * 1.2);
                break;
            }
            default: {
                switch (s2.charAt(1)) {
                    case 'x': {
                        switch (s2.charAt(3)) {
                            case 's': {
                                fs = (float)((double)fs / 1.2 / 1.2 / 1.2);
                                break block11;
                            }
                        }
                        fs = (float)((double)fs * 1.2 * 1.2 * 1.2);
                        break block11;
                    }
                }
                switch (s2.charAt(2)) {
                    case 's': {
                        fs = (float)((double)fs / 1.2 / 1.2);
                        break block11;
                    }
                }
                fs = (float)((double)fs * 1.2 * 1.2);
            }
        }
        return new FloatValue(1, fs);
    }

    protected int getOrientation() {
        return 1;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("large", ValueConstants.LARGE_VALUE);
        values.put("larger", ValueConstants.LARGER_VALUE);
        values.put("medium", ValueConstants.MEDIUM_VALUE);
        values.put("small", ValueConstants.SMALL_VALUE);
        values.put("smaller", ValueConstants.SMALLER_VALUE);
        values.put("x-large", ValueConstants.X_LARGE_VALUE);
        values.put("x-small", ValueConstants.X_SMALL_VALUE);
        values.put("xx-large", ValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", ValueConstants.XX_SMALL_VALUE);
    }
}

