/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class ThreadPool<T> {
    final String _name;
    final int _maxThreads;
    private final AtomicInteger _inProgress = new AtomicInteger(0);
    private final List<MyThread> _threads = new Vector<MyThread>();
    private final BlockingQueue<T> _queue;
    private final MyThreadGroup _myThreadGroup;

    public ThreadPool(String name, int numThreads) {
        this(name, numThreads, Integer.MAX_VALUE);
    }

    public ThreadPool(String name, int numThreads, int maxQueueSize) {
        this._name = name;
        this._maxThreads = numThreads;
        this._queue = new LinkedBlockingQueue<T>(maxQueueSize);
        this._myThreadGroup = new MyThreadGroup();
        this._threads.add(new MyThread());
    }

    public abstract void handle(T var1) throws Exception;

    public abstract void handleError(T var1, Exception var2);

    public int queueSize() {
        return this._queue.size();
    }

    public boolean offer(T t2) {
        if ((this._queue.size() > 0 || this._inProgress.get() == this._threads.size()) && this._threads.size() < this._maxThreads) {
            this._threads.add(new MyThread());
        }
        return this._queue.offer(t2);
    }

    public int inProgress() {
        return this._inProgress.get();
    }

    public int numThreads() {
        return this._threads.size();
    }

    class MyThread
    extends Thread {
        MyThread() {
            super((ThreadGroup)ThreadPool.this._myThreadGroup, "ThreadPool.MyThread:" + ThreadPool.this._name + ":" + ThreadPool.this._threads.size());
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object t2 = null;
                try {
                    t2 = ThreadPool.this._queue.take();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (t2 == null) continue;
                try {
                    ThreadPool.this._inProgress.incrementAndGet();
                    ThreadPool.this.handle(t2);
                    continue;
                }
                catch (Exception e2) {
                    ThreadPool.this.handleError(t2, e2);
                    continue;
                }
                finally {
                    ThreadPool.this._inProgress.decrementAndGet();
                    continue;
                }
                break;
            }
        }
    }

    class MyThreadGroup
    extends ThreadGroup {
        MyThreadGroup() {
            super("ThreadPool.MyThreadGroup:" + ThreadPool.this._name);
        }

        public void uncaughtException(Thread t2, Throwable e2) {
            for (int i2 = 0; i2 < ThreadPool.this._threads.size(); ++i2) {
                if (ThreadPool.this._threads.get(i2) != t2) continue;
                ThreadPool.this._threads.remove(i2);
                break;
            }
        }
    }
}

