/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import com.google.java.contract.Requires;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.gatk.engine.GenomeAnalysisEngine;
import org.broadinstitute.gatk.engine.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.gatk.engine.refdata.tracks.FeatureManager;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.interval.IntervalUtils;

public final class IntervalBinding<T extends Feature> {
    private RodBinding<T> featureIntervals;
    private String stringIntervals;

    @Requires(value={"type != null", "rawName != null", "source != null", "tribbleType != null", "tags != null"})
    public IntervalBinding(Class<T> type, String rawName, String source, String tribbleType, Tags tags) {
        this.featureIntervals = new RodBinding<T>(type, rawName, source, tribbleType, tags);
    }

    @Requires(value={"intervalArgument != null"})
    public IntervalBinding(String intervalArgument) {
        this.stringIntervals = intervalArgument;
    }

    public String getSource() {
        return this.featureIntervals != null ? this.featureIntervals.getSource() : this.stringIntervals;
    }

    public List<GenomeLoc> getIntervals(GenomeAnalysisEngine toolkit) {
        return this.getIntervals(toolkit.getGenomeLocParser());
    }

    public List<GenomeLoc> getIntervals(GenomeLocParser genomeLocParser) {
        ArrayList<GenomeLoc> intervals;
        if (this.featureIntervals != null) {
            intervals = new ArrayList();
            FeatureCodec codec = new FeatureManager().getByName(this.featureIntervals.getTribbleType()).getCodec();
            if (codec instanceof ReferenceDependentFeatureCodec) {
                ((ReferenceDependentFeatureCodec)codec).setGenomeLocParser(genomeLocParser);
            }
            try {
                AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(this.featureIntervals.getSource(), codec, false);
                for (Feature feature : reader.iterator()) {
                    intervals.add(genomeLocParser.createGenomeLoc(feature));
                }
            }
            catch (Exception e2) {
                throw new UserException.MalformedFile(this.featureIntervals.getSource(), "Problem reading the interval file", e2);
            }
        } else {
            intervals = IntervalUtils.parseIntervalArguments(genomeLocParser, this.stringIntervals);
        }
        Collections.sort(intervals);
        return intervals;
    }

    public String toString() {
        return this.getSource();
    }
}

