/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.cursor.CursorMainWindow;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.cursor.RegionFilter;

public class CursorModel {
    public static int frameBPWidth = 1000;
    private List<CursorTrack> tracks;
    private List<CursorRegion> regions;
    private List<CursorRegion> filteredRegions;
    private RegionFilter filter;
    private double framePixelWidth = 24.0;
    int frameMargin = 6;
    private double origin = 0.0;
    private int framePixelHeight = 50;
    CursorTrack sortedTrack;
    CursorMainWindow mainWindow;

    public CursorModel(CursorMainWindow cursorMainWindow) {
        this.mainWindow = cursorMainWindow;
    }

    public List<CursorTrack> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<CursorTrack> tracks) {
        this.tracks = tracks;
    }

    public void setRegions(List<CursorRegion> frames) {
        this.regions = frames;
        this.updateFilteredRegions();
    }

    private void updateFilteredRegions() {
        if (this.filter == null || this.regions == null) {
            this.filteredRegions = null;
        } else {
            this.filteredRegions = new ArrayList<CursorRegion>();
            for (CursorRegion r2 : this.regions) {
                if (!this.filter.pass(r2)) continue;
                this.filteredRegions.add(r2);
            }
        }
        this.mainWindow.updateRegionsLabel();
    }

    public List<CursorRegion> getFilteredRegions() {
        return this.filteredRegions == null ? this.regions : this.filteredRegions;
    }

    public RegionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RegionFilter filter) {
        this.filter = filter;
        this.updateFilteredRegions();
    }

    public double getFramePixelWidth() {
        return this.framePixelWidth;
    }

    public void setFramePixelWidth(double framePixelWidth) {
        this.framePixelWidth = framePixelWidth;
        this.frameMargin = (int)Math.min(8.0, framePixelWidth / 4.0);
        this.mainWindow.updateRegionsLabel();
    }

    public int getFrameBPWidth() {
        return frameBPWidth;
    }

    public void setFrameBPWidth(int frameBPWidth) {
        CursorModel.frameBPWidth = frameBPWidth;
        this.mainWindow.updateRegionsLabel();
    }

    public double getOrigin() {
        return this.origin;
    }

    public void setOrigin(double origin) {
        this.origin = origin;
    }

    public int getTrackPixelHeight() {
        return this.framePixelHeight;
    }

    public void setFramePixelHeight(int framePixelHeight) {
        this.framePixelHeight = framePixelHeight;
    }

    public void addTrack(CursorTrack t2) {
        if (this.tracks == null) {
            this.tracks = new ArrayList<CursorTrack>();
        }
        this.tracks.add(t2);
    }

    public void sortFrames(final CursorTrack t2, final int sortDirection) {
        this.sortedTrack = t2;
        Collections.shuffle(this.regions);
        Collections.sort(this.regions, new Comparator<CursorRegion>(){

            @Override
            public int compare(CursorRegion cursorRegion1, CursorRegion cursorRegion2) {
                double s2;
                double s1 = cursorRegion1.getScore(t2, frameBPWidth);
                return sortDirection * (s1 == (s2 = cursorRegion2.getScore(t2, frameBPWidth)) ? 0 : (s1 > s2 ? -1 : 1));
            }
        });
    }

    public void shiftOriginPixels(int delta) {
        this.origin = Math.max(0.0, this.origin + (double)delta / this.framePixelWidth);
    }

    public int getFrameMargin() {
        return this.frameMargin;
    }

    public CursorTrack getSortedTrack() {
        return this.sortedTrack;
    }
}

