/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class LaguerreSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    private final PolynomialFunction p;

    @Deprecated
    public LaguerreSolver(UnivariateRealFunction f2) throws IllegalArgumentException {
        super(f2, 100, 1.0E-6);
        if (!(f2 instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        this.p = (PolynomialFunction)f2;
    }

    @Deprecated
    public LaguerreSolver() {
        super(100, 1.0E-6);
        this.p = null;
    }

    @Deprecated
    public PolynomialFunction getPolynomialFunction() {
        return new PolynomialFunction(this.p.getCoefficients());
    }

    @Deprecated
    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max);
    }

    @Deprecated
    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max, initial);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max, initial);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        if (f2.value(min) == 0.0) {
            return min;
        }
        if (f2.value(max) == 0.0) {
            return max;
        }
        if (f2.value(initial) == 0.0) {
            return initial;
        }
        this.verifyBracketing(min, max, f2);
        this.verifySequence(min, initial, max);
        if (this.isBracketing(min, initial, f2)) {
            return this.solve(f2, min, initial);
        }
        return this.solve(f2, initial, max);
    }

    public double solve(int maxEval, UnivariateRealFunction f2, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f2, min, max);
    }

    @Deprecated
    public double solve(UnivariateRealFunction f2, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        if (!(f2 instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        if (f2.value(min) == 0.0) {
            return min;
        }
        if (f2.value(max) == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max, f2);
        double[] coefficients = ((PolynomialFunction)f2).getCoefficients();
        Complex[] c2 = new Complex[coefficients.length];
        for (int i2 = 0; i2 < coefficients.length; ++i2) {
            c2[i2] = new Complex(coefficients[i2], 0.0);
        }
        Complex initial = new Complex(0.5 * (min + max), 0.0);
        Complex z = this.solve(c2, initial);
        if (this.isRootOK(min, max, z)) {
            this.setResult(z.getReal(), this.iterationCount);
            return this.result;
        }
        Complex[] root = this.solveAll(c2, initial);
        for (int i3 = 0; i3 < root.length; ++i3) {
            if (!this.isRootOK(min, max, root[i3])) continue;
            this.setResult(root[i3].getReal(), this.iterationCount);
            return this.result;
        }
        throw new ConvergenceException();
    }

    protected boolean isRootOK(double min, double max, Complex z) {
        double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
        return this.isSequence(min, z.getReal(), max) && (FastMath.abs(z.getImaginary()) <= tolerance || z.abs() <= this.functionValueAccuracy);
    }

    @Deprecated
    public Complex[] solveAll(double[] coefficients, double initial) throws ConvergenceException, FunctionEvaluationException {
        Complex[] c2 = new Complex[coefficients.length];
        Complex z = new Complex(initial, 0.0);
        for (int i2 = 0; i2 < c2.length; ++i2) {
            c2[i2] = new Complex(coefficients[i2], 0.0);
        }
        return this.solveAll(c2, z);
    }

    @Deprecated
    public Complex[] solveAll(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n2 = coefficients.length - 1;
        int iterationCount = 0;
        if (n2 < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n2);
        }
        Complex[] c2 = new Complex[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            c2[i2] = coefficients[i2];
        }
        Complex[] root = new Complex[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            Complex[] subarray = new Complex[n2 - i3 + 1];
            System.arraycopy(c2, 0, subarray, 0, subarray.length);
            root[i3] = this.solve(subarray, initial);
            Complex newc = c2[n2 - i3];
            Complex oldc = null;
            for (int j2 = n2 - i3 - 1; j2 >= 0; --j2) {
                oldc = c2[j2];
                c2[j2] = newc;
                newc = oldc.add(newc.multiply(root[i3]));
            }
            iterationCount += this.iterationCount;
        }
        this.resultComputed = true;
        this.iterationCount = iterationCount;
        return root;
    }

    @Deprecated
    public Complex solve(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n2 = coefficients.length - 1;
        if (n2 < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n2);
        }
        Complex N = new Complex(n2, 0.0);
        Complex N1 = new Complex(n2 - 1, 0.0);
        Complex pv = null;
        Complex dv = null;
        Complex d2v = null;
        Complex G = null;
        Complex G2 = null;
        Complex H = null;
        Complex delta = null;
        Complex denominator = null;
        Complex z = initial;
        Complex oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (int i2 = 1; i2 <= this.maximalIterationCount; ++i2) {
            pv = coefficients[n2];
            dv = Complex.ZERO;
            d2v = Complex.ZERO;
            for (int j2 = n2 - 1; j2 >= 0; --j2) {
                d2v = dv.add(z.multiply(d2v));
                dv = pv.add(z.multiply(dv));
                pv = coefficients[j2].add(z.multiply(pv));
            }
            d2v = d2v.multiply(new Complex(2.0, 0.0));
            double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
            if (z.subtract(oldz).abs() <= tolerance) {
                this.resultComputed = true;
                this.iterationCount = i2;
                return z;
            }
            if (pv.abs() <= this.functionValueAccuracy) {
                this.resultComputed = true;
                this.iterationCount = i2;
                return z;
            }
            G = dv.divide(pv);
            G2 = G.multiply(G);
            H = G2.subtract(d2v.divide(pv));
            delta = N1.multiply(N.multiply(H).subtract(G2));
            Complex deltaSqrt = delta.sqrt();
            Complex dplus = G.add(deltaSqrt);
            Complex dminus = G.subtract(deltaSqrt);
            Complex complex = denominator = dplus.abs() > dminus.abs() ? dplus : dminus;
            if (denominator.equals(new Complex(0.0, 0.0))) {
                z = z.add(new Complex(this.absoluteAccuracy, this.absoluteAccuracy));
                oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                continue;
            }
            oldz = z;
            z = z.subtract(N.divide(denominator));
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

