/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.batik.ext.awt.geom.Segment;

public abstract class AbstractSegment
implements Segment {
    static final double eps = 3.552713678800501E-15;
    static final double tol = 1.4210854715202004E-14;

    protected abstract int findRoots(double var1, double[] var3);

    public Segment.SplitResults split(double y) {
        Segment[] below;
        Segment[] above;
        double[] roots = new double[]{0.0, 0.0, 0.0};
        int numSol = this.findRoots(y, roots);
        if (numSol == 0) {
            return null;
        }
        Arrays.sort(roots, 0, numSol);
        double[] segs = new double[numSol + 2];
        int numSegments = 0;
        segs[numSegments++] = 0.0;
        int i2 = 0;
        while (i2 < numSol) {
            double r2 = roots[i2];
            if (!(r2 <= 0.0)) {
                if (r2 >= 1.0) break;
                if (segs[numSegments - 1] != r2) {
                    segs[numSegments++] = r2;
                }
            }
            ++i2;
        }
        segs[numSegments++] = 1.0;
        if (numSegments == 2) {
            return null;
        }
        Segment[] parts = new Segment[numSegments];
        double pT = 0.0;
        int pIdx = 0;
        boolean firstAbove = false;
        boolean prevAbove = false;
        int i3 = 1;
        while (i3 < numSegments) {
            parts[pIdx] = this.getSegment(segs[i3 - 1], segs[i3]);
            Point2D.Double pt = parts[pIdx].eval(0.5);
            if (pIdx == 0) {
                ++pIdx;
                prevAbove = pt.y < y;
                firstAbove = prevAbove;
            } else {
                boolean above2;
                boolean bl = above2 = pt.y < y;
                if (prevAbove == above2) {
                    parts[pIdx - 1] = this.getSegment(pT, segs[i3]);
                } else {
                    ++pIdx;
                    pT = segs[i3 - 1];
                    prevAbove = above2;
                }
            }
            ++i3;
        }
        if (pIdx == 1) {
            return null;
        }
        if (firstAbove) {
            above = new Segment[(pIdx + 1) / 2];
            below = new Segment[pIdx / 2];
        } else {
            above = new Segment[pIdx / 2];
            below = new Segment[(pIdx + 1) / 2];
        }
        int ai = 0;
        int bi = 0;
        int i4 = 0;
        while (i4 < pIdx) {
            if (firstAbove) {
                above[ai++] = parts[i4];
            } else {
                below[bi++] = parts[i4];
            }
            firstAbove = !firstAbove;
            ++i4;
        }
        return new Segment.SplitResults(below, above);
    }

    public Segment splitBefore(double t2) {
        return this.getSegment(0.0, t2);
    }

    public Segment splitAfter(double t2) {
        return this.getSegment(t2, 1.0);
    }

    public static int solveLine(double a2, double b2, double[] roots) {
        if (a2 == 0.0) {
            if (b2 != 0.0) {
                return 0;
            }
            roots[0] = 0.0;
            return 1;
        }
        roots[0] = -b2 / a2;
        return 1;
    }

    public static int solveQuad(double a2, double b2, double c2, double[] roots) {
        if (a2 == 0.0) {
            return AbstractSegment.solveLine(b2, c2, roots);
        }
        double det = b2 * b2 - 4.0 * a2 * c2;
        if (Math.abs(det) <= 1.4210854715202004E-14 * b2 * b2) {
            roots[0] = -b2 / (2.0 * a2);
            return 1;
        }
        if (det < 0.0) {
            return 0;
        }
        det = Math.sqrt(det);
        double w2 = -(b2 + AbstractSegment.matchSign(det, b2));
        roots[0] = 2.0 * c2 / w2;
        roots[1] = w2 / (2.0 * a2);
        return 2;
    }

    public static double matchSign(double a2, double b2) {
        if (b2 < 0.0) {
            return a2 < 0.0 ? a2 : -a2;
        }
        return a2 > 0.0 ? a2 : -a2;
    }

    public static int solveCubic(double a3, double a2, double a1, double a0, double[] roots) {
        double[] dRoots = new double[]{0.0, 0.0};
        int dCnt = AbstractSegment.solveQuad(3.0 * a3, 2.0 * a2, a1, dRoots);
        double[] yVals = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] tVals = new double[]{0.0, 0.0, 0.0, 0.0};
        int yCnt = 0;
        yVals[yCnt] = a0;
        tVals[yCnt++] = 0.0;
        switch (dCnt) {
            case 1: {
                double r2 = dRoots[0];
                if (!(r2 > 0.0) || !(r2 < 1.0)) break;
                yVals[yCnt] = ((a3 * r2 + a2) * r2 + a1) * r2 + a0;
                tVals[yCnt++] = r2;
                break;
            }
            case 2: {
                double r2;
                if (dRoots[0] > dRoots[1]) {
                    double t2 = dRoots[0];
                    dRoots[0] = dRoots[1];
                    dRoots[1] = t2;
                }
                if ((r2 = dRoots[0]) > 0.0 && r2 < 1.0) {
                    yVals[yCnt] = ((a3 * r2 + a2) * r2 + a1) * r2 + a0;
                    tVals[yCnt++] = r2;
                }
                if (!((r2 = dRoots[1]) > 0.0) || !(r2 < 1.0)) break;
                yVals[yCnt] = ((a3 * r2 + a2) * r2 + a1) * r2 + a0;
                tVals[yCnt++] = r2;
                break;
            }
        }
        yVals[yCnt] = a3 + a2 + a1 + a0;
        tVals[yCnt++] = 1.0;
        int ret = 0;
        int i2 = 0;
        while (i2 < yCnt - 1) {
            double y0 = yVals[i2];
            double t0 = tVals[i2];
            double y1 = yVals[i2 + 1];
            double t1 = tVals[i2 + 1];
            if (!(y0 < 0.0 && y1 < 0.0 || y0 > 0.0 && y1 > 0.0)) {
                if (y0 > y1) {
                    double t3 = y0;
                    y0 = y1;
                    y1 = t3;
                    t3 = t0;
                    t0 = t1;
                    t1 = t3;
                }
                if (-y0 < 1.4210854715202004E-14 * y1) {
                    roots[ret++] = t0;
                } else if (y1 < -1.4210854715202004E-14 * y0) {
                    roots[ret++] = t1;
                    ++i2;
                } else {
                    double epsZero = 1.4210854715202004E-14 * (y1 - y0);
                    int cnt = 0;
                    while (cnt < 20) {
                        double dt = t1 - t0;
                        double dy = y1 - y0;
                        double t4 = t0 + (Math.abs(y0 / dy) * 99.0 + 0.5) * dt / 100.0;
                        double v2 = ((a3 * t4 + a2) * t4 + a1) * t4 + a0;
                        if (Math.abs(v2) < epsZero) {
                            roots[ret++] = t4;
                            break;
                        }
                        if (v2 < 0.0) {
                            t0 = t4;
                            y0 = v2;
                        } else {
                            t1 = t4;
                            y1 = v2;
                        }
                        ++cnt;
                    }
                    if (cnt == 20) {
                        roots[ret++] = (t0 + t1) / 2.0;
                    }
                }
            }
            ++i2;
        }
        return ret;
    }

    public abstract double getLength(double var1);

    public abstract double getLength();

    public abstract void subdivide(double var1, Segment var3, Segment var4);

    public abstract void subdivide(Segment var1, Segment var2);

    public abstract Segment getSegment(double var1, double var3);

    public abstract Point2D.Double eval(double var1);

    public abstract Point2D.Double evalDt(double var1);

    public abstract Rectangle2D getBounds2D();

    public abstract double maxY();

    public abstract double minY();

    public abstract double maxX();

    public abstract double minX();
}

