/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ResizableMouseInputAdapter
extends MouseInputAdapter {
    private static Rectangle _startingBounds;
    private int _eventMouseScreenX;
    private int _eventMouseScreenY;
    private int _resizeCorner;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private Resizable _resizable;

    public ResizableMouseInputAdapter(Resizable resizable) {
        this._resizable = resizable;
    }

    private boolean isResizable(int resizeDir) {
        return this._resizable != null && (this._resizable.getResizableCorners() & resizeDir) != 0;
    }

    public void mousePressed(MouseEvent e2) {
        this._resizeCorner = 0;
        _startingBounds = this._resizable.getComponent().getBounds();
        if (this._resizable.isTopLevel()) {
            Point location = new Point(ResizableMouseInputAdapter._startingBounds.x, ResizableMouseInputAdapter._startingBounds.y);
            SwingUtilities.convertPointToScreen(location, this._resizable.getComponent());
            ResizableMouseInputAdapter._startingBounds.x = location.x;
            ResizableMouseInputAdapter._startingBounds.y = location.y;
        }
        Point p2 = new Point(e2.getX(), e2.getY());
        SwingUtilities.convertPointToScreen(p2, (Component)e2.getSource());
        this._eventMouseScreenX = p2.x;
        this._eventMouseScreenY = p2.y;
        if (e2.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner corner = (Resizable.ResizeCorner)e2.getSource();
            this._resizeCorner = corner.getCorner();
        } else if (e2.getSource() == this._resizable.getComponent()) {
            Insets i2 = this._resizable.getResizeInsets();
            if (e2.getX() <= i2.left) {
                this._resizeCorner = i2.top > 0 && e2.getY() < this._resizable.getResizeCornerSize() + i2.top ? 1 : (i2.bottom > 0 && e2.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - i2.bottom ? 64 : 128);
            } else if (i2.right > 0 && e2.getX() >= this._resizable.getComponent().getWidth() - i2.right) {
                this._resizeCorner = i2.top > 0 && e2.getY() < this._resizable.getResizeCornerSize() + i2.top ? 4 : (i2.bottom > 0 && e2.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - i2.bottom ? 16 : 8);
            } else if (i2.top > 0 && e2.getY() <= i2.top) {
                this._resizeCorner = i2.left > 0 && e2.getX() < this._resizable.getResizeCornerSize() + i2.left ? 1 : (i2.right > 0 && e2.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - i2.right ? 4 : 2);
            } else if (i2.bottom > 0 && e2.getY() >= this._resizable.getComponent().getHeight() - i2.bottom) {
                this._resizeCorner = i2.left > 0 && e2.getX() < this._resizable.getResizeCornerSize() + i2.left ? 64 : (i2.right > 0 && e2.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - i2.right ? 16 : 32);
            } else {
                this._discardRelease = true;
                return;
            }
        }
        Cursor s2 = Cursor.getDefaultCursor();
        if (this.isResizable(this._resizeCorner)) {
            boolean ltr = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
            switch (this._resizeCorner) {
                case 32: {
                    s2 = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 2: {
                    s2 = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 128: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 10 : 11);
                    break;
                }
                case 8: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 11 : 10);
                    break;
                }
                case 16: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 5 : 4);
                    break;
                }
                case 64: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 4 : 5);
                    break;
                }
                case 1: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 6 : 7);
                    break;
                }
                case 4: {
                    s2 = Cursor.getPredefinedCursor(ltr ? 7 : 6);
                }
            }
            Container c2 = this._resizable.getComponent().getTopLevelAncestor();
            if (c2 instanceof JFrame) {
                ((JFrame)c2).getGlassPane().setVisible(true);
                ((JFrame)c2).getGlassPane().setCursor(s2);
            } else if (c2 instanceof JApplet) {
                ((JApplet)c2).getGlassPane().setVisible(true);
                ((JApplet)c2).getGlassPane().setCursor(s2);
            } else if (c2 instanceof JWindow) {
                ((JWindow)c2).getGlassPane().setVisible(true);
                ((JWindow)c2).getGlassPane().setCursor(s2);
            } else if (c2 instanceof JDialog) {
                ((JDialog)c2).getGlassPane().setVisible(true);
                ((JDialog)c2).getGlassPane().setCursor(s2);
            }
            this._resizable.beginResizing(this._resizeCorner);
        } else {
            this._resizeCorner = 0;
        }
    }

    public void mouseDragged(MouseEvent e2) {
        int newH;
        int newW;
        if (_startingBounds == null) {
            return;
        }
        Point p2 = new Point(e2.getX(), e2.getY());
        Component c2 = (Component)e2.getSource();
        SwingUtilities.convertPointToScreen(p2, c2);
        int deltaX = this._eventMouseScreenX - p2.x;
        int deltaY = this._eventMouseScreenY - p2.y;
        Dimension min = this._resizable.getComponent().getMinimumSize();
        Dimension max = this._resizable.getComponent().getMaximumSize();
        Point point = new Point(this._resizable.getComponent().getX(), this._resizable.getComponent().getY());
        if (this._resizable.isTopLevel()) {
            SwingUtilities.convertPointToScreen(point, this._resizable.getComponent());
        }
        int newX = point.x;
        int newY = point.y;
        Rectangle parentBounds = this._resizable.isTopLevel() ? new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE) : this._resizable.getComponent().getParent().getBounds();
        int actualResizeCorner = this._resizeCorner;
        boolean ltr = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
        if (!ltr) {
            switch (this._resizeCorner) {
                case 1: {
                    actualResizeCorner = 4;
                }
                case 4: {
                    actualResizeCorner = 1;
                }
                case 64: {
                    actualResizeCorner = 16;
                }
                case 16: {
                    actualResizeCorner = 64;
                }
                case 128: {
                    actualResizeCorner = 8;
                }
                case 8: {
                    actualResizeCorner = 128;
                }
            }
        }
        int snapGridSize = this._resizable.getSnapGridSize();
        switch (actualResizeCorner) {
            case 0: {
                return;
            }
            case 2: {
                if (ResizableMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(ResizableMouseInputAdapter._startingBounds.height - min.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                newX = ResizableMouseInputAdapter._startingBounds.x;
                newY = ResizableMouseInputAdapter._startingBounds.y - deltaY;
                if (snapGridSize > 0 && newY % snapGridSize != 0) {
                    newY = newY > 0 ? (newY % snapGridSize > snapGridSize / 2 ? (newY += snapGridSize - newY % snapGridSize) : (newY -= newY % snapGridSize)) : (-newY % snapGridSize > snapGridSize / 2 ? (newY -= snapGridSize - -newY % snapGridSize) : (newY += -newY % snapGridSize));
                }
                deltaY = ResizableMouseInputAdapter._startingBounds.y - newY;
                newW = ResizableMouseInputAdapter._startingBounds.width;
                newH = ResizableMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            case 4: {
                if (ResizableMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(ResizableMouseInputAdapter._startingBounds.height - min.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.width - min.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                newX = ResizableMouseInputAdapter._startingBounds.x;
                newY = ResizableMouseInputAdapter._startingBounds.y - deltaY;
                if (snapGridSize > 0 && newY % snapGridSize != 0) {
                    newY = newY > 0 ? (newY % snapGridSize > snapGridSize / 2 ? (newY += snapGridSize - newY % snapGridSize) : (newY -= newY % snapGridSize)) : (-newY % snapGridSize > snapGridSize / 2 ? (newY -= snapGridSize - -newY % snapGridSize) : (newY += -newY % snapGridSize));
                }
                deltaY = ResizableMouseInputAdapter._startingBounds.y - newY;
                newW = ResizableMouseInputAdapter._startingBounds.width - deltaX;
                if (snapGridSize > 0 && newW % snapGridSize != 0) {
                    newW = newW > 0 ? (newW % snapGridSize > snapGridSize / 2 ? (newW += snapGridSize - newW % snapGridSize) : (newW -= newW % snapGridSize)) : (-newW % snapGridSize > snapGridSize / 2 ? (newW -= snapGridSize - -newW % snapGridSize) : (newW += -newW % snapGridSize));
                }
                newH = ResizableMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            case 8: {
                if (ResizableMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.width - min.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                newW = ResizableMouseInputAdapter._startingBounds.width - deltaX;
                if (snapGridSize > 0 && newW % snapGridSize != 0) {
                    newW = newW > 0 ? (newW % snapGridSize > snapGridSize / 2 ? (newW += snapGridSize - newW % snapGridSize) : (newW -= newW % snapGridSize)) : (-newW % snapGridSize > snapGridSize / 2 ? (newW -= snapGridSize - -newW % snapGridSize) : (newW += -newW % snapGridSize));
                }
                newH = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 16: {
                if (ResizableMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.width - min.width;
                } else if (ResizableMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - ResizableMouseInputAdapter._startingBounds.width);
                }
                if (ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = ResizableMouseInputAdapter._startingBounds.x + ResizableMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.height - min.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                newW = ResizableMouseInputAdapter._startingBounds.width - deltaX;
                newH = ResizableMouseInputAdapter._startingBounds.height - deltaY;
                if (snapGridSize > 0 && newH % snapGridSize != 0) {
                    newH = newH > 0 ? (newH % snapGridSize > snapGridSize / 2 ? (newH += snapGridSize - newH % snapGridSize) : (newH -= newH % snapGridSize)) : (-newH % snapGridSize > snapGridSize / 2 ? (newH -= snapGridSize - -newH % snapGridSize) : (newH += -newH % snapGridSize));
                }
                if (snapGridSize <= 0 || newW % snapGridSize == 0) break;
                if (newW > 0) {
                    if (newW % snapGridSize > snapGridSize / 2) {
                        newW += snapGridSize - newW % snapGridSize;
                        break;
                    }
                    newW -= newW % snapGridSize;
                    break;
                }
                if (-newW % snapGridSize > snapGridSize / 2) {
                    newW -= snapGridSize - -newW % snapGridSize;
                    break;
                }
                newW += -newW % snapGridSize;
                break;
            }
            case 32: {
                if (ResizableMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.height - min.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                newW = ResizableMouseInputAdapter._startingBounds.width;
                newH = ResizableMouseInputAdapter._startingBounds.height - deltaY;
                if (snapGridSize <= 0 || newH % snapGridSize == 0) break;
                if (newH > 0) {
                    if (newH % snapGridSize > snapGridSize / 2) {
                        newH += snapGridSize - newH % snapGridSize;
                        break;
                    }
                    newH -= newH % snapGridSize;
                    break;
                }
                if (-newH % snapGridSize > snapGridSize / 2) {
                    newH -= snapGridSize - -newH % snapGridSize;
                    break;
                }
                newH += -newH % snapGridSize;
                break;
            }
            case 64: {
                if (ResizableMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.height - min.height;
                } else if (ResizableMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - ResizableMouseInputAdapter._startingBounds.height);
                }
                if (ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = ResizableMouseInputAdapter._startingBounds.y + ResizableMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                if (ResizableMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(ResizableMouseInputAdapter._startingBounds.width - min.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                newX = ResizableMouseInputAdapter._startingBounds.x - deltaX;
                if (snapGridSize > 0 && newX % snapGridSize != 0) {
                    newX = newX > 0 ? (newX % snapGridSize > snapGridSize / 2 ? (newX += snapGridSize - newX % snapGridSize) : (newX -= newX % snapGridSize)) : (-newX % snapGridSize > snapGridSize / 2 ? (newX -= snapGridSize - -newX % snapGridSize) : (newX += -newX % snapGridSize));
                }
                deltaX = ResizableMouseInputAdapter._startingBounds.x - newX;
                newY = ResizableMouseInputAdapter._startingBounds.y;
                newW = ResizableMouseInputAdapter._startingBounds.width + deltaX;
                newH = ResizableMouseInputAdapter._startingBounds.height - deltaY;
                if (snapGridSize <= 0 || newH % snapGridSize == 0) break;
                if (newH > 0) {
                    if (newH % snapGridSize > snapGridSize / 2) {
                        newH += snapGridSize - newH % snapGridSize;
                        break;
                    }
                    newH -= newH % snapGridSize;
                    break;
                }
                if (-newH % snapGridSize > snapGridSize / 2) {
                    newH -= snapGridSize - -newH % snapGridSize;
                    break;
                }
                newH += -newH % snapGridSize;
                break;
            }
            case 128: {
                if (ResizableMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(ResizableMouseInputAdapter._startingBounds.width - min.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                newX = ResizableMouseInputAdapter._startingBounds.x - deltaX;
                if (snapGridSize > 0 && newX % snapGridSize != 0) {
                    newX = newX > 0 ? (newX % snapGridSize > snapGridSize / 2 ? (newX += snapGridSize - newX % snapGridSize) : (newX -= newX % snapGridSize)) : (-newX % snapGridSize > snapGridSize / 2 ? (newX -= snapGridSize - -newX % snapGridSize) : (newX += -newX % snapGridSize));
                }
                deltaX = ResizableMouseInputAdapter._startingBounds.x - newX;
                newY = ResizableMouseInputAdapter._startingBounds.y;
                newW = ResizableMouseInputAdapter._startingBounds.width + deltaX;
                newH = ResizableMouseInputAdapter._startingBounds.height;
                break;
            }
            case 1: {
                if (ResizableMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(ResizableMouseInputAdapter._startingBounds.width - min.width);
                } else if (ResizableMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - ResizableMouseInputAdapter._startingBounds.width;
                }
                if (ResizableMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(ResizableMouseInputAdapter._startingBounds.height - min.height);
                } else if (ResizableMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - ResizableMouseInputAdapter._startingBounds.height;
                }
                newX = ResizableMouseInputAdapter._startingBounds.x - deltaX;
                if (snapGridSize > 0 && newX % snapGridSize != 0) {
                    newX = newX > 0 ? (newX % snapGridSize > snapGridSize / 2 ? (newX += snapGridSize - newX % snapGridSize) : (newX -= newX % snapGridSize)) : (-newX % snapGridSize > snapGridSize / 2 ? (newX -= snapGridSize - -newX % snapGridSize) : (newX += -newX % snapGridSize));
                }
                deltaX = ResizableMouseInputAdapter._startingBounds.x - newX;
                newY = ResizableMouseInputAdapter._startingBounds.y - deltaY;
                if (snapGridSize > 0 && newY % snapGridSize != 0) {
                    newY = newY > 0 ? (newY % snapGridSize > snapGridSize / 2 ? (newY += snapGridSize - newY % snapGridSize) : (newY -= newY % snapGridSize)) : (-newY % snapGridSize > snapGridSize / 2 ? (newY -= snapGridSize - -newY % snapGridSize) : (newY += -newY % snapGridSize));
                }
                deltaY = ResizableMouseInputAdapter._startingBounds.y - newY;
                newW = ResizableMouseInputAdapter._startingBounds.width + deltaX;
                newH = ResizableMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            default: {
                return;
            }
        }
        Rectangle screenBounds = PortingUtils.getScreenBounds(this._resizable.getComponent());
        newX = Math.max(newX, screenBounds.x);
        newY = Math.max(newY, screenBounds.y);
        if (newX + newW > screenBounds.width) {
            newW = screenBounds.width - newX;
        }
        if (newY + newH > screenBounds.height) {
            newH = screenBounds.height - newY;
        }
        this._resizable.resizing(this._resizeCorner, newX, newY, newW, newH);
    }

    public void mouseReleased(MouseEvent e2) {
        _startingBounds = null;
        if (this._discardRelease) {
            this._discardRelease = false;
            return;
        }
        if (this._resizeCorner != 0) {
            Container c2 = this._resizable.getComponent().getTopLevelAncestor();
            if (c2 instanceof JFrame) {
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JFrame)this._resizable.getComponent().getTopLevelAncestor()).getGlassPane().setVisible(false);
            } else if (c2 instanceof JApplet) {
                ((JApplet)c2).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JApplet)c2).getGlassPane().setVisible(false);
            } else if (c2 instanceof JWindow) {
                ((JWindow)c2).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JWindow)c2).getGlassPane().setVisible(false);
            } else if (c2 instanceof JDialog) {
                ((JDialog)c2).getGlassPane().setCursor(Cursor.getDefaultCursor());
                ((JDialog)c2).getGlassPane().setVisible(false);
            }
            this._resizable.endResizing(this._resizeCorner);
            this._eventMouseScreenX = 0;
            this._eventMouseScreenY = 0;
            _startingBounds = null;
            this._resizeCorner = 0;
        }
    }

    public void mouseMoved(MouseEvent e2) {
        if (e2.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner corner = (Resizable.ResizeCorner)e2.getSource();
            boolean ltr = corner.getComponentOrientation().isLeftToRight();
            switch (corner.getCorner()) {
                case 16: {
                    corner.setCursor(Cursor.getPredefinedCursor(ltr ? 5 : 4));
                    return;
                }
                case 4: {
                    corner.setCursor(Cursor.getPredefinedCursor(ltr ? 7 : 6));
                    return;
                }
                case 64: {
                    corner.setCursor(Cursor.getPredefinedCursor(ltr ? 4 : 5));
                    return;
                }
                case 1: {
                    corner.setCursor(Cursor.getPredefinedCursor(ltr ? 6 : 7));
                    return;
                }
            }
        } else if (e2.getSource() == this._resizable.getComponent()) {
            Insets i2 = this._resizable.getResizeInsets();
            boolean ltr = this._resizable.getComponent().getComponentOrientation().isLeftToRight();
            if (e2.getX() <= i2.left) {
                if (this.isResizable(1) && i2.top > 0 && e2.getY() < this._resizable.getResizeCornerSize() + i2.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 6 : 7));
                } else if (this.isResizable(64) && i2.bottom > 0 && e2.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - i2.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 4 : 5));
                } else if (this.isResizable(128)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 10 : 11));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (e2.getX() >= this._resizable.getComponent().getWidth() - i2.right) {
                if (this.isResizable(4) && i2.top > 0 && e2.getY() < this._resizable.getResizeCornerSize() + i2.top) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 7 : 6));
                } else if (this.isResizable(64) && i2.bottom > 0 && e2.getY() > this._resizable.getComponent().getHeight() - this._resizable.getResizeCornerSize() - i2.bottom) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 5 : 4));
                } else if (this.isResizable(8)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 11 : 10));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (e2.getY() <= i2.top) {
                if (this.isResizable(1) && i2.left > 0 && e2.getX() < this._resizable.getResizeCornerSize() + i2.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 6 : 7));
                } else if (this.isResizable(4) && i2.right > 0 && e2.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - i2.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 7 : 6));
                } else if (this.isResizable(2)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else if (e2.getY() >= this._resizable.getComponent().getHeight() - i2.bottom) {
                if (this.isResizable(64) && i2.left > 0 && e2.getX() < this._resizable.getResizeCornerSize() + i2.left) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 4 : 5));
                } else if (this.isResizable(16) && i2.right > 0 && e2.getX() > this._resizable.getComponent().getWidth() - this._resizable.getResizeCornerSize() - i2.right) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(ltr ? 5 : 4));
                } else if (this.isResizable(32)) {
                    this._resizable.getComponent().setCursor(Cursor.getPredefinedCursor(9));
                } else {
                    this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            } else {
                this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
            }
            return;
        }
        this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent e2) {
        if (e2.getSource() instanceof Resizable.ResizeCorner) {
            Resizable.ResizeCorner corner = (Resizable.ResizeCorner)e2.getSource();
            corner.setCursor(Cursor.getDefaultCursor());
        } else {
            this._resizable.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

