/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.pairhmm.FlexibleHMM;
import org.broadinstitute.gatk.utils.pairhmm.LoglessPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMReadyHaplotypes;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class FastLoglessPairHMM
extends LoglessPairHMM
implements FlexibleHMM {
    private static final int INITIAL_READ_LENGTH_CAPACITY = 200;
    private static final int INITIAL_HAPLOTYPE_LENGTH_CAPACITY = 400;
    private int readCapacity = 200;
    private int haplotypeCapacity = 400;
    private int maxToCol;
    private int haplotypeLength;
    private double[][] logTransition;
    private boolean indelToIndelIsConstant;
    private final byte constantGCP;
    private byte[] haplotypeBases;
    private byte[] readBases;
    private byte[] readQuals;
    private byte[] readInsQuals;
    private byte[] readDelQuals;
    private byte[] readGepQuals;
    private Map<Problem, Double> cachedResults = new HashMap<Problem, Double>();

    public byte[] getReadQuals() {
        if (this.readQuals == null) {
            throw new IllegalStateException("no read was loaded onto the pairhmm calculator");
        }
        return this.readQuals;
    }

    public byte[] getReadInsQuals() {
        if (this.readQuals == null) {
            throw new IllegalStateException("no read was loaded onto the pairhmm calculator");
        }
        return this.readInsQuals;
    }

    public byte[] getReadDelQuals() {
        if (this.readQuals == null) {
            throw new IllegalStateException("no read was loaded onto the pairhmm calculator");
        }
        return this.readDelQuals;
    }

    public byte[] getReadGepQuals() {
        if (this.readQuals == null) {
            throw new IllegalStateException("no read was loaded onto the pairhmm calculator");
        }
        return this.readGepQuals;
    }

    public FastLoglessPairHMM(byte gcp) {
        this.constantGCP = gcp;
        this.initialize(this.readCapacity, this.haplotypeCapacity);
    }

    @Override
    public byte getGapExtensionPenalty() {
        return this.constantGCP;
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        this.readBases = readBases;
        this.haplotypeBases = haplotypeBases;
        this.haplotypeLength = haplotypeBases.length;
        return super.subComputeReadLikelihoodGivenHaplotypeLog10(haplotypeBases, readBases, readQuals, insertionGOP, deletionGOP, overallGCP, hapStartIndex, recacheReadValues, nextHapStartIndex);
    }

    protected double finalLikelihoodCalculation(int row, int fromCol, int toCol) {
        double divider = Math.max(1, 2 * (toCol - fromCol));
        double dividerInverse = 1.0 / divider;
        double finalLikelihood = 0.0;
        for (int j2 = fromCol; j2 < toCol; ++j2) {
            finalLikelihood += this.matchMatrix[row][j2] * dividerInverse;
            finalLikelihood += this.insertionMatrix[row][j2] * dividerInverse;
        }
        return StrictMath.log10(finalLikelihood) - INITIAL_CONDITION_LOG10 + StrictMath.log10(divider);
    }

    protected void initializeMatrixValuesForTrailingProblem(int readStart, int readEnd, int haplotypeStartOffset) {
        block7: {
            int i2;
            int toCol;
            int toRow;
            int zeroRow;
            block6: {
                zeroRow = readStart;
                toRow = readEnd + 1;
                toCol = this.haplotypeLength + 1;
                if (readStart != 0) break block6;
                Arrays.fill(this.matchMatrix[zeroRow], haplotypeStartOffset, toCol, 0.0);
                Arrays.fill(this.deletionMatrix[zeroRow], haplotypeStartOffset, toCol, INITIAL_CONDITION);
                if (haplotypeStartOffset != 0) break block7;
                for (int i3 = zeroRow + 1; i3 < toRow; ++i3) {
                    this.deletionMatrix[i3][0] = 0.0;
                    this.matchMatrix[i3][0] = 0.0;
                    this.insertionMatrix[i3][0] = 0.0;
                }
                break block7;
            }
            Arrays.fill(this.matchMatrix[zeroRow], Math.max(1, haplotypeStartOffset), toCol, 0.0);
            Arrays.fill(this.insertionMatrix[zeroRow], haplotypeStartOffset, toCol, 0.0);
            if (haplotypeStartOffset == 0) {
                this.matchMatrix[zeroRow][0] = INITIAL_CONDITION;
                this.deletionMatrix[zeroRow][0] = 0.0;
            }
            if (haplotypeStartOffset <= 1) {
                this.deletionMatrix[zeroRow][1] = this.matchMatrix[zeroRow][1] * this.transition[zeroRow][4];
            }
            for (i2 = Math.max(haplotypeStartOffset, 2); i2 < toCol; ++i2) {
                this.deletionMatrix[zeroRow][i2] = this.deletionMatrix[zeroRow][i2 - 1] * this.transition[zeroRow][5];
            }
            if (haplotypeStartOffset == 0) {
                this.deletionMatrix[zeroRow + 1][0] = 0.0;
                this.matchMatrix[zeroRow + 1][0] = 0.0;
                this.insertionMatrix[zeroRow + 1][0] = this.matchMatrix[zeroRow][0] * this.transition[zeroRow + 1][2];
                for (i2 = zeroRow + 2; i2 < toRow; ++i2) {
                    this.deletionMatrix[i2][0] = 0.0;
                    this.matchMatrix[i2][0] = 0.0;
                    this.insertionMatrix[i2][0] = this.insertionMatrix[i2 - 1][0] * this.transition[i2][3];
                }
            }
        }
    }

    protected void initializeMatrixValues(Problem currentProblem, Problem previousProblem) {
        int toCol;
        if (previousProblem != null && previousProblem.readStart == currentProblem.readStart && previousProblem.hapStart == currentProblem.hapStart && this.maxToCol >= currentProblem.hapEnd + 1) {
            return;
        }
        int zeroRow = currentProblem.readStart;
        int zeroCol = currentProblem.hapStart;
        int toRow = currentProblem.readEnd + 1;
        this.maxToCol = toCol = currentProblem.hapEnd + 1;
        if (currentProblem.leading) {
            Arrays.fill(this.matchMatrix[zeroRow], zeroCol, toCol, 0.0);
            Arrays.fill(this.deletionMatrix[zeroRow], zeroCol, toCol, INITIAL_CONDITION);
            for (int i2 = zeroRow + 1; i2 < toRow; ++i2) {
                this.deletionMatrix[i2][zeroCol] = 0.0;
                this.matchMatrix[i2][zeroCol] = 0.0;
                this.insertionMatrix[i2][zeroCol] = 0.0;
            }
        } else {
            int i3;
            Arrays.fill(this.matchMatrix[zeroRow], zeroCol + 1, toCol, 0.0);
            Arrays.fill(this.insertionMatrix[zeroRow], zeroCol, toCol, 0.0);
            this.matchMatrix[zeroRow][zeroCol] = INITIAL_CONDITION;
            this.deletionMatrix[zeroRow][zeroCol] = 0.0;
            this.deletionMatrix[zeroRow][zeroCol + 1] = this.matchMatrix[zeroRow][zeroCol] * this.transition[zeroRow][4];
            for (i3 = zeroCol + 2; i3 < toCol; ++i3) {
                this.deletionMatrix[zeroRow][i3] = this.deletionMatrix[zeroRow][i3 - 1] * this.transition[zeroRow][5];
            }
            this.deletionMatrix[zeroRow + 1][zeroCol] = 0.0;
            this.matchMatrix[zeroRow + 1][zeroCol] = 0.0;
            this.insertionMatrix[zeroRow + 1][zeroCol] = this.matchMatrix[zeroRow][zeroCol] * this.transition[zeroRow + 1][2];
            for (i3 = zeroRow + 2; i3 < toRow; ++i3) {
                this.deletionMatrix[i3][zeroCol] = 0.0;
                this.matchMatrix[i3][zeroCol] = 0.0;
                this.insertionMatrix[i3][zeroCol] = this.insertionMatrix[i3 - 1][zeroCol] * this.transition[i3][3];
            }
        }
    }

    @Override
    public void loadRead(GATKSAMRecord read) {
        this.loadRead(read.getReadBases(), read.getBaseQualities(), read.getBaseInsertionQualities(), read.getBaseDeletionQualities(), read.getMappingQuality());
    }

    @Override
    public void loadRead(byte[] readBases, byte[] readQuals, byte[] readInsQuals, byte[] readDelQuals, int mq) {
        if (readBases.length != readQuals.length) {
            throw new IllegalArgumentException("the read quality array length does not match the read base array length");
        }
        if (readBases.length != readInsQuals.length) {
            throw new IllegalArgumentException("the read insert quality array length does not match the read base array length");
        }
        if (readBases.length != readDelQuals.length) {
            throw new IllegalArgumentException("the read deletion quality length does not match the read base array length");
        }
        this.maxToCol = 0;
        if (readBases.length > this.readCapacity) {
            this.readCapacity = readBases.length;
            this.initialize(this.readCapacity, this.haplotypeCapacity);
        }
        this.paddedReadLength = readBases.length + 1;
        byte[] overallGCP = new byte[readBases.length];
        Arrays.fill(overallGCP, this.constantGCP);
        for (int kkk = 0; kkk < readQuals.length; ++kkk) {
            readQuals[kkk] = (byte)Math.min(0xFF & readQuals[kkk], mq);
            readQuals[kkk] = (byte)(readQuals[kkk] < 18 ? 6 : Math.max(6, readQuals[kkk]));
            readInsQuals[kkk] = (byte)Math.max(6, readInsQuals[kkk]);
            readDelQuals[kkk] = (byte)Math.max(6, readDelQuals[kkk]);
        }
        this.readBases = readBases;
        this.readQuals = readQuals;
        this.readInsQuals = readInsQuals;
        this.readDelQuals = readDelQuals;
        this.readGepQuals = overallGCP;
        FastLoglessPairHMM.initializeProbabilities(this.transition, readInsQuals, readDelQuals, overallGCP);
        PairHMMModel.qualToTransProbsLog10(this.logTransition, readInsQuals, readDelQuals, overallGCP);
        this.indelToIndelIsConstant = true;
        byte[] arr$ = overallGCP;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d2 = arr$[i$];
            if (d2 == (double)overallGCP[0]) continue;
            this.indelToIndelIsConstant = false;
            break;
        }
        if (this.haplotypeBases != null) {
            this.fillPriorsTable(0);
        }
        this.cachedResults.clear();
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.logTransition = PairHMMModel.createTransitionMatrix(readMaxLength);
    }

    @Override
    public void loadHaplotypeBases(byte[] haplotypeBases) {
        if (this.readBases == null) {
            throw new IllegalStateException("no read was loaded before the haplotype");
        }
        this.haplotypeBases = (byte[])haplotypeBases.clone();
        this.paddedHaplotypeLength = this.haplotypeLength = haplotypeBases.length;
        if (this.haplotypeCapacity < this.haplotypeLength) {
            this.haplotypeCapacity = this.haplotypeLength;
            this.initialize(this.readCapacity, this.haplotypeCapacity);
            FastLoglessPairHMM.initializeProbabilities(this.transition, this.readInsQuals, this.readDelQuals, this.readGepQuals);
        }
        this.initializePriors(this.haplotypeBases, this.readBases, this.readQuals, 0);
    }

    public void changeHaplotypeSuffix(int from, byte[] suffix, int suffixFrom, int suffixTo) {
        if (this.readBases == null) {
            throw new IllegalStateException("no read was loaded before the haplotype");
        }
        if (this.haplotypeBases == null && from > 0) {
            throw new IllegalArgumentException("from cannot be larger than 0 if no haplotype bases was previously loaded");
        }
        if (suffixFrom < 0) {
            throw new ArrayIndexOutOfBoundsException("the suffix from index cannot be negative");
        }
        if (suffixTo > suffix.length) {
            throw new ArrayIndexOutOfBoundsException("the suffix to index cannot be larger than the suffix array length");
        }
        if (suffixFrom > suffixTo) {
            throw new IllegalArgumentException("the suffix to index cannot be smaller than the suffix from index");
        }
        if (from > this.haplotypeLength) {
            throw new IllegalArgumentException("the from index cannot be greater than the current haplotype length");
        }
        if (from < 0) {
            throw new IllegalArgumentException("the from index cannot be negative");
        }
        int startIndex = from;
        if (this.haplotypeBases == null) {
            this.haplotypeBases = Arrays.copyOfRange(suffix, suffixFrom, suffixTo);
            this.haplotypeLength = suffixTo - suffixFrom;
        } else {
            int newLength = from + suffixTo - suffixFrom;
            if (this.haplotypeBases.length < newLength) {
                this.haplotypeBases = Arrays.copyOf(this.haplotypeBases, newLength);
            }
            System.arraycopy(suffix, suffixFrom, this.haplotypeBases, from, newLength - from);
            this.haplotypeLength = newLength;
        }
        this.paddedHaplotypeLength = this.haplotypeLength + 1;
        if (this.haplotypeCapacity < this.haplotypeLength) {
            this.haplotypeCapacity = this.haplotypeLength;
            this.initialize(this.readCapacity, this.haplotypeCapacity);
            FastLoglessPairHMM.initializeProbabilities(this.transition, this.readInsQuals, this.readDelQuals, this.readGepQuals);
            startIndex = 0;
        }
        this.fillPriorsTable(startIndex);
    }

    public byte[] getHaplotypeBases() {
        if (this.haplotypeBases == null) {
            throw new IllegalStateException();
        }
        return Arrays.copyOfRange(this.haplotypeBases, 0, this.haplotypeLength);
    }

    public String toString() {
        return "" + this.haplotypeLength + ":" + new String(Arrays.copyOfRange(this.haplotypeBases, 0, this.haplotypeLength));
    }

    @Override
    protected void initializePriors(byte[] hapBases, byte[] readBases, byte[] baseQuals, int idx) {
        this.haplotypeBases = hapBases;
        this.haplotypeLength = this.haplotypeBases.length;
        this.readBases = readBases;
        this.readQuals = baseQuals;
        this.fillPriorsTable(idx);
    }

    protected void fillPriorsTable(int idx) {
        for (int i2 = 0; i2 < this.readBases.length; ++i2) {
            byte x2 = this.readBases[i2];
            byte qual = this.readQuals[i2];
            for (int j2 = idx; j2 < this.haplotypeLength; ++j2) {
                byte y = this.haplotypeBases[j2];
                this.prior[i2 + 1][j2 + 1] = x2 == y || x2 == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual) / (this.doNotUseTristateCorrection ? 1.0 : 3.0);
            }
        }
    }

    public void calculateLocalLikelihoods(int readStart, int readEnd, PairHMMReadyHaplotypes haplotypes) {
        PairHMMReadyHaplotypes.Iterator entryIterator = haplotypes.iterator();
        boolean isFirst = true;
        while (entryIterator.hasNext()) {
            entryIterator.next();
            int startIndex = entryIterator.startIndex();
            byte[] bases = entryIterator.bases();
            this.changeHaplotypeSuffix(startIndex, bases, startIndex, bases.length);
            double likelihood = this.calculateLikelihood(readStart, readEnd, startIndex, isFirst);
            isFirst = false;
            entryIterator.setLikelihood(likelihood);
        }
    }

    @Override
    public double calculateLocalLikelihood(int readStart, int readEnd, int hapStart, int hapEnd, boolean kmerMatch) {
        if (this.readBases == null || this.haplotypeBases == null) {
            throw new IllegalStateException("read or haplotype was not loaded");
        }
        int hapSegmentLength = hapEnd - hapStart;
        int readSegmentLength = readEnd - readStart;
        if (kmerMatch) {
            return this.calculateLocalLikelihoodsExactMatch(readStart, hapStart, hapSegmentLength, readSegmentLength);
        }
        if (hapSegmentLength == readSegmentLength) {
            if (hapSegmentLength == 0) {
                return this.calculateLocalLikelihoodEmptySquare(readStart, readEnd);
            }
            if (hapSegmentLength == 1) {
                return this.calculateLocalLikelihoodSingleBase(readStart, readEnd, hapStart);
            }
            return this.calculateLocalLikelihoodsGeneral(readStart, readEnd, hapStart, hapEnd);
        }
        if (hapSegmentLength == 0) {
            return this.calculateLocalLikelihoodInsertion(readStart, readEnd);
        }
        if (readSegmentLength == 0) {
            return this.calculateLocalLikelihoodDeletion(readStart, hapStart, hapEnd);
        }
        return this.calculateLocalLikelihoodsGeneral(readStart, readEnd, hapStart, hapEnd);
    }

    private double calculateLocalLikelihoodDeletion(int readStart, int hapStart, int hapEnd) {
        if (readStart == 0 || readStart >= this.readBases.length) {
            return 0.0;
        }
        return this.logTransition[readStart + 1][4] + this.logTransition[readStart + 1][5] * (double)(hapEnd - hapStart - 1);
    }

    private double calculateLocalLikelihoodInsertion(int readStart, int readEnd) {
        double result = this.logTransition[readStart + 1][2];
        if (this.indelToIndelIsConstant) {
            result += this.logTransition[readStart + 1][3] * (double)(readEnd - readStart - 1);
        } else {
            for (int i2 = readStart + 1; i2 < readEnd; ++i2) {
                result += this.logTransition[i2 + 1][3];
            }
        }
        if (readEnd < this.readBases.length) {
            result += this.logTransition[readEnd + 1][1];
        }
        return result;
    }

    private double calculateLocalLikelihoodSingleBase(int readStart, int readEnd, int hapStart) {
        double result = INITIAL_CONDITION;
        result *= this.prior[readStart + 1][hapStart + 1];
        if (readStart > 0) {
            result *= this.transition[readStart + 1][0];
        }
        if (readEnd < this.readBases.length) {
            result *= this.transition[readEnd + 1][0];
        }
        return StrictMath.log10(result) - INITIAL_CONDITION_LOG10;
    }

    private double calculateLocalLikelihoodEmptySquare(int readStart, int readEnd) {
        double result = INITIAL_CONDITION;
        if (readStart > 0 && readEnd < this.readBases.length) {
            result *= this.transition[readStart + 1][0];
        }
        return StrictMath.log10(result) - INITIAL_CONDITION_LOG10;
    }

    private double calculateLocalLikelihoodsExactMatch(int readStart, int hapStart, int hapSegmentLength, int readSegmentLength) {
        double result = INITIAL_CONDITION;
        if (hapSegmentLength == 1) {
            result *= this.prior[readStart + 1][hapStart + 1];
        } else {
            for (int i2 = 0; i2 < readSegmentLength; ++i2) {
                result *= this.prior[readStart + i2 + 1][hapStart + i2 + 1];
                if (i2 <= 0) continue;
                result *= this.transition[readStart + i2 + 1][0];
            }
        }
        return StrictMath.log10(result) - INITIAL_CONDITION_LOG10;
    }

    private double calculateLocalLikelihoodsGeneral(int readStart, int readEnd, int hapStart, int hapEnd) {
        Problem p2 = new Problem(readStart, readEnd, hapStart, hapEnd);
        Double cachedCost = this.cachedResults.get(p2);
        if (cachedCost != null) {
            return cachedCost;
        }
        double cost = this.calculateLocalLikelihoodGeneral(p2);
        this.cachedResults.put(p2, cost);
        return cost;
    }

    private double calculateLikelihood(int readStart, int readEnd, int startIndex, boolean initializeEdges) {
        int edgeStart = initializeEdges ? 0 : startIndex + 1;
        this.initializeMatrixValuesForTrailingProblem(readStart, readEnd, edgeStart);
        this.updateTable(readStart + 1, readEnd + 1, startIndex + 1, this.haplotypeLength + 1);
        if (readEnd == this.readBases.length) {
            return this.finalLikelihoodCalculation(readEnd, 0, this.haplotypeLength + 1) - (readStart == 0 ? StrictMath.log10(this.haplotypeLength) : 0.0);
        }
        double divider = 3.0;
        double dividerInverted = 0.3333333333333333;
        return StrictMath.log10(this.matchMatrix[readEnd][this.haplotypeLength] * this.transition[readEnd][0] * 0.3333333333333333 + this.insertionMatrix[readEnd][this.haplotypeLength] * this.transition[readEnd][1] * 0.3333333333333333 + this.deletionMatrix[readEnd][this.haplotypeLength] * this.transition[readEnd][1] * 0.3333333333333333) - INITIAL_CONDITION_LOG10 + StrictMath.log10(3.0);
    }

    private double calculateLocalLikelihoodGeneral(Problem p2) {
        this.initializeMatrixValues(p2, null);
        this.updateTable(p2.readStart + 1, p2.readEnd + 1, p2.hapStart + 1, p2.hapEnd + 1);
        if (p2.trailing) {
            return this.finalLikelihoodCalculation(p2.readEnd, p2.hapStart, p2.hapEnd + 1) - (p2.leading ? StrictMath.log10(p2.hapEnd - p2.hapStart) : 0.0);
        }
        double divider = 3.0;
        double dividerInverted = 0.3333333333333333;
        return StrictMath.log10(this.matchMatrix[p2.readEnd][p2.hapEnd] * this.transition[p2.readEnd][0] * 0.3333333333333333 + this.insertionMatrix[p2.readEnd][p2.hapEnd] * this.transition[p2.readEnd][1] * 0.3333333333333333 + this.deletionMatrix[p2.readEnd][p2.hapEnd] * this.transition[p2.readEnd][1] * 0.3333333333333333) - INITIAL_CONDITION_LOG10 + StrictMath.log10(3.0);
    }

    private void updateTable(int rowFrom, int rowTo, int colFrom, int colTo) {
        for (int i2 = rowFrom; i2 < rowTo; ++i2) {
            for (int j2 = colFrom; j2 < colTo; ++j2) {
                this.updateCell(i2, j2, this.prior[i2][j2], this.transition[i2]);
            }
        }
    }

    @Override
    public byte[] getReadBases() {
        if (this.readBases == null) {
            throw new IllegalStateException("no read was previously loaded.");
        }
        return this.readBases;
    }

    public class Problem {
        private final byte[] haplotypeSegment;
        private final int readStart;
        private final int readEnd;
        private final int hapStart;
        private final int hapEnd;
        private final int hashCode;
        private final boolean trailing;
        private final boolean leading;

        public Problem(int start, int end, int hapStart, int hapEnd) {
            if (start < 0 || start > FastLoglessPairHMM.this.readBases.length) {
                throw new IllegalArgumentException("bad start index " + start);
            }
            if (end < start || end > FastLoglessPairHMM.this.readBases.length) {
                throw new IllegalArgumentException("bad end index " + end + " < " + start + " or " + end + " > " + FastLoglessPairHMM.this.readBases.length);
            }
            if (hapStart < 0 || hapStart > FastLoglessPairHMM.this.haplotypeLength) {
                throw new IllegalArgumentException("bad hap start index " + hapStart + " is larger than the haplotypeLength " + FastLoglessPairHMM.this.haplotypeLength);
            }
            if (hapEnd < hapStart || hapEnd > FastLoglessPairHMM.this.haplotypeLength) {
                throw new IllegalArgumentException("bad hap end index " + hapEnd + " outside [" + hapStart + "," + FastLoglessPairHMM.this.haplotypeLength + "]");
            }
            this.haplotypeSegment = Arrays.copyOfRange(FastLoglessPairHMM.this.haplotypeBases, hapStart, hapEnd);
            this.readStart = start;
            this.readEnd = end;
            this.hapStart = hapStart;
            this.hapEnd = hapEnd;
            this.trailing = this.readEnd == FastLoglessPairHMM.this.readBases.length;
            this.leading = this.readStart == 0;
            this.hashCode = (start * 31 + end) * 31 + Arrays.hashCode(this.haplotypeSegment) * 31;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            if (o2.getClass() != this.getClass()) {
                return false;
            }
            Problem p2 = (Problem)o2;
            return p2.hashCode == this.hashCode && p2.readStart == this.readStart && p2.readEnd == this.readEnd && Arrays.equals(this.haplotypeSegment, p2.haplotypeSegment);
        }
    }
}

