/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.fasta;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.fasta.ArtificialContig;

public class ArtificialFastaUtils {
    public static void createArtificialFasta(String fileName, List<String> contigNames, List<Integer> contigSizes, BASE_PATTERN pattern) {
        PrintStream s2;
        try {
            s2 = new PrintStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e2) {
            throw new ReviewedGATKException("Filename " + fileName + " passed to the ArtificialFastaUtils generated a FileNotFound exception", e2);
        }
        ArtificialFastaUtils.generateFakeFasta(contigNames, contigSizes, pattern, s2);
    }

    public static void createArtificialFasta(PrintStream stream, List<String> contigNames, List<Integer> contigSizes, BASE_PATTERN pattern) {
        ArtificialFastaUtils.generateFakeFasta(contigNames, contigSizes, pattern, stream);
    }

    private static void generateFakeFasta(List<String> contigNames, List<Integer> contigSizes, BASE_PATTERN pattern, PrintStream s2) {
        if (contigNames.size() != contigSizes.size()) {
            throw new ReviewedGATKException("ArtificialContig name and size arrays are not equal sizes");
        }
        for (int x2 = 0; x2 < contigNames.size(); ++x2) {
            ArtificialContig tig = new ArtificialContig(contigNames.get(x2), contigSizes.get(x2), pattern);
            tig.write(s2);
        }
        s2.close();
    }

    public static enum BASES {
        A,
        T,
        C,
        G;

    }

    public static enum BASE_PATTERN {
        RANDOM,
        ALL_A,
        ALL_T,
        ALL_C,
        ALL_G;

    }
}

