/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.UIUtilities;

public class ApplicationStatusBar
extends JPanel {
    static Logger log = Logger.getLogger(ApplicationStatusBar.class);
    private JLabel messageBox;
    private JLabel messageBox2;
    private JLabel messageBox3;
    private JLabel memoryStatus;
    private JButton cancelButton;
    Timer timer;

    public ApplicationStatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.setBackground(new Color(240, 240, 240));
        Color messageBG = new Color(230, 230, 230);
        Font messageFont = FontManager.getFont(11);
        this.setMinimumSize(new Dimension(200, 20));
        this.setPreferredSize(new Dimension(800, 20));
        JideBoxLayout layout = new JideBoxLayout(this, 0);
        layout.setGap(3);
        this.setLayout(layout);
        this.messageBox = this.createMessageField(messageBG, messageFont);
        this.messageBox.setMinimumSize(new Dimension(135, 10));
        this.messageBox.setPreferredSize(new Dimension(135, 20));
        this.add((Component)this.messageBox, "fix");
        if (Globals.isDevelopment()) {
            this.cancelButton = new JideButton(IconFactory.getInstance().getIcon(IconFactory.IconID.CLOSE));
            this.cancelButton.setMinimumSize(new Dimension(20, 10));
            this.cancelButton.setPreferredSize(new Dimension(20, 20));
            this.cancelButton.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.cancelButton, "fix");
        }
        this.messageBox2 = this.createMessageField(messageBG, messageFont);
        this.messageBox2.setMinimumSize(new Dimension(150, 10));
        this.messageBox2.setPreferredSize(new Dimension(150, 20));
        this.add((Component)this.messageBox2, "fix");
        this.messageBox3 = this.createMessageField(messageBG, messageFont);
        this.messageBox3.setMinimumSize(new Dimension(165, 10));
        this.messageBox3.setPreferredSize(new Dimension(165, 20));
        this.add((Component)this.messageBox3, "vary");
        this.memoryStatus = this.createMessageField(messageBG, messageFont);
        this.memoryStatus.setPreferredSize(new Dimension(100, 20));
        this.memoryStatus.setMinimumSize(new Dimension(100, 10));
        this.memoryStatus.setBackground(messageBG);
        this.add((Component)this.memoryStatus, "fix");
        MemoryUpdateTask updateTask = new MemoryUpdateTask(this.memoryStatus);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)updateTask, 0L, 1000L);
    }

    public void setMessage(final String message) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                ApplicationStatusBar.this.messageBox.setText(message);
                ApplicationStatusBar.this.messageBox.paintImmediately(ApplicationStatusBar.this.messageBox.getBounds());
            }
        });
    }

    public void setMessage2(final String message) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                ApplicationStatusBar.this.messageBox2.setText(message);
                ApplicationStatusBar.this.messageBox2.paintImmediately(ApplicationStatusBar.this.messageBox2.getBounds());
            }
        });
    }

    private JLabel createMessageField(Color bg, Font font) {
        JLabel messageField = new JLabel();
        messageField.setBackground(bg);
        messageField.setFont(font);
        messageField.setBorder(BorderFactory.createLineBorder(Color.black));
        return messageField;
    }

    public void activateCancelButton(ActionListener listener) {
        if (Globals.isDevelopment()) {
            this.cancelButton.addActionListener(listener);
            this.cancelButton.addActionListener(new CancelButtonActionListener());
            this.cancelButton.setEnabled(true);
        }
    }

    public void deactivateCancelButton() {
        if (Globals.isDevelopment()) {
            for (ActionListener l2 : this.cancelButton.getActionListeners()) {
                this.cancelButton.removeActionListener(l2);
            }
            this.cancelButton.setEnabled(false);
        }
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    class MemoryUpdateTask
    extends TimerTask {
        JLabel textField;
        NumberFormat format;

        public MemoryUpdateTask(JLabel textField) {
            this.textField = textField;
            this.format = NumberFormat.getIntegerInstance();
        }

        @Override
        public void run() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1000000L);
            int totalMemory = (int)(runtime.totalMemory() / 1000000L);
            int usedMemory = totalMemory - freeMemory;
            String um = this.format.format(usedMemory);
            String tm = this.format.format(totalMemory);
            this.textField.setText(um + "M of " + tm + "M");
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ApplicationStatusBar.this.deactivateCancelButton();
        }
    }
}

