/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.encode.EncodeFileBrowser;
import org.broad.igv.util.encode.EncodeFileRecord;

public class BrowseEncodeAction
extends MenuAction {
    private static Logger log = Logger.getLogger(BrowseEncodeAction.class);
    private static Map<String, Color> colors = new HashMap<String, Color>();
    IGV igv;

    public BrowseEncodeAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String[] visibleAttributes = new String[]{"dataType", "cell", "antibody", "lab"};
        try {
            Genome genome = this.igv.getGenomeManager().getCurrentGenome();
            EncodeFileBrowser browser = EncodeFileBrowser.getInstance(genome.getId());
            if (browser == null) {
                MessageUtils.showMessage("Encode data is not available for " + genome.getDisplayName() + " through IGV.");
                return;
            }
            browser.setVisible(true);
            if (browser.isCanceled()) {
                return;
            }
            List<EncodeFileRecord> records = browser.getSelectedRecords();
            if (records.size() > 0) {
                ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>(records.size());
                for (EncodeFileRecord record : records) {
                    ResourceLocator rl = new ResourceLocator(record.getPath());
                    rl.setName(record.getTrackName());
                    String antibody = record.getAttributeValue("antibody");
                    if (antibody != null) {
                        rl.setColor(colors.get(antibody.toUpperCase()));
                    }
                    for (String name : visibleAttributes) {
                        String value = record.getAttributeValue(name);
                        if (value == null) continue;
                        AttributeManager.getInstance().addAttribute(rl.getName(), name, value);
                    }
                    locators.add(rl);
                }
                this.igv.loadTracks(locators);
            }
        }
        catch (IOException e2) {
            log.error("Error opening Encode browser", e2);
        }
    }

    static {
        colors.put("H3K27AC", new Color(200, 0, 0));
        colors.put("H3K27ME3", new Color(200, 0, 0));
        colors.put("H3K36ME3", new Color(0, 0, 150));
        colors.put("H3K4ME1", new Color(0, 150, 0));
        colors.put("H3K4ME2", new Color(0, 150, 0));
        colors.put("H3K4ME3", new Color(0, 150, 0));
        colors.put("H3K9AC", new Color(100, 0, 0));
        colors.put("H3K9ME1", new Color(100, 0, 0));
    }
}

