/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

public class Axis {
    Orientation orientation;
    double min;
    double max;
    double[] ticks;
    double scale;
    int panelSize = 500;
    private String label;

    public Axis(Orientation orientation) {
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public int getPixelForValue(double value) {
        int p2 = (int)((value - this.min) * this.scale);
        return this.orientation == Orientation.HORIZONTAL ? p2 : this.panelSize - p2;
    }

    public double getDataValueForPixel(int pixel) {
        int p2 = this.orientation == Orientation.HORIZONTAL ? pixel : this.panelSize - pixel;
        return this.min + (double)p2 / this.scale;
    }

    public void setRange(double min, double max) {
        this.ticks = Axis.computeTicks(min, max, 10);
        this.min = this.ticks[0];
        int maxTickNumber = (int)(max / this.ticks[1]) + 1;
        if (max > 0.0) {
            ++maxTickNumber;
        }
        this.max = (double)maxTickNumber * this.ticks[1];
        this.rescale();
    }

    private void rescale() {
        this.scale = (double)this.panelSize / (this.max - this.min);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPanelSize(int panelSize) {
        if (panelSize != this.panelSize) {
            this.panelSize = panelSize;
            this.rescale();
        }
    }

    public static double[] computeTicks(double min, double max, int targetTickCount) {
        if (max <= min) {
            return new double[]{max, 1.0};
        }
        double v2 = max - min;
        double d2 = Math.log10(v2);
        double r2 = Math.floor(d2);
        double delta0 = Math.pow(10.0, r2);
        int nTicks0 = (int)(v2 / delta0);
        double delta = delta0;
        int[] mults = new int[]{1, 2, 5, 10};
        for (int i2 = 0; i2 < mults.length; ++i2) {
            int nTicks = nTicks0 * mults[i2];
            delta = delta0 / (double)mults[i2];
            if ((double)nTicks > 0.7 * (double)targetTickCount) break;
        }
        double minTick = min - min % delta;
        if (min < 0.0) {
            minTick -= delta;
        }
        return new double[]{minTick, delta};
    }

    public double getScale() {
        return this.scale;
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

