/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Lazy;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

class UrlInputResource
extends InputResource {
    final URL urlResource;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Lazy.LazyInitializer<SeekableStream>(){

        @Override
        public SeekableStream make() {
            return new SeekableHTTPStream(UrlInputResource.this.urlResource);
        }
    });

    UrlInputResource(URL urlResource) {
        super(InputResource.Type.URL);
        this.urlResource = urlResource;
    }

    @Override
    public File asFile() {
        return null;
    }

    @Override
    public URL asUrl() {
        return this.urlResource;
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }
}

