/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Invariant(value={"reader != null"})
public class JavaTokenizer
implements Iterator<Token> {
    protected PushbackReader reader;
    protected Token nextToken;
    protected boolean hasErrors_;
    protected String errorMessage;
    protected int currentOffset;

    @Requires(value={"reader != null"})
    public JavaTokenizer(Reader reader) {
        this.reader = new PushbackReader(reader);
        this.nextToken = null;
        this.hasErrors_ = false;
        this.currentOffset = 0;
    }

    @Ensures(value={"!allowEOF ? result >= 0 : result >= -1"})
    protected int readChar(boolean bl) throws IOException {
        int n = this.reader.read();
        if (n != -1) {
            ++this.currentOffset;
        } else if (!bl) {
            throw new IOException();
        }
        return n;
    }

    protected void unreadChar(int n) throws IOException {
        if (n == -1) {
            return;
        }
        --this.currentOffset;
        this.reader.unread(n);
    }

    @Requires(value={"nextToken == null"})
    @Ensures(value={"result == (nextToken != null)"})
    protected boolean lex() throws IOException {
        int n = this.currentOffset;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.readChar(true);
        if (n2 == -1) {
            return false;
        }
        stringBuilder.append((char)n2);
        block0 : switch (n2) {
            case 47: {
                n2 = this.readChar(true);
                switch (n2) {
                    case 47: {
                        stringBuilder.append((char)n2);
                        do {
                            n2 = this.readChar(false);
                            stringBuilder.append((char)n2);
                        } while (n2 != 10);
                        this.nextToken = new Token(TokenKind.COMMENT, stringBuilder.toString(), n);
                        break block0;
                    }
                    case 42: {
                        stringBuilder.append((char)n2);
                        while (true) {
                            n2 = this.readChar(false);
                            stringBuilder.append((char)n2);
                            if (n2 != 42) continue;
                            n2 = this.readChar(false);
                            stringBuilder.append((char)n2);
                            if (n2 == 47) break;
                        }
                        this.nextToken = new Token(TokenKind.COMMENT, stringBuilder.toString(), n);
                        break block0;
                    }
                }
                this.unreadChar(n2);
                this.nextToken = new Token(TokenKind.SYMBOL, stringBuilder.toString(), n);
                break;
            }
            case 34: 
            case 39: {
                int n3 = n2;
                while (true) {
                    n2 = this.readChar(false);
                    stringBuilder.append((char)n2);
                    if (n2 == n3) break;
                    if (n2 != 92) continue;
                    stringBuilder.append((char)this.readChar(false));
                }
                this.nextToken = new Token(TokenKind.QUOTE, stringBuilder.toString(), n);
                break;
            }
            default: {
                if (Character.isJavaIdentifierStart(n2)) {
                    while ((n2 = this.readChar(true)) != -1 && Character.isJavaIdentifierPart(n2)) {
                        stringBuilder.append((char)n2);
                    }
                    this.unreadChar(n2);
                    this.nextToken = new Token(TokenKind.WORD, stringBuilder.toString(), n);
                    break;
                }
                if (Character.isWhitespace(n2)) {
                    while ((n2 = this.readChar(true)) != -1 && Character.isWhitespace(n2)) {
                        stringBuilder.append((char)n2);
                    }
                    this.unreadChar(n2);
                    this.nextToken = new Token(TokenKind.SPACE, stringBuilder.toString(), n);
                    break;
                }
                this.nextToken = new Token(TokenKind.SYMBOL, stringBuilder.toString(), n);
            }
        }
        return true;
    }

    public Token getNextToken() {
        if (this.nextToken == null) {
            try {
                if (!this.lex()) {
                    throw new NoSuchElementException();
                }
            }
            catch (IOException iOException) {
                this.errorMessage = iOException.getMessage();
                this.hasErrors_ = true;
                throw new NoSuchElementException();
            }
        }
        return this.nextToken;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public boolean hasErrors() {
        return this.hasErrors_;
    }

    @Requires(value={"hasErrors()"})
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken != null) {
            return true;
        }
        try {
            return this.lex();
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            this.hasErrors_ = true;
            return false;
        }
    }

    @Override
    public Token next() {
        Token token = this.getNextToken();
        this.nextToken = null;
        return token;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class Token {
        public final TokenKind kind;
        public final String text;
        public final int offset;

        protected Token(TokenKind tokenKind, String string, int n) {
            this.kind = tokenKind;
            this.text = string;
            this.offset = n;
        }
    }

    public static enum TokenKind {
        WORD,
        QUOTE,
        SYMBOL,
        COMMENT,
        SPACE;

    }
}

