/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFRecordCodec;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import picard.cmdline.CommandLineParser;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class SortVcf
extends CommandLineProgram {
    @Usage
    public String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Sorts one or more VCF files according to the order of the contigs in the header/sequence dictionary and then by coordinate. " + "Can accept an external sequence dictionary. If no external dictionary is supplied, multiple inputs' headers must have " + "the same sequence dictionaries. Multiple inputs must have the same sample names (in order)\n";
    @Option(shortName="I", doc="Input VCF(s) to be sorted. Multiple inputs must have the same sample names (in order)")
    public List<File> INPUT;
    @Option(shortName="O", doc="Output VCF to be written.")
    public File OUTPUT;
    @Option(shortName="SD", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(SortVcf.class);
    private final List<VCFFileReader> inputReaders = new ArrayList<VCFFileReader>();
    private final List<VCFHeader> inputHeaders = new ArrayList<VCFHeader>();

    public static void main(String[] args) {
        new SortVcf().instanceMainWithExit(args);
    }

    public SortVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        System.out.println(this.CREATE_INDEX);
        ArrayList<String> sampleList = new ArrayList<String>();
        for (File input : this.INPUT) {
            IOUtil.assertFileIsReadable(input);
        }
        if (this.SEQUENCE_DICTIONARY != null) {
            IOUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY);
        }
        SAMSequenceDictionary samSequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            samSequenceDictionary = SamReaderFactory.makeDefault().open(this.SEQUENCE_DICTIONARY).getFileHeader().getSequenceDictionary();
            CloserUtil.close(this.SEQUENCE_DICTIONARY);
        }
        this.collectFileReadersAndHeaders(sampleList, samSequenceDictionary);
        VCFHeader outputHeader = new VCFHeader(VCFUtils.smartMergeHeaders(this.inputHeaders, false), sampleList);
        SortingCollection<VariantContext> sortedOutput = this.sortInputs(this.inputReaders, outputHeader);
        this.writeSortedOutput(outputHeader, sortedOutput);
        return 0;
    }

    private void collectFileReadersAndHeaders(List<String> sampleList, SAMSequenceDictionary samSequenceDictionary) {
        for (File input : this.INPUT) {
            VCFFileReader in = new VCFFileReader(input, false);
            VCFHeader header = in.getFileHeader();
            SAMSequenceDictionary dict = in.getFileHeader().getSequenceDictionary();
            if (dict == null || dict.isEmpty()) {
                if (null == samSequenceDictionary) {
                    throw new IllegalArgumentException("Sequence dictionary was missing or empty for the VCF: " + input.getAbsolutePath() + " Please add a sequence dictionary to this VCF or specify SEQUENCE_DICTIONARY.");
                }
                header.setSequenceDictionary(samSequenceDictionary);
            } else if (null == samSequenceDictionary) {
                samSequenceDictionary = dict;
            } else {
                try {
                    samSequenceDictionary.assertSameDictionary(dict);
                }
                catch (AssertionError e2) {
                    throw new IllegalArgumentException((Throwable)((Object)e2));
                }
            }
            if (sampleList.isEmpty()) {
                sampleList.addAll(header.getSampleNamesInOrder());
            } else if (!((Object)sampleList).equals(header.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + input.getAbsolutePath() + " has sample names that don't match the other files.");
            }
            this.inputReaders.add(in);
            this.inputHeaders.add(header);
        }
    }

    private SortingCollection<VariantContext> sortInputs(List<VCFFileReader> readers, VCFHeader outputHeader) {
        ProgressLogger readProgress = new ProgressLogger(this.log, 25000, "read", "records");
        SortingCollection<VariantContext> sorter = SortingCollection.newInstance(VariantContext.class, new VCFRecordCodec(outputHeader), outputHeader.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, this.TMP_DIR);
        int readerCount = 1;
        for (VCFFileReader reader : readers) {
            this.log.info("Reading entries from input file " + readerCount);
            for (VariantContext variantContext : reader) {
                sorter.add(variantContext);
                readProgress.record(variantContext.getChr(), variantContext.getStart());
            }
            reader.close();
            ++readerCount;
        }
        return sorter;
    }

    private void writeSortedOutput(VCFHeader outputHeader, SortingCollection<VariantContext> sortedOutput) {
        ProgressLogger writeProgress = new ProgressLogger(this.log, 25000, "wrote", "records");
        EnumSet<Options> options = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter out = new VariantContextWriterBuilder().setReferenceDictionary(outputHeader.getSequenceDictionary()).setOptions(options).setOutputFile(this.OUTPUT).build();
        out.writeHeader(outputHeader);
        for (VariantContext variantContext : sortedOutput) {
            out.add(variantContext);
            writeProgress.record(variantContext.getChr(), variantContext.getStart());
        }
        out.close();
    }
}

