/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CoordMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class EarliestFragmentPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        if (hitsForInsert.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        ArrayList<Integer> earliestAlignments = new ArrayList<Integer>();
        int earliestMappedBase = Integer.MAX_VALUE;
        int bestMapQ = -1;
        for (int i2 = 0; i2 < hitsForInsert.numHits(); ++i2) {
            SAMRecord rec = hitsForInsert.getFragment(i2);
            if (rec.getReadUnmappedFlag()) continue;
            int thisFirstMappedBase = this.getIndexOfFirstAlignedBase(rec);
            int thisMapQ = rec.getMappingQuality();
            if (thisFirstMappedBase < earliestMappedBase || thisFirstMappedBase == earliestMappedBase && thisMapQ > bestMapQ) {
                earliestAlignments.clear();
                earliestAlignments.add(i2);
                earliestMappedBase = thisFirstMappedBase;
                bestMapQ = thisMapQ;
                continue;
            }
            if (thisFirstMappedBase != earliestMappedBase || thisMapQ != bestMapQ) continue;
            earliestAlignments.add(i2);
        }
        if (earliestAlignments.size() == 1) {
            hitsForInsert.setPrimaryAlignment((Integer)earliestAlignments.get(0));
        } else {
            hitsForInsert.setPrimaryAlignment((Integer)earliestAlignments.get(this.random.nextInt(earliestAlignments.size())));
        }
    }

    int getIndexOfFirstAlignedBase(SAMRecord rec) {
        List<AlignmentBlock> alignmentBlocks = rec.getAlignmentBlocks();
        if (rec.getReadNegativeStrandFlag()) {
            AlignmentBlock alignmentBlock = alignmentBlocks.get(alignmentBlocks.size() - 1);
            return rec.getReadLength() - CoordMath.getEnd(alignmentBlock.getReadStart(), alignmentBlock.getLength()) + 1;
        }
        return alignmentBlocks.get(0).getReadStart();
    }
}

