/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class MarkIlluminaAdapters
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reads a SAM or BAM file and rewrites it with new adapter-trimming tags.\n" + "Clear any existing adapter-trimming tags (XT:i:).\n" + "Only works for unaligned files in query-name order.\n" + "Note: This is a utility program and will not be run in the pipeline.\n";
    @Option(shortName="I")
    public File INPUT;
    @Option(doc="If output is not specified, just the metrics are generated", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="Histogram showing counts of bases_clipped in how many reads", shortName="M")
    public File METRICS;
    @Option(doc="The minimum number of bases to match over when clipping single-end reads.")
    public int MIN_MATCH_BASES_SE = 12;
    @Option(doc="The minimum number of bases to match over (per-read) when clipping paired-end reads.")
    public int MIN_MATCH_BASES_PE = 6;
    @Option(doc="The maximum mismatch error rate to tolerate when clipping single-end reads.")
    public double MAX_ERROR_RATE_SE = 0.1;
    @Option(doc="The maximum mismatch error rate to tolerate when clipping paired-end reads.")
    public double MAX_ERROR_RATE_PE = 0.1;
    @Option(doc="DEPRECATED. Whether this is a paired-end run. No longer used.", shortName="PE", optional=true)
    public Boolean PAIRED_RUN;
    @Option(doc="Which adapters sequences to attempt to identify and clip.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.PAIRED_END);
    @Option(doc="For specifying adapters other than standard Illumina", optional=true)
    public String FIVE_PRIME_ADAPTER;
    @Option(doc="For specifying adapters other than standard Illumina", optional=true)
    public String THREE_PRIME_ADAPTER;
    @Option(doc="Adapters are truncated to this length to speed adapter matching.  Set to a large number to effectively disable truncation.")
    public int ADAPTER_TRUNCATION_LENGTH = 30;
    @Option(doc="If looking for multiple adapter sequences, then after having seen this many adapters, shorten the list of sequences. Keep the adapters that were found most frequently in the input so far. Set to -1 if the input has a heterogeneous mix of adapters so shortening is undesirable.", shortName="APT")
    public int PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN = 100;
    @Option(doc="If pruning the adapter list, keep only this many adapter sequences when pruning the list (plus any adapters that were tied with the adapters being kept).")
    public int NUM_ADAPTERS_TO_KEEP = 1;
    private static final Log log = Log.getInstance(MarkIlluminaAdapters.class);

    public static void main(String[] args) {
        System.exit(new MarkIlluminaAdapters().instanceMain(args));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER == null || this.THREE_PRIME_ADAPTER != null && this.FIVE_PRIME_ADAPTER == null) {
            return new String[]{"Either both or neither of THREE_PRIME_ADAPTER and FIVE_PRIME_ADAPTER must be set."};
        }
        return null;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.METRICS);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        SAMFileHeader.SortOrder order = in.getFileHeader().getSortOrder();
        SAMFileWriter out = null;
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
            out = new SAMFileWriterFactory().makeSAMOrBAMWriter(in.getFileHeader(), true, this.OUTPUT);
        }
        Histogram<Integer> histo = new Histogram<Integer>("clipped_bases", "read_count");
        ArrayList<AdapterPair> tmp = new ArrayList<AdapterPair>();
        tmp.addAll(this.ADAPTERS);
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER != null) {
            tmp.add(new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER));
        }
        AdapterPair[] adapters = tmp.toArray(new AdapterPair[tmp.size()]);
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Read");
        SAMRecordIterator iterator = in.iterator();
        AdapterMarker adapterMarker = new AdapterMarker(this.ADAPTER_TRUNCATION_LENGTH, adapters).setMaxPairErrorRate(this.MAX_ERROR_RATE_PE).setMinPairMatchBases(this.MIN_MATCH_BASES_PE).setMaxSingleEndErrorRate(this.MAX_ERROR_RATE_SE).setMinSingleEndMatchBases(this.MIN_MATCH_BASES_SE).setNumAdaptersToKeep(this.NUM_ADAPTERS_TO_KEEP).setThresholdForSelectingAdaptersToKeep(this.PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN);
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            SAMRecord rec2 = rec.getReadPairedFlag() && iterator.hasNext() ? (SAMRecord)iterator.next() : null;
            rec.setAttribute("XT", null);
            if (rec.getReadPairedFlag()) {
                SAMRecord second;
                SAMRecord first;
                if (order != SAMFileHeader.SortOrder.queryname) {
                    throw new PicardException("Input BAM file must be sorted by queryname");
                }
                if (rec2 == null) {
                    throw new PicardException("Missing mate pair for paired read: " + rec.getReadName());
                }
                rec2.setAttribute("XT", null);
                if (!rec.getReadName().equals(rec2.getReadName())) {
                    throw new PicardException("Adjacent reads expected to be mate-pairs have different names: " + rec.getReadName() + ", " + rec2.getReadName());
                }
                if (rec.getFirstOfPairFlag() && rec2.getSecondOfPairFlag()) {
                    first = rec;
                    second = rec2;
                } else if (rec.getSecondOfPairFlag() && rec2.getFirstOfPairFlag()) {
                    first = rec2;
                    second = rec;
                } else {
                    throw new PicardException("Two reads with same name but not correctly marked as 1st/2nd of pair: " + rec.getReadName());
                }
                adapterMarker.adapterTrimIlluminaPairedReads(first, second);
            } else {
                adapterMarker.adapterTrimIlluminaSingleRead(rec);
            }
            for (SAMRecord r2 : new SAMRecord[]{rec, rec2}) {
                Integer clip;
                if (r2 == null) continue;
                progress.record(r2);
                if (out != null) {
                    out.addAlignment(r2);
                }
                if ((clip = rec.getIntegerAttribute("XT")) == null) continue;
                histo.increment(rec.getReadLength() - clip + 1);
            }
        }
        if (out != null) {
            out.close();
        }
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.setHistogram(histo);
        metricsFile.write(this.METRICS);
        return 0;
    }

    private class CustomAdapterPair
    implements AdapterPair {
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private CustomAdapterPair(String fivePrime, String threePrime) {
            this.threePrime = threePrime;
            this.threePrimeBytes = StringUtil.stringToBytes(threePrime);
            this.fivePrime = fivePrime;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement(fivePrime);
            this.fivePrimeBytes = StringUtil.stringToBytes(fivePrime);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return "Custom adapter pair";
        }
    }
}

