/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CollectTargetedMetrics;
import picard.analysis.directed.TargetedPcrMetrics;
import picard.analysis.directed.TargetedPcrMetricsCollector;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class CollectTargetedPcrMetrics
extends CollectTargetedMetrics<TargetedPcrMetrics, TargetedPcrMetricsCollector> {
    @Usage
    public final String USAGE = "Calculates a set of metrics to Illumina Truseq Custom Amplicon sequencing from an aligned SAMor BAM file. If a reference sequence is provided, AT/GC dropout metrics will be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and mean coverage information for every target.";
    @Option(shortName="AI", doc="An interval list file that contains the locations of the baits used.")
    public File AMPLICON_INTERVALS;
    @Option(shortName="N", doc="Custom amplicon set name. If not provided it is inferred from the filename of the AMPLICON_INTERVALS intervals.", optional=true)
    public String CUSTOM_AMPLICON_SET_NAME;

    @Override
    protected IntervalList getProbeIntervals() {
        return IntervalList.fromFile(this.AMPLICON_INTERVALS);
    }

    @Override
    protected String getProbeSetName() {
        return this.CUSTOM_AMPLICON_SET_NAME != null ? this.CUSTOM_AMPLICON_SET_NAME : CollectTargetedMetrics.renderProbeNameFromFile(this.AMPLICON_INTERVALS);
    }

    public static void main(String[] argv) {
        System.exit(new CollectTargetedPcrMetrics().instanceMain(argv));
    }

    @Override
    protected TargetedPcrMetricsCollector makeCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName) {
        return new TargetedPcrMetricsCollector(accumulationLevels, samRgRecords, refFile, perTargetCoverage, targetIntervals, probeIntervals, probeSetName);
    }
}

