/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class LinearGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String START_VERTEX = "Start Vertex";
    public static final String END_VERTEX = "End Vertex";
    private int size;

    public LinearGraphGenerator(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n2;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        Object v2 = null;
        for (int i2 = 0; i2 < this.size; ++i2) {
            V v3 = vertexFactory.createVertex();
            graph.addVertex(v3);
            if (v2 == null) {
                if (map != null) {
                    map.put(START_VERTEX, v3);
                }
            } else {
                graph.addEdge(v2, v3);
            }
            v2 = v3;
        }
        if (map != null && v2 != null) {
            map.put(END_VERTEX, v2);
        }
    }
}

