/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.WeightedGraph;
import org.jgrapht.generate.GraphGenerator;

public class GraphReader<V, E>
implements GraphGenerator<V, E, V> {
    private final BufferedReader _in;
    private final boolean _isWeighted;
    private final double _defaultWeight;

    private GraphReader(Reader reader, boolean bl, double d2) throws IOException {
        this._in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this._isWeighted = bl;
        this._defaultWeight = d2;
    }

    public GraphReader(Reader reader) throws IOException {
        this(reader, false, 1.0);
    }

    public GraphReader(Reader reader, double d2) throws IOException {
        this(reader, true, d2);
    }

    private String[] split(String string) {
        if (string == null) {
            return null;
        }
        return string.split("\\s+");
    }

    private String[] skipComments() {
        String[] stringArray = null;
        try {
            stringArray = this.split(this._in.readLine());
            while (stringArray != null && (stringArray.length == 0 || stringArray[0].equals("c") || stringArray[0].startsWith("%"))) {
                stringArray = this.split(this._in.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray;
    }

    private int readNodeCount() {
        String[] stringArray = this.skipComments();
        if (stringArray[0].equals("p")) {
            return Integer.parseInt(stringArray[1]);
        }
        return -1;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        Object object;
        int n2 = this.readNodeCount();
        if (map == null) {
            map = new HashMap<String, V>();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            object = vertexFactory.createVertex();
            graph.addVertex(object);
            map.put(Integer.toString(i2 + 1), object);
        }
        String[] stringArray = this.skipComments();
        while (stringArray != null) {
            if (stringArray[0].equals("e")) {
                object = graph.addEdge(map.get(stringArray[1]), map.get(stringArray[2]));
                if (this._isWeighted && object != null) {
                    double d2 = this._defaultWeight;
                    if (stringArray.length > 3) {
                        d2 = Double.parseDouble(stringArray[3]);
                    }
                    ((WeightedGraph)graph).setEdgeWeight(object, d2);
                }
            }
            stringArray = this.skipComments();
        }
    }
}

