/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broad.igv.DirectoryManager;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.blat.BlatTableModel;

public class BlatQueryWindow
extends JFrame {
    BlatTableModel model;
    private JMenuBar menuBar;
    private JMenu menu1;
    private JMenuItem saveItem;
    private JMenuItem closeItem;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTable blatTable;
    private JPanel headerPanel;
    private JPanel panel1;
    private JScrollPane scrollPane2;
    private JTextPane querySeqTextPane;

    public BlatQueryWindow(String querySequence, List<PSLRecord> records) {
        this.model = new BlatTableModel(records);
        this.initComponents();
        this.addSelectionListener();
        this.querySeqTextPane.setContentType("text/html");
        StringBuffer headerBuffer = new StringBuffer("<html>");
        headerBuffer.append("&nbsp;&nbsp;BLAT result for query sequence: <br>&nbsp;&nbsp&nbsp;&nbsp;");
        headerBuffer.append(querySequence);
        headerBuffer.append("<br><br>&nbsp;&nbsp;<i>Click on a row to go to alignment");
        this.querySeqTextPane.setText(headerBuffer.toString());
    }

    private void addSelectionListener() {
        this.blatTable.setSelectionMode(0);
        ListSelectionModel rowSM = this.blatTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e2.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    String chr = BlatQueryWindow.this.model.getChr(selectedRow);
                    int start = BlatQueryWindow.this.model.getStart(selectedRow);
                    int end = BlatQueryWindow.this.model.getEnd(selectedRow);
                    int w2 = (end - start) / 4;
                    start = Math.max(0, start - w2);
                    IGV.getInstance().goToLocus(chr + ":" + start + "-" + (end += w2));
                }
            }
        });
    }

    private void closeItemActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        this.dispose();
    }

    private void saveItemActionPerformed(ActionEvent e2) {
        File f2 = FileDialogUtils.chooseFile("Save BLAT results", DirectoryManager.getUserDirectory(), FileDialogUtils.SAVE);
        if (f2 != null) {
            try {
                this.model.save(f2);
            }
            catch (IOException e1) {
                MessageUtils.showErrorMessage("Error saving blat results ", e1);
            }
        }
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.menu1 = new JMenu();
        this.saveItem = new JMenuItem();
        this.closeItem = new JMenuItem();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.blatTable = new JTable(this.model);
        this.headerPanel = new JPanel();
        this.panel1 = new JPanel();
        this.scrollPane2 = new JScrollPane();
        this.querySeqTextPane = new JTextPane();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.menu1.setText("File");
        this.saveItem.setText("Save...");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BlatQueryWindow.this.saveItemActionPerformed(e2);
            }
        });
        this.menu1.add(this.saveItem);
        this.closeItem.setText("Close");
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                BlatQueryWindow.this.closeItemActionPerformed(e2);
            }
        });
        this.menu1.add(this.closeItem);
        this.menuBar.add(this.menu1);
        this.setJMenuBar(this.menuBar);
        this.contentPanel.setLayout(new BorderLayout(0, 5));
        this.scrollPane1.setViewportView(this.blatTable);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.headerPanel.setLayout(new BorderLayout());
        this.panel1.setLayout(new FlowLayout(0));
        this.headerPanel.add((Component)this.panel1, "North");
        this.scrollPane2.setHorizontalScrollBarPolicy(31);
        this.scrollPane2.setViewportView(this.querySeqTextPane);
        this.headerPanel.add((Component)this.scrollPane2, "Center");
        this.contentPanel.add((Component)this.headerPanel, "North");
        contentPane.add((Component)this.contentPanel, "Center");
        this.setSize(870, 570);
        this.setLocationRelativeTo(this.getOwner());
    }
}

