/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.exome.ExomeBlock;
import org.broad.igv.feature.exome.ExomeReferenceFrame;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.RenderContextImpl;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.ReferenceFrame;

public class DataPanelPainter {
    private static Logger log = Logger.getLogger(DataPanelPainter.class);
    private static Color exomeBorderColor = new Color(190, 190, 255);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void paint(Collection<TrackGroup> groups, RenderContext context, int width, Color background, Rectangle visibleRect) {
        Graphics graphics2D = null;
        try {
            graphics2D = (Graphics2D)context.getGraphics().create();
            ((Graphics2D)graphics2D).setBackground(background);
            graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            graphics2D.setColor(Color.BLACK);
            ReferenceFrame frame = context.getReferenceFrame();
            this.resetLastY(groups);
            if (frame.isExomeMode()) {
                int pEnd;
                int pStart;
                ExomeReferenceFrame exomeFrame = (ExomeReferenceFrame)frame;
                int blockGap = exomeFrame.getBlockGap();
                Rectangle panelClip = visibleRect;
                List<ExomeBlock> blocks = exomeFrame.getBlocks();
                int idx = exomeFrame.getFirstBlockIdx();
                RenderContextImpl exomeContext = new RenderContextImpl(null, null, frame, visibleRect);
                this.preloadTracks(groups, exomeContext, visibleRect);
                int lastPStart = 0;
                int exomeOrigin = ((ExomeReferenceFrame)frame).getExomeOrigin();
                int visibleBlockCount = 0;
                do {
                    ExomeBlock b2 = blocks.get(idx);
                    pStart = (int)((double)(b2.getExomeStart() - exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
                    pEnd = (int)((double)(b2.getExomeEnd() - exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
                    if (pEnd <= lastPStart) continue;
                    lastPStart = pStart;
                    if (pEnd == pStart) {
                        ++pEnd;
                    }
                    b2.setScreenBounds(pStart, pEnd);
                    Rectangle rect = new Rectangle(pStart, visibleRect.y, pEnd - pStart, visibleRect.height);
                    Graphics2D exomeGraphics = (Graphics2D)context.getGraphics().create();
                    exomeGraphics.setClip(rect.intersection(panelClip));
                    exomeGraphics.translate(pStart, 0);
                    ReferenceFrame tmpFrame = new ReferenceFrame(frame);
                    tmpFrame.setOrigin(b2.getGenomeStart());
                    RenderContextImpl tmpContext = new RenderContextImpl(null, exomeGraphics, tmpFrame, rect);
                    this.paintFrame(groups, tmpContext, rect.width, rect);
                    tmpContext.dispose();
                    exomeGraphics.dispose();
                    ++visibleBlockCount;
                } while (pStart < visibleRect.x + visibleRect.width && ++idx < blocks.size());
                String chr = frame.getChrName();
                List<ExomeReferenceFrame.Gene> genes = exomeFrame.getGenes(chr);
                idx = FeatureUtils.getIndexBefore(frame.getOrigin(), genes);
                exomeOrigin = ((ExomeReferenceFrame)frame).getExomeOrigin();
                int top = visibleRect.y;
                int lastXDrawn = -1;
                Graphics2D lineGraphics = context.getGraphic2DForColor(exomeBorderColor);
                do {
                    ExomeReferenceFrame.Gene gene = genes.get(idx);
                    double exomeStart = exomeFrame.genomeToExomePosition(gene.getStart());
                    double exomeEnd = exomeFrame.genomeToExomePosition(gene.getEnd());
                    pStart = (int)((exomeStart - (double)exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
                    pEnd = (int)((exomeEnd - (double)exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
                    if (pStart != lastXDrawn) {
                        lineGraphics.drawLine(pStart, top, pStart, top + visibleRect.height);
                    }
                    lineGraphics.drawLine(pEnd, top, pEnd, top + visibleRect.height);
                    lastXDrawn = pEnd;
                    if (pStart >= visibleRect.x + visibleRect.width) return;
                } while (++idx < genes.size());
                return;
            } else {
                this.paintFrame(groups, context, width, visibleRect);
            }
            return;
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintFrame(Collection<TrackGroup> groups, RenderContext context, int width, Rectangle visibleRect) {
        int trackX = 0;
        int trackY = 0;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (visibleRect != null && trackY > visibleRect.y + visibleRect.height) break;
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                Graphics2D greyGraphics = context.getGraphic2DForColor(UIConstants.LIGHT_GREY);
                greyGraphics.fillRect(0, trackY + 1, width, 9);
                trackY += 10;
            }
            if (group.isDrawBorder()) {
                Graphics2D graphics2D = context.getGraphic2DForColor(Color.black);
                graphics2D.drawLine(0, trackY - 1, width, trackY - 1);
            }
            List<Track> list = trackList = group.getTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (visibleRect != null) {
                        if (trackY > visibleRect.y + visibleRect.height) break;
                        if (trackY + trackHeight < visibleRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, width, trackHeight);
                    this.draw(track, rect, context);
                    trackY += trackHeight;
                }
            }
            if (!group.isDrawBorder()) continue;
            Graphics2D graphics2D = context.getGraphic2DForColor(Color.black);
            graphics2D.drawLine(0, trackY, width, trackY);
        }
    }

    private void resetLastY(Collection<TrackGroup> groups) {
        for (TrackGroup group : groups) {
            for (Track track : group.getTracks()) {
                track.resetLastY();
            }
        }
    }

    private final void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }

    private List<Track> getVisibleTracks(Collection<TrackGroup> groups) {
        ArrayList<Track> visibleTracks = new ArrayList<Track>();
        for (TrackGroup group : groups) {
            ArrayList<Track> trackList = new ArrayList<Track>(group.getTracks());
            for (Track track : trackList) {
                if (track == null || !track.isVisible()) continue;
                visibleTracks.add(track);
            }
        }
        return visibleTracks;
    }

    private void preloadTracks(Collection<TrackGroup> groups, RenderContext context, Rectangle visibleRect) {
        List<Track> visibleTracks = this.getVisibleTracks(groups);
        for (Track track : visibleTracks) {
            RenderContextImpl newContext = new RenderContextImpl(null, null, context.getReferenceFrame(), visibleRect);
            track.load(newContext);
        }
    }
}

