/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.Ga4ghAPIHelper;
import org.broad.igv.ga4gh.Ga4ghDataset;
import org.broad.igv.ga4gh.Ga4ghLoadDialog;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.ga4gh.Ga4ghReadset;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;

public class BrowseGa4ghAction
extends MenuAction {
    private static Logger log = Logger.getLogger(BrowseGa4ghAction.class);
    IGV igv;

    public BrowseGa4ghAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LongRunningTask.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Ga4ghProvider provider : Ga4ghAPIHelper.providers) {
                        for (Ga4ghDataset ds : provider.getDatasets()) {
                            List<Ga4ghReadset> readsets = Ga4ghAPIHelper.readsetSearch(provider, ds, 10);
                            ds.setReadsets(readsets);
                        }
                    }
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            Ga4ghLoadDialog dlg = new Ga4ghLoadDialog(IGV.getMainFrame(), Ga4ghAPIHelper.providers);
                            dlg.setModal(true);
                            dlg.setVisible(true);
                            dlg.dispose();
                        }
                    });
                }
                catch (IOException e2) {
                    log.error("Error opening Ga4gh dialog", e2);
                }
            }
        });
    }
}

