/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.google.common.eventbus.Subscribe;
import com.jidesoft.hints.ListDataIntelliHints;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.session.History;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.ZoomSliderPanel;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;

public class IGVCommandBar
extends JPanel {
    private static Logger log = Logger.getLogger(IGVCommandBar.class);
    static final String MODIFY_DETAILS_TOOLTIP = "Modify popup text behavior in data panels";
    private JComboBox chromosomeComboBox;
    private JComboBox genomeComboBox;
    private JideButton goButton;
    private JideButton homeButton;
    private JPanel locationPanel;
    private JideButton refreshButton;
    private JideToggleButton roiToggleButton;
    private JideButton detailsBehaviorButton;
    private JTextField searchTextField;
    private JPanel toolPanel;
    private JPanel zoomControl;
    private final int DEFAULT_CHROMOSOME_DROPDOWN_WIDTH = 120;
    private JideButton backButton;
    private JideButton forwardButton;
    private JideButton fitToWindowButton;
    private JideButton exomeButton;
    private SHOW_DETAILS_BEHAVIOR detailsBehavior = SHOW_DETAILS_BEHAVIOR.valueOf(PreferenceManager.getInstance().get("DETAILS_BEHAVIOR", SHOW_DETAILS_BEHAVIOR.HOVER.name()).toUpperCase());

    public SHOW_DETAILS_BEHAVIOR getDetailsBehavior() {
        return this.detailsBehavior;
    }

    public IGVCommandBar() {
        this.initComponents();
        SearchHints hints = new SearchHints(this.searchTextField);
        String currentChr = this.getDefaultReferenceFrame().getChrName();
        boolean isWholeGenome = currentChr.equals("All");
        this.chromosomeComboBox.setSelectedItem(currentChr);
        this.roiToggleButton.setEnabled(!isWholeGenome);
        this.zoomControl.setEnabled(!isWholeGenome);
        this.detailsBehaviorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                IGVCommandBar.this.getPopupMenuToolTipBehavior().show(e2.getComponent(), e2.getX(), e2.getY());
            }
        });
        this.getDefaultReferenceFrame().getEventBus().register(this);
    }

    private JPopupMenu getPopupMenuToolTipBehavior() {
        IGVPopupMenu popup = new IGVPopupMenu();
        for (final SHOW_DETAILS_BEHAVIOR behavior : SHOW_DETAILS_BEHAVIOR.values()) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(behavior.getLabel());
            menuItem.setSelected(this.detailsBehavior == behavior);
            menuItem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    IGVCommandBar.this.detailsBehavior = behavior;
                    PreferenceManager.getInstance().put("DETAILS_BEHAVIOR", behavior.name());
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    public void initializeGenomeList(ProgressMonitor monitor) throws FileNotFoundException, NoRouteToHostException {
        if (log.isDebugEnabled()) {
            log.debug("Enter initializeGenomeList");
        }
        if (monitor != null) {
            monitor.fireProgressChange(1);
        }
        this.genomeComboBox.removeAllItems();
        this.genomeComboBox.setRenderer(new ComboBoxRenderer());
        this.genomeComboBox.setToolTipText("Switch the current genome");
        GenomeManager.getInstance().buildGenomeItemList();
        this.refreshGenomeListComboBox();
        if (monitor != null) {
            monitor.fireProgressChange(50);
        }
        this.genomeComboBox.addActionListener(new GenomeBoxActionListener());
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                IGVCommandBar.this.goButtonActionPerformed(actionevent);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Exit initializeGenomeList");
        }
    }

    public void updateComponentStates() {
        if (this.exomeButton != null) {
            this.exomeButton.setEnabled(!this.getDefaultReferenceFrame().getChrName().equalsIgnoreCase("all"));
        }
    }

    private void loadGenomeListItem(final GenomeListItem genomeListItem) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (genomeListItem != null) {
                    IGV igv = IGV.getInstance();
                    if (genomeListItem == GenomeListItem.ITEM_MORE) {
                        IGVCommandBar.this.selectGenome(GenomeManager.getInstance().getGenomeId());
                        IGV.getInstance().loadGenomeFromServerAction();
                        return;
                    }
                    if (genomeListItem.getId().equalsIgnoreCase(GenomeManager.getInstance().getGenomeId())) {
                        return;
                    }
                    ProgressMonitor monitor = new ProgressMonitor();
                    ProgressBar.ProgressDialog progressDialog = ProgressBar.showProgressDialog(IGV.getMainFrame(), "Loading Genome...", monitor, false);
                    try {
                        monitor.fireProgressChange(50);
                        igv.resetSession(null);
                        Genome genome = igv.getGenomeManager().loadGenome(genomeListItem.getLocation(), null);
                        IGVCommandBar.this.updateChromosFromGenome(genome);
                        monitor.fireProgressChange(25);
                        IGVCommandBar.this.genomeComboBox.setSelectedItem(genomeListItem);
                        monitor.fireProgressChange(25);
                        FrameManager.getDefaultFrame().setChromosomeName(genome.getHomeChromosome(), true);
                        IGV.getInstance().doRefresh();
                    }
                    catch (GenomeServerException e2) {
                        log.error("Error loading genome: " + genomeListItem.getLocation(), e2);
                        JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error loading genome: " + genomeListItem.getDisplayableName());
                    }
                    catch (IOException e3) {
                        int choice = JOptionPane.showConfirmDialog(IGV.getMainFrame(), "The genome file [" + genomeListItem.getLocation() + "] could not be read. Would you like to remove the selected entry?", "", 2);
                        if (choice == 0) {
                            GenomeManager.getInstance().excludedUrl(genomeListItem.getLocation());
                            List<GenomeListItem> genomes = GenomeManager.getInstance().getGenomes();
                            genomes.remove(genomeListItem);
                            PreferenceManager.getInstance().saveGenomeIdDisplayList(genomes);
                            GenomeManager.getInstance().buildGenomeItemList();
                            GenomeManager.getInstance().updateImportedGenomePropertyFile();
                            IGVCommandBar.this.refreshGenomeListComboBox();
                        }
                    }
                    catch (Exception e4) {
                        log.error("Error initializing genome", e4);
                    }
                    finally {
                        if (progressDialog != null) {
                            progressDialog.setVisible(false);
                        }
                    }
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    void updateChromosomeDropdown() {
        String homeChr;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome == null) {
            return;
        }
        ArrayList<String> tmp = new ArrayList<String>(genome.getAllChromosomeNames().size());
        tmp.addAll(genome.getAllChromosomeNames());
        if (tmp.size() > 1 && (homeChr = genome.getHomeChromosome()).equals("All")) {
            tmp.add(0, "All");
        }
        Graphics2D graphics2D = (Graphics2D)this.chromosomeComboBox.getGraphics();
        Font font = this.chromosomeComboBox.getFont();
        FontMetrics fontMetrics = this.chromosomeComboBox.getFontMetrics(font);
        int w2 = 120;
        for (String chromosomeName : tmp) {
            int width;
            Rectangle2D textBounds = fontMetrics.getStringBounds(chromosomeName, graphics2D);
            if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w2) continue;
            w2 = width;
        }
        Object[] chomosomeNames = tmp.toArray();
        DefaultComboBoxModel<Object> defaultModel = new DefaultComboBoxModel<Object>(chomosomeNames);
        final int dropdownWidth = w2;
        this.chromosomeComboBox.setModel(defaultModel);
        this.chromosomeComboBox.setSelectedItem(genome.getHomeChromosome());
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVCommandBar.this.adjustChromosomeDropdownWidth(dropdownWidth);
            }
        });
    }

    protected void chromosomeChanged(final String chrName) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVCommandBar.this.roiToggleButton.setEnabled(!"All".equals(chrName));
                IGVCommandBar.this.zoomControl.setEnabled(!"All".equals(chrName));
                if (IGVCommandBar.this.chromosomeComboBox.getSelectedItem() != null && !IGVCommandBar.this.chromosomeComboBox.getSelectedItem().equals(chrName)) {
                    IGVCommandBar.this.setChromosomeComboBoxNoActionListeners(chrName);
                }
            }
        });
    }

    public void updateCurrentCoordinates() {
        String p2 = "";
        final String chrName = this.getDefaultReferenceFrame().getChrName();
        if (!"All".equals(chrName) && !FrameManager.isGeneListMode()) {
            p2 = this.getDefaultReferenceFrame().getFormattedLocusString();
        }
        final String position = p2;
        final History history = IGV.getInstance().getSession().getHistory();
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVCommandBar.this.searchTextField.setText(position);
                IGVCommandBar.this.forwardButton.setEnabled(history.canGoForward());
                IGVCommandBar.this.backButton.setEnabled(history.canGoBack());
                IGVCommandBar.this.roiToggleButton.setEnabled(!"All".equals(chrName));
                IGVCommandBar.this.zoomControl.setEnabled(!"All".equals(chrName));
            }
        });
    }

    private ReferenceFrame getDefaultReferenceFrame() {
        return FrameManager.getDefaultFrame();
    }

    public void setGeneListMode(boolean geneListMode) {
        this.genomeComboBox.setEnabled(!geneListMode);
        this.chromosomeComboBox.setEnabled(!geneListMode);
        this.zoomControl.setEnabled(!geneListMode);
    }

    public Collection<String> getGenomeDisplayNames() {
        HashSet<String> displayNames = new HashSet<String>();
        List<GenomeListItem> listItems = GenomeManager.getInstance().getGenomes();
        for (GenomeListItem genomeListItem : listItems) {
            displayNames.add(genomeListItem.getDisplayableName());
        }
        return displayNames;
    }

    public Collection<String> getSelectableGenomeIDs() {
        HashSet<String> ids = new HashSet<String>();
        List<GenomeListItem> listItems = GenomeManager.getInstance().getGenomes();
        for (GenomeListItem genomeListItem : listItems) {
            ids.add(genomeListItem.getId());
        }
        return ids;
    }

    public void selectGenome(String genomeId) {
        GenomeListItem matchingItem;
        if (!this.getSelectableGenomeIDs().contains(genomeId)) {
            boolean found = false;
            try {
                found = GenomeManager.getInstance().loadFromArchive(genomeId);
            }
            catch (IOException e2) {
                MessageUtils.showErrorMessage("Error checking server/cache for genomeId " + genomeId, e2);
            }
            if (found) {
                this.refreshGenomeListComboBox();
            }
        }
        if ((matchingItem = GenomeManager.getInstance().getLoadedGenomeListItemById(genomeId)) != null) {
            this.genomeComboBox.setSelectedItem(matchingItem);
        }
    }

    public void updateChromosFromGenome(Genome genome) {
        for (Chromosome chr : genome.getChromosomes()) {
            List<Cytoband> cytobands = chr.getCytobands();
            if (cytobands == null) continue;
            for (Cytoband cyto : cytobands) {
                FeatureDB.addFeature(cyto.getLongName(), cyto, genome);
            }
        }
        this.updateChromosomeDropdown();
    }

    public void refreshGenomeListComboBox() {
        this.genomeComboBox.setModel(this.getModelForGenomeListComboBox());
        String curId = GenomeManager.getInstance().getGenomeId();
        GenomeListItem item = GenomeManager.getInstance().getLoadedGenomeListItemById(curId);
        this.genomeComboBox.setSelectedItem(item);
    }

    private DefaultComboBoxModel getModelForGenomeListComboBox() {
        List<GenomeListItem> genomes = GenomeManager.getInstance().getGenomes();
        genomes.add(GenomeListItem.ITEM_MORE);
        return new DefaultComboBoxModel<GenomeListItem>(genomes.toArray(new GenomeListItem[0]));
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 32));
        JideBoxLayout layout = new JideBoxLayout(this, 0);
        this.setLayout(layout);
        this.locationPanel = new JPanel();
        this.locationPanel.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.locationPanel.setPreferredSize(new Dimension(150, 20));
        this.locationPanel.setLayout(new JideBoxLayout(this.locationPanel, 0));
        this.locationPanel.setAlignmentY(0.5f);
        this.locationPanel.add(Box.createRigidArea(new Dimension(10, 36)), "fix");
        this.genomeComboBox = new JComboBox();
        this.genomeComboBox.setMinimumSize(new Dimension(180, 27));
        this.genomeComboBox.setPreferredSize(new Dimension(180, 27));
        this.genomeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                try {
                    IGVCommandBar.this.adjustPopupWidth(IGVCommandBar.this.genomeComboBox);
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), e1);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
            }
        });
        this.locationPanel.add((Component)this.genomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.chromosomeComboBox = new JComboBox();
        this.chromosomeComboBox.setToolTipText("Select a chromosome to view");
        this.chromosomeComboBox.setMaximumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setMinimumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setPreferredSize(new Dimension(120, 30));
        this.chromosomeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.chromosomeComboBoxActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.chromosomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.searchTextField = new JTextField();
        this.searchTextField.setToolTipText("Enter a gene of locus, e.f. EGFR,   chr1,   or chr1:100,000-200,000");
        this.searchTextField.setMaximumSize(new Dimension(250, 15));
        this.searchTextField.setMinimumSize(new Dimension(100, 28));
        this.searchTextField.setPreferredSize(new Dimension(230, 28));
        this.searchTextField.setAlignmentY(0.5f);
        this.locationPanel.add((Component)this.searchTextField, "fix");
        this.goButton = new JideButton("Go");
        this.goButton.setToolTipText("Jump to gene or locus");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.goButtonActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.goButton, "fix");
        this.add((Component)this.locationPanel, "fix");
        this.add(Box.createHorizontalStrut(10), "fix");
        this.toolPanel = new JPanel();
        this.toolPanel.setAlignmentX(1.0f);
        this.toolPanel.setLayout(new JideBoxLayout(this.toolPanel, 0));
        this.homeButton = new JideButton();
        this.homeButton.setAlignmentX(1.0f);
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
        this.homeButton.setMaximumSize(new Dimension(32, 32));
        this.homeButton.setMinimumSize(new Dimension(32, 32));
        this.homeButton.setPreferredSize(new Dimension(32, 32));
        this.homeButton.setToolTipText("Jump to whole genome view");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.homeButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.homeButton, "fix");
        this.backButton = new JideButton();
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/images/left-arrow.gif")));
        this.backButton.setToolTipText("Go back");
        this.backButton.setMaximumSize(new Dimension(32, 32));
        this.backButton.setMinimumSize(new Dimension(32, 32));
        this.backButton.setPreferredSize(new Dimension(32, 32));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGV.getInstance().getSession().getHistory().back();
            }
        });
        this.backButton.setEnabled(false);
        this.toolPanel.add((Component)this.backButton, "fix");
        this.forwardButton = new JideButton();
        this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/images/right-arrow.gif")));
        this.forwardButton.setToolTipText("Go forward");
        this.forwardButton.setMaximumSize(new Dimension(32, 32));
        this.forwardButton.setMinimumSize(new Dimension(32, 32));
        this.forwardButton.setPreferredSize(new Dimension(32, 32));
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGV.getInstance().getSession().getHistory().forward();
            }
        });
        this.forwardButton.setEnabled(false);
        this.toolPanel.add((Component)this.forwardButton, "fix");
        this.refreshButton = new JideButton();
        this.refreshButton.setAlignmentX(1.0f);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh24.gif")));
        this.refreshButton.setMaximumSize(new Dimension(32, 32));
        this.refreshButton.setMinimumSize(new Dimension(32, 32));
        this.refreshButton.setPreferredSize(new Dimension(32, 32));
        this.refreshButton.setToolTipText("Refresh the screen");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.refreshButton, "fix");
        ImageIcon regionOfInterestIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.REGION_OF_INTEREST);
        this.roiToggleButton = new JideToggleButton(regionOfInterestIcon);
        this.roiToggleButton.setAlignmentX(1.0f);
        this.roiToggleButton.setToolTipText("Define a region of interest.");
        this.roiToggleButton.setMaximumSize(new Dimension(32, 32));
        this.roiToggleButton.setMinimumSize(new Dimension(32, 32));
        this.roiToggleButton.setPreferredSize(new Dimension(32, 32));
        this.roiToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.roiToggleButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.roiToggleButton, "fix");
        this.fitToWindowButton = new JideButton();
        this.fitToWindowButton.setAlignmentX(1.0f);
        this.fitToWindowButton.setIcon(new ImageIcon(this.getClass().getResource("/images/collapseall.gif")));
        this.fitToWindowButton.setMaximumSize(new Dimension(32, 32));
        this.fitToWindowButton.setMinimumSize(new Dimension(32, 32));
        this.fitToWindowButton.setPreferredSize(new Dimension(32, 32));
        this.fitToWindowButton.setToolTipText("Resize tracks to fit in window.");
        this.fitToWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new FitDataToWindowMenuAction(null, 0, IGV.getInstance()).actionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.fitToWindowButton, "fix");
        ImageIcon noTooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.NO_TOOLTIP);
        ImageIcon tooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.TOOLTIP);
        this.detailsBehaviorButton = new JideButton(noTooltipIcon);
        this.detailsBehaviorButton.setAlignmentX(1.0f);
        this.detailsBehaviorButton.setToolTipText(MODIFY_DETAILS_TOOLTIP);
        this.detailsBehaviorButton.setMaximumSize(new Dimension(32, 32));
        this.detailsBehaviorButton.setMinimumSize(new Dimension(32, 32));
        this.detailsBehaviorButton.setPreferredSize(new Dimension(32, 32));
        this.toolPanel.add((Component)this.detailsBehaviorButton, "fix");
        boolean showExomeButton = Globals.isDevelopment();
        if (showExomeButton) {
            this.exomeButton = new JideButton();
            this.exomeButton.setButtonStyle(0);
            this.exomeButton.setText(FrameManager.isExomeMode() ? "Genome" : "Exome");
            this.exomeButton.setToolTipText("Click to toggle between 'exome' and 'genome' views");
            this.exomeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean newMode;
                    int modifiers = actionEvent.getModifiers();
                    boolean showTrackMenu = (modifiers & 8) > 0;
                    boolean bl = newMode = !FrameManager.isExomeMode();
                    if (!FrameManager.setExomeMode(newMode, showTrackMenu)) {
                        return;
                    }
                    String label = newMode ? "Genome" : "Exome";
                    IGVCommandBar.this.exomeButton.setText(label);
                    IGV.getInstance().resetFrames();
                }
            });
            this.toolPanel.add((Component)this.exomeButton, "fix");
        }
        this.add(this.toolPanel);
        this.add(Box.createHorizontalGlue(), "vary");
        this.zoomControl = new ZoomSliderPanel();
        Dimension dimSize = new Dimension(200, 30);
        this.zoomControl.setPreferredSize(dimSize);
        this.zoomControl.setMinimumSize(dimSize);
        this.zoomControl.setMaximumSize(dimSize);
        this.zoomControl.setToolTipText("Click + to zoom in,  - to zoom out");
        this.zoomControl.setOpaque(false);
        this.add((Component)this.zoomControl, "fix");
        this.add(Box.createHorizontalStrut(20), "fix");
    }

    public GenomeListItem getGenomeSelectedInDropdown() {
        return (GenomeListItem)this.genomeComboBox.getSelectedItem();
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = width > 120 ? width : 120;
        this.chromosomeComboBox.setMaximumSize(new Dimension(newWidth, 35));
        this.chromosomeComboBox.setMinimumSize(new Dimension(newWidth, 27));
        this.chromosomeComboBox.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }

    private void adjustPopupWidth(JComboBox box) {
        if (box.getItemCount() == 0) {
            return;
        }
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu popup = (JPopupMenu)comp;
        JScrollPane scrollPane = null;
        for (Component scomp : popup.getComponents()) {
            if (!(scomp instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)scomp;
        }
        if (scrollPane == null) {
            return;
        }
        int rendererWidth = box.getWidth();
        for (int index = 0; index < box.getItemCount(); ++index) {
            Object value = box.getItemAt(index);
            Component rendererComp = box.getRenderer().getListCellRendererComponent(null, value, index, false, false);
        }
        Dimension size = scrollPane.getPreferredSize();
        size.width = Math.max(size.width, rendererWidth);
        scrollPane.setPreferredSize(size);
        scrollPane.setMaximumSize(size);
        scrollPane.revalidate();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        String chrName;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (FrameManager.isGeneListMode()) {
            IGV.getInstance().setGeneList(null);
        }
        if (genome != null && (chrName = genome.getHomeChromosome()) != null && !chrName.equals(this.chromosomeComboBox.getSelectedItem())) {
            ViewChange.ChromosomeChangeCause cause = new ViewChange.ChromosomeChangeCause(evt.getSource(), chrName);
            cause.setRecordHistory(true);
            this.getDefaultReferenceFrame().getEventBus().post(cause);
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        IGV.getInstance().doRefresh();
        System.gc();
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        String chrName = (String)combobox.getSelectedItem();
        if (chrName != null) {
            this.getDefaultReferenceFrame().getEventBus().post(new ViewChange.ChromosomeChangeCause(combobox, chrName));
        }
    }

    private void setChromosomeComboBoxNoActionListeners(String chrName) {
        ActionListener[] listeners;
        for (ActionListener l2 : listeners = this.chromosomeComboBox.getActionListeners()) {
            this.chromosomeComboBox.removeActionListener(l2);
        }
        this.chromosomeComboBox.setSelectedItem(chrName);
        for (ActionListener l2 : listeners) {
            this.chromosomeComboBox.addActionListener(l2);
        }
    }

    @Subscribe
    public void receiveViewChangeResult(ViewChange.Result e2) {
        String chrName = this.getDefaultReferenceFrame().getChrName();
        this.setChromosomeComboBoxNoActionListeners(chrName);
        this.updateCurrentCoordinates();
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        String searchText = this.searchTextField.getText();
        this.searchByLocus(searchText);
    }

    public void searchByLocus(String searchText) {
        if (log.isDebugEnabled()) {
            log.debug("Enter search by locus: " + searchText);
        }
        if (searchText != null && searchText.length() > 0) {
            this.searchTextField.setText(searchText);
            new SearchCommand(this.getDefaultReferenceFrame(), searchText).execute();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit search by locus: " + searchText);
        }
    }

    private void roiToggleButtonActionPerformed(ActionEvent evt) {
        if (this.roiToggleButton.isSelected()) {
            IGV.getInstance().beginROI(this.roiToggleButton);
        } else {
            IGV.getInstance().endROI();
        }
    }

    private class SearchHints
    extends ListDataIntelliHints<String> {
        public SearchHints(JTextComponent jTextComponent) {
            super(jTextComponent, new String[0]);
        }

        @Override
        public void acceptHint(Object context) {
            String text = (String)context;
            super.acceptHint(context);
            IGVCommandBar.this.searchByLocus(text);
        }

        @Override
        public boolean updateHints(Object context) {
            String text = (String)context;
            if (text.length() <= 1) {
                return false;
            }
            List<NamedFeature> features = FeatureDB.getFeaturesList(text, SearchCommand.SEARCH_LIMIT);
            List<SearchCommand.SearchResult> results = SearchCommand.getResults(features);
            Object[] list = SearchCommand.getSelectionList(results, false);
            if (list.length >= 1) {
                this.setListData(list);
                return true;
            }
            return false;
        }
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                label.setSize(label.getWidth() + 10, label.getHeight());
                renderer = label;
            }
            if (list != null) {
                if (isSelected) {
                    ((Component)renderer).setBackground(list.getSelectionBackground());
                    ((Component)renderer).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)renderer).setBackground(list.getBackground());
                    ((Component)renderer).setForeground(list.getForeground());
                }
                ((Component)renderer).setFont(list.getFont());
            }
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object selItem = IGVCommandBar.this.genomeComboBox.getSelectedItem();
            if (!(selItem instanceof GenomeListItem)) {
                return;
            }
            GenomeListItem genomeListItem = (GenomeListItem)selItem;
            IGVCommandBar.this.loadGenomeListItem(genomeListItem);
        }
    }

    public static enum SHOW_DETAILS_BEHAVIOR {
        HOVER("Show Details on Hover"),
        CLICK("Show Details on Click"),
        NEVER("Never Show Details");

        private final String label;

        private SHOW_DETAILS_BEHAVIOR(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

