/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.session.Persistable;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public interface Track
extends Persistable {
    public String getId();

    public void load(RenderContext var1);

    public boolean isFilterable();

    public void render(RenderContext var1, Rectangle var2);

    public void overlay(RenderContext var1, Rectangle var2);

    public void resetLastY();

    public void renderName(Graphics2D var1, Rectangle var2, Rectangle var3);

    public void renderAttributes(Graphics2D var1, Rectangle var2, Rectangle var3, List<String> var4, List<MouseableRegion> var5);

    public void setName(String var1);

    public String getName();

    public String getNameValueString(int var1);

    public String getSample();

    public void setUrl(String var1);

    public ResourceLocator getResourceLocator();

    public Collection<ResourceLocator> getResourceLocators();

    public void setAttributeValue(String var1, String var2);

    public String getAttributeValue(String var1);

    public void setVisible(boolean var1);

    public boolean isVisible();

    public void setOverlayed(boolean var1);

    public TrackType getTrackType();

    public void setHeight(int var1);

    public void setHeight(int var1, boolean var2);

    public void setY(int var1);

    public int getY();

    public void setColorScale(ContinuousColorScale var1);

    public ContinuousColorScale getColorScale();

    public int getHeight();

    public int getMinimumHeight();

    public void setDataRange(DataRange var1);

    public boolean hasDataRange();

    public DataRange getDataRange();

    public Color getColor();

    public void setColor(Color var1);

    public Color getAltColor();

    public void setAltColor(Color var1);

    public void setWindowFunction(WindowFunction var1);

    public WindowFunction getWindowFunction();

    public void setRendererClass(Class var1);

    public Renderer getRenderer();

    public void setSelected(boolean var1);

    public boolean isSelected();

    public boolean isSortable();

    public boolean isShowDataRange();

    public String getValueStringAt(String var1, double var2, int var4, ReferenceFrame var5);

    public float getRegionScore(String var1, int var2, int var3, int var4, RegionScoreType var5, String var6);

    public float getRegionScore(String var1, int var2, int var3, int var4, RegionScoreType var5, String var6, List<Track> var7);

    public void setFontSize(int var1);

    public int getFontSize();

    public boolean handleDataClick(TrackClickEvent var1);

    public void handleNameClick(MouseEvent var1);

    public Collection<WindowFunction> getAvailableWindowFunctions();

    public void setProperties(TrackProperties var1);

    public Feature getFeatureAtMousePosition(TrackClickEvent var1);

    public void setSampleId(String var1);

    public float logScaleData(float var1);

    public boolean isRegionScoreType(RegionScoreType var1);

    public int getVisibilityWindow();

    public void setVisibilityWindow(int var1);

    public boolean isItemRGB();

    public boolean isUseScore();

    public float getViewLimitMin();

    public float getViewLimitMax();

    public DisplayMode getDisplayMode();

    public void setDisplayMode(DisplayMode var1);

    public IGVPopupMenu getPopupMenu(TrackClickEvent var1);

    public boolean isDrawYLine();

    public float getYLine();

    public void dispose();

    public boolean getAutoScale();

    public void setAutoScale(boolean var1);

    public static enum DisplayMode {
        COLLAPSED,
        SQUISHED,
        EXPANDED,
        ALTERNATIVE_SPLICE;

    }
}

