/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.synteny.AbstractMapping;
import org.broad.igv.synteny.Anchor;
import org.broad.igv.util.ChromosomeColors;

public class Region
extends AbstractMapping {
    List<Anchor> anchors = new ArrayList<Anchor>();

    public void addAnchor(Anchor a2) {
        String fromDirection = "+";
        String fromChr = this.getFromChr();
        String toDirection = a2.getDirection() ? "+" : "-";
        String toChr = a2.getToChr();
        if (this.anchors.size() > 0) {
            Anchor lastAnchor = this.anchors.get(this.anchors.size() - 1);
            int lastFromEnd = lastAnchor.getFromEnd();
            int lastToEnd = lastAnchor.getToEnd();
            Anchor fillerAnchor = new Anchor();
            int fromStart = lastFromEnd;
            int fromEnd = a2.getFromStart();
            int toStart = lastToEnd;
            int toEnd = a2.getToStart();
            if (toEnd > toStart && fromEnd > fromStart) {
                fillerAnchor.setParameters("psueudo", fromChr, fromStart, fromEnd, fromDirection, toChr, lastToEnd, a2.getToStart(), toDirection);
                fillerAnchor.psuedo = true;
                this.anchors.add(fillerAnchor);
            }
        }
        this.anchors.add(a2);
    }

    public List<Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public double mapPosition(int position) {
        for (Anchor a2 : this.anchors) {
            if (!a2.containsFromPosition(position)) continue;
            return a2.mapPosition(position);
        }
        if (this.containsFromPosition(position)) {
            double delta = this.scaleFactor * (double)(position - this.fromStart);
            if (this.direction) {
                return (double)this.toStart + delta;
            }
            return (double)this.toEnd - delta;
        }
        return -1.0;
    }

    public String toBed() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String name = this.getToChr() + ":" + this.getToStart() + "-" + this.getToEnd();
        int blockCount = 0;
        String blockSizes = "";
        String blockStarts = "";
        for (Anchor a2 : this.anchors) {
            if (a2.psuedo) continue;
            ++blockCount;
            blockSizes = blockSizes + (a2.getFromEnd() - a2.getFromStart()) + ",";
            blockStarts = blockStarts + (a2.getFromStart() - this.getFromStart()) + ",";
        }
        pw.print(this.getFromChr() + "\t" + this.getFromStart() + "\t" + this.getFromEnd() + "\t" + name + "\t1000\t" + (this.getDirection() ? "+" : "-") + "\t" + this.getFromStart() + "\t" + this.getFromEnd() + "\t" + Region.convertColorToRGBString(ChromosomeColors.getColor(this.getToChr())) + "\t" + blockCount + "\t" + blockSizes + "\t" + blockStarts);
        return sw.toString();
    }

    public static String convertColorToRGBString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }
}

