/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.util.ArrayList;
import java.util.List;

public class MultipleAlignmentBlock {
    private String chr;
    private int start;
    private int end;
    private int[] gapAdjustedIndex;
    private double score;
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private List<Gap> gaps = new ArrayList<Gap>();
    private String key;

    public String getKey() {
        if (this.key == null) {
            StringBuilder b2 = new StringBuilder();
            b2.append(this.chr);
            b2.append(":");
            b2.append(this.start);
            b2.append("-");
            b2.append(this.end);
            for (Sequence seq : this.sequences) {
                b2.append("_");
                b2.append(seq.getSpecies());
            }
            this.key = b2.toString();
        }
        return this.key;
    }

    public String getChr() {
        return this.chr;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double getScore() {
        return this.score;
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public int getGapAdjustedIndex(int position) {
        return this.gapAdjustedIndex[position - this.start];
    }

    public Sequence getRefSequence() {
        return this.sequences.get(0);
    }

    public List<Gap> getGaps() {
        return this.gaps;
    }

    public void addSequence(Sequence sequence) {
        if (this.sequences.isEmpty()) {
            this.chr = sequence.chr;
            this.start = sequence.start;
            this.end = this.start + sequence.size;
            this.findGaps(sequence.text);
        }
        this.sequences.add(sequence);
    }

    private void findGaps(String referenceText) {
        byte[] bytes = referenceText.getBytes();
        this.gapAdjustedIndex = new int[this.end - this.start];
        int refPosition = 0;
        byte dash = 45;
        Gap gap = null;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (bytes[i2] == dash) {
                if (gap == null) {
                    double gapPosition = this.start + refPosition;
                    gap = new Gap(gapPosition, i2);
                    continue;
                }
                gap.incSize();
                continue;
            }
            if (gap != null) {
                this.gaps.add(gap);
                gap = null;
            }
            this.gapAdjustedIndex[refPosition] = i2;
            ++refPosition;
        }
        if (gap != null) {
            this.gaps.add(gap);
        }
    }

    public Sequence getSequence(String sp) {
        for (Sequence seq : this.sequences) {
            if (!seq.getSpecies().equals(sp)) continue;
            return seq;
        }
        return null;
    }

    public static class Sequence {
        private String species;
        private String chr;
        private int start;
        private int size;
        private char strand;
        private int srcSize;
        private String text;

        public Sequence(String species, String chr, int start, int size, char strand, int srcSize, String text) {
            this.species = species;
            this.chr = chr;
            this.start = start;
            this.size = size;
            this.strand = strand;
            this.srcSize = srcSize;
            this.text = text;
        }

        public String getSpecies() {
            return this.species;
        }

        public void setSpecies(String species) {
            this.species = species;
        }

        public String getChr() {
            return this.chr;
        }

        public void setChr(String chr) {
            this.chr = chr;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public char getStrand() {
            return this.strand;
        }

        public void setStrand(char strand) {
            this.strand = strand;
        }

        public int getSrcSize() {
            return this.srcSize;
        }

        public void setSrcSize(int srcSize) {
            this.srcSize = srcSize;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static class Gap {
        double position;
        int startIdx;
        int size;

        public Gap(double position, int startIdx) {
            this.position = position;
            this.startIdx = startIdx;
            this.size = 1;
        }

        public void incSize() {
            ++this.size;
        }
    }
}

