/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;

public class GSUtils {
    static final Logger log = Logger.getLogger(GSUtils.class);
    private static String tokenSaveDir = ".gs";
    private static String tokenSaveFileName = ".gstoken";
    private static String usernameSaveFileName = ".gsusername";
    public static String gsUser = null;
    public static String gsToken = null;

    private static File getTokenSaveDir() {
        String userDir = System.getProperty("user.home");
        File gsDir = new File(userDir, tokenSaveDir);
        if (!gsDir.exists()) {
            gsDir.mkdir();
        }
        return gsDir;
    }

    private static File getTokenFile() {
        File gsDir = GSUtils.getTokenSaveDir();
        return gsDir != null && gsDir.exists() ? new File(gsDir, tokenSaveFileName) : null;
    }

    private static File getUsernameFile() {
        File gsDir = GSUtils.getTokenSaveDir();
        return gsDir != null && gsDir.exists() ? new File(gsDir, usernameSaveFileName) : null;
    }

    public static void setGSToken(String newToken) {
        if (gsToken == null || !gsToken.equals(newToken)) {
            gsToken = newToken;
            if (Globals.isTesting()) {
                return;
            }
            Object bw = null;
            File gsDir = GSUtils.getTokenSaveDir();
            if (!gsDir.isDirectory()) {
                log.error("Could not store token for SSO.  File " + gsDir.getAbsolutePath() + "exists and is not a directory.");
                return;
            }
            File tokenFile = GSUtils.getTokenFile();
            if (tokenFile.exists()) {
                tokenFile.delete();
            }
            GSUtils.writeToFile(gsToken, tokenFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGSToken() {
        File file;
        if (gsToken == null && !Globals.isTesting() && (file = GSUtils.getTokenFile()).exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                gsToken = br.readLine();
            }
            catch (IOException e2) {
                log.error("Error reading GS cookie", e2);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return gsToken;
    }

    public static void setGSUser(String newUser) {
        if (gsUser == null || !gsUser.equals(newUser)) {
            gsUser = newUser;
            if (Globals.isTesting()) {
                return;
            }
            File gsDir = GSUtils.getTokenSaveDir();
            if (!gsDir.isDirectory()) {
                log.error("Could not store token for SSO.  File " + gsDir.getAbsolutePath() + "exists and is not a directory.");
                return;
            }
            File userFile = GSUtils.getUsernameFile();
            if (userFile.exists()) {
                userFile.delete();
            }
            GSUtils.writeToFile(gsUser, userFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGSUser() throws IOException {
        if (gsUser == null && !Globals.isTesting()) {
            BufferedReader br = null;
            try {
                File tokenFile = GSUtils.getUsernameFile();
                if (tokenFile.exists()) {
                    br = new BufferedReader(new FileReader(tokenFile));
                    gsUser = br.readLine().trim();
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return gsUser;
    }

    public static void logout() {
        File tokenFile;
        gsToken = null;
        gsUser = null;
        gsToken = null;
        File userfile = GSUtils.getUsernameFile();
        if (userfile.exists()) {
            userfile.delete();
        }
        if ((tokenFile = GSUtils.getTokenFile()).exists()) {
            tokenFile.delete();
        }
        try {
            URI gsURI = new URI(PreferenceManager.getInstance().get("GENOME_SPACE_DM_SERVER"));
            CookieManager manager = (CookieManager)CookieManager.getDefault();
            if (manager == null) {
                return;
            }
            CookieStore cookieStore = manager.getCookieStore();
            ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>(cookieStore.get(gsURI));
            for (HttpCookie cookie : cookies) {
                String name = cookie.getName();
                if (!name.equals("gs-token") && !name.equals("gs-username")) continue;
                cookieStore.remove(gsURI, cookie);
            }
        }
        catch (URISyntaxException e2) {
            log.error("Error creating GS URI", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String line, File aFile) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(aFile));
            bw.write(line);
            bw.close();
        }
        catch (Exception e2) {
            log.error("Failed to save the token for later Single Sign on", e2);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isGenomeSpace(URL url) {
        String dmServer = GSUtils.getDMHost();
        String atmServer = GSUtils.getATMHost();
        return url.getHost().contains(dmServer) || url.getHost().contains(atmServer);
    }

    private static synchronized String getDMHost() {
        try {
            return new URL(PreferenceManager.getInstance().get("GENOME_SPACE_DM_SERVER")).getHost();
        }
        catch (MalformedURLException e2) {
            log.error(e2);
            return null;
        }
    }

    private static synchronized String getATMHost() {
        try {
            return new URL(PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER")).getHost();
        }
        catch (MalformedURLException e2) {
            log.error(e2);
            return null;
        }
    }

    public static String parseDataFormatString(String format) {
        int versionIdx = format.lastIndexOf("/");
        String tmp = format.substring(0, versionIdx);
        int extIdx = tmp.lastIndexOf("/") + 1;
        return "." + tmp.substring(extIdx);
    }
}

