/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonObject;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;

public class Ga4ghAlignment
extends SAMAlignment {
    protected int alignmentStart;
    protected int alignmentEnd;
    int inferredInsertSize;
    int mappingQuality = 255;
    String readName;
    protected String cigarString;
    protected String readSequence;

    public Ga4ghAlignment(JsonObject json) {
        String refName = json.get("referenceSequenceName").getAsString();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.setChr(genome == null ? refName : genome.getChromosomeAlias(refName));
        this.readName = json.get("name").getAsString();
        this.flags = json.get("flags").getAsInt();
        this.start = this.alignmentStart = json.get("position").getAsInt() - 1;
        this.mappingQuality = json.get("mappingQuality").getAsInt();
        this.inferredInsertSize = json.get("templateLength").getAsInt();
        this.readSequence = json.get("originalBases").getAsString();
        this.cigarString = json.get("cigar").getAsString();
        this.end = this.alignmentEnd = this.alignmentStart + this.getReferenceLength(this.cigarString);
        if (this.isPaired()) {
            String mateReferenceName = json.get("mateReferenceSequenceName").getAsString();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            this.setMate(new ReadMate(mateChr, json.get("matePosition").getAsInt() - 1, (this.flags & 0x20) != 0, (this.flags & 8) != 0));
        }
        String baseQualityString = json.get("baseQuality").getAsString();
        byte[] baseQualities = baseQualityString.getBytes();
        int i2 = 0;
        while (i2 < baseQualities.length) {
            int n2 = i2++;
            baseQualities[n2] = (byte)(baseQualities[n2] - 33);
        }
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks(this.cigarString, this.readSequence.getBytes(), baseQualities, null, null, -1);
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public int getMappingQuality() {
        return this.mappingQuality;
    }

    @Override
    public int getInferredInsertSize() {
        return this.inferredInsertSize;
    }

    @Override
    public String getCigarString() {
        return this.cigarString;
    }

    @Override
    public int getReadLength() {
        return this.readSequence.length();
    }

    @Override
    public String getReadSequence() {
        return this.readSequence;
    }

    @Override
    protected String getAttributeString(boolean truncate) {
        return "";
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    public int getReferenceLength(String cigarString) {
        TextCigarCodec codec = new TextCigarCodec();
        Cigar cigar = codec.decode(cigarString);
        return cigar.getReferenceLength();
    }
}

