/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

public class CompositeScore
implements LocusScore {
    float[] data;
    String[] probes;
    float value;
    private int start;
    private int end;
    private WindowFunction windowFunction;

    public CompositeScore(int start, int end, float value, float[] data, String[] probes, WindowFunction windowFunction) {
        this.start = start;
        this.end = end;
        this.value = value;
        this.probes = probes;
        this.data = data;
        if (data.length > 5) {
            float[] temp = new float[5];
            System.arraycopy(data, 0, temp, 0, 5);
            this.data = temp;
            if (probes != null && probes.length > 5) {
                String[] temp2 = new String[5];
                System.arraycopy(probes, 0, temp2, 0, 5);
                this.probes = temp2;
            }
        }
    }

    public CompositeScore(CompositeScore sc) {
        this.start = sc.start;
        this.end = sc.end;
        this.value = sc.value;
        this.probes = sc.probes;
        this.data = sc.data;
    }

    public CompositeScore copy() {
        return new CompositeScore(this);
    }

    @Override
    public float getScore() {
        return this.value;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        if (this.data == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Composite value = " + this.value + " (" + windowFunction + ")<br>");
        buf.append("-------------------------------<br>");
        for (int j2 = 0; j2 < this.data.length; ++j2) {
            String probe;
            buf.append(String.valueOf(this.data[j2]));
            String string = probe = this.probes != null && j2 < this.probes.length ? this.probes[j2] : null;
            if (probe != null && probe.length() > 0) {
                buf.append("&nbsp;(");
                buf.append(this.probes[j2]);
                buf.append(")");
            }
            buf.append("<br>");
        }
        if (this.data.length >= 5) {
            buf.append("...<br>");
        }
        return buf.toString();
    }

    @Override
    public String getChr() {
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    public int getExtendedStart() {
        return this.getStart();
    }

    public int getExtendedEnd() {
        return this.getEnd();
    }
}

