/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.cursor.RegionFilter;

public class CursorFilterDialog
extends JDialog {
    List<CursorTrack> tracks;
    RegionFilter filter;
    boolean canceled;
    String[] trackNames;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JRadioButton matchAllRB;
    private JRadioButton matchAnyRB;
    private JPanel filterPanel;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public static void main(String[] args) {
        new CursorFilterDialog(null).setVisible(true);
    }

    public CursorFilterDialog(Frame owner) {
        this(owner, null, new RegionFilter());
    }

    public CursorFilterDialog(Frame owner, List<CursorTrack> tracks, RegionFilter filter) {
        super(owner);
        List<RegionFilter.Clause> clauses;
        this.initComponents();
        this.tracks = tracks;
        if (tracks == null || tracks.isEmpty()) {
            this.trackNames = new String[0];
        } else {
            this.trackNames = new String[tracks.size()];
            for (int i2 = 0; i2 < tracks.size(); ++i2) {
                this.trackNames[i2] = tracks.get(i2).getName();
            }
        }
        if (filter == null) {
            filter = new RegionFilter();
        }
        if ((clauses = filter.getClauses()) == null || clauses.isEmpty()) {
            this.addFilter(null);
        } else {
            for (RegionFilter.Clause c2 : clauses) {
                this.addFilter(c2);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void addFilter(RegionFilter.Clause clause) {
        final JPanel p2 = new JPanel();
        p2.setMaximumSize(new Dimension(1000, 30));
        p2.setLayout(new JideBoxLayout(p2, 0));
        JComboBox<String> trackCB = new JComboBox<String>(this.trackNames);
        p2.add(trackCB, "vary");
        JComboBox<String> signalCB = new JComboBox<String>(new String[]{"Score", "Signal"});
        p2.add(signalCB, "fix");
        JComboBox<String> predCB = new JComboBox<String>(new String[]{"is greater than", "is less than"});
        predCB.setSize(new Dimension(100, 20));
        p2.add(predCB, "flexible");
        JTextField valueField = new JTextField();
        valueField.setSize(new Dimension(50, 20));
        valueField.setPreferredSize(new Dimension(50, 20));
        valueField.setMaximumSize(new Dimension(50, 20));
        p2.add((Component)valueField, "fix");
        JideButton plusButton = new JideButton("+");
        plusButton.setSize(new Dimension(20, 20));
        plusButton.setPreferredSize(new Dimension(20, 20));
        plusButton.setMaximumSize(new Dimension(20, 20));
        plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorFilterDialog.this.addFilter(null);
            }
        });
        p2.add((Component)plusButton, "fix");
        JideButton minusButton = new JideButton("-");
        minusButton.setSize(new Dimension(20, 20));
        minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.out.println("Remove " + p2);
            }
        });
        p2.add((Component)minusButton, "fix");
        this.filterPanel.add(p2);
        this.filterPanel.revalidate();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.matchAllRB = new JRadioButton();
        this.matchAnyRB = new JRadioButton();
        this.filterPanel = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("Define Regions");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout(0, 5));
        this.panel1.setLayout(new FlowLayout(0));
        this.matchAllRB.setText("Match all of the following");
        this.matchAllRB.setSelected(true);
        this.panel1.add(this.matchAllRB);
        this.matchAnyRB.setText("Match any of the following");
        this.panel1.add(this.matchAnyRB);
        this.contentPanel.add((Component)this.panel1, "North");
        this.filterPanel.setLayout(new BoxLayout(this.filterPanel, 1));
        this.contentPanel.add((Component)this.filterPanel, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorFilterDialog.this.okButtonActionPerformed(e2);
                CursorFilterDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CursorFilterDialog.this.cancelButtonActionPerformed(e2);
                CursorFilterDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(765, 570);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.matchAllRB);
        buttonGroup1.add(this.matchAnyRB);
    }
}

