/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.ocsp.CertificateID;

public class Req
implements java.security.cert.X509Extension {
    private Request req;

    public Req(Request req) {
        this.req = req;
    }

    public CertificateID getCertID() {
        return new CertificateID(this.req.getReqCert());
    }

    public X509Extensions getSingleRequestExtensions() {
        return X509Extensions.getInstance(this.req.getSingleRequestExtensions());
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getSingleRequestExtensions();
        if (extensions != null) {
            Enumeration e2 = extensions.oids();
            while (e2.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e2.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.getSingleRequestExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded("DER");
            }
            catch (Exception e2) {
                throw new RuntimeException("error encoding " + e2.toString());
            }
        }
        return null;
    }
}

