/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.Arrays;

class IntArray {
    private int[] m_ints;

    public IntArray(int intLen) {
        this.m_ints = new int[intLen];
    }

    public IntArray(int[] ints) {
        this.m_ints = ints;
    }

    public IntArray(BigInteger bigInt) {
        this(bigInt, 0);
    }

    public IntArray(BigInteger bigInt, int minIntLen) {
        int barrI;
        int intLen;
        if (bigInt.signum() == -1) {
            throw new IllegalArgumentException("Only positive Integers allowed");
        }
        if (bigInt.equals(ECConstants.ZERO)) {
            this.m_ints = new int[]{0};
            return;
        }
        byte[] barr = bigInt.toByteArray();
        int barrLen = barr.length;
        int barrStart = 0;
        if (barr[0] == 0) {
            --barrLen;
            barrStart = 1;
        }
        this.m_ints = (intLen = (barrLen + 3) / 4) < minIntLen ? new int[minIntLen] : new int[intLen];
        int iarrJ = intLen - 1;
        int rem = barrLen % 4 + barrStart;
        int temp = 0;
        if (barrStart < rem) {
            for (barrI = barrStart; barrI < rem; ++barrI) {
                temp <<= 8;
                int barrBarrI = barr[barrI];
                if (barrBarrI < 0) {
                    barrBarrI += 256;
                }
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ--] = temp;
        }
        while (iarrJ >= 0) {
            temp = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                int barrBarrI;
                temp <<= 8;
                if ((barrBarrI = barr[barrI++]) < 0) {
                    barrBarrI += 256;
                }
                temp |= barrBarrI;
            }
            this.m_ints[iarrJ] = temp;
            --iarrJ;
        }
    }

    public boolean isZero() {
        return this.m_ints.length == 0 || this.m_ints[0] == 0 && this.getUsedLength() == 0;
    }

    public int getUsedLength() {
        int highestIntPos = this.m_ints.length;
        if (highestIntPos < 1) {
            return 0;
        }
        if (this.m_ints[0] != 0) {
            while (this.m_ints[--highestIntPos] == 0) {
            }
            return highestIntPos + 1;
        }
        do {
            if (this.m_ints[--highestIntPos] == 0) continue;
            return highestIntPos + 1;
        } while (highestIntPos > 0);
        return 0;
    }

    public int bitLength() {
        int intLen = this.getUsedLength();
        if (intLen == 0) {
            return 0;
        }
        int last = intLen - 1;
        int highest = this.m_ints[last];
        int bits = (last << 5) + 1;
        if ((highest & 0xFFFF0000) != 0) {
            if ((highest & 0xFF000000) != 0) {
                bits += 24;
                highest >>>= 24;
            } else {
                bits += 16;
                highest >>>= 16;
            }
        } else if (highest > 255) {
            bits += 8;
            highest >>>= 8;
        }
        while (highest != 1) {
            ++bits;
            highest >>>= 1;
        }
        return bits;
    }

    private int[] resizedInts(int newLen) {
        int[] newInts = new int[newLen];
        int oldLen = this.m_ints.length;
        int copyLen = oldLen < newLen ? oldLen : newLen;
        System.arraycopy(this.m_ints, 0, newInts, 0, copyLen);
        return newInts;
    }

    public BigInteger toBigInteger() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return ECConstants.ZERO;
        }
        int highestInt = this.m_ints[usedLen - 1];
        byte[] temp = new byte[4];
        int barrI = 0;
        boolean trailingZeroBytesDone = false;
        for (int j2 = 3; j2 >= 0; --j2) {
            byte thisByte = (byte)(highestInt >>> 8 * j2);
            if (!trailingZeroBytesDone && thisByte == 0) continue;
            trailingZeroBytesDone = true;
            temp[barrI++] = thisByte;
        }
        int barrLen = 4 * (usedLen - 1) + barrI;
        byte[] barr = new byte[barrLen];
        for (int j3 = 0; j3 < barrI; ++j3) {
            barr[j3] = temp[j3];
        }
        for (int iarrJ = usedLen - 2; iarrJ >= 0; --iarrJ) {
            for (int j4 = 3; j4 >= 0; --j4) {
                barr[barrI++] = (byte)(this.m_ints[iarrJ] >>> 8 * j4);
            }
        }
        return new BigInteger(1, barr);
    }

    public void shiftLeft() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return;
        }
        if (this.m_ints[usedLen - 1] < 0 && ++usedLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(this.m_ints.length + 1);
        }
        boolean carry = false;
        for (int i2 = 0; i2 < usedLen; ++i2) {
            boolean nextCarry = this.m_ints[i2] < 0;
            int n2 = i2;
            this.m_ints[n2] = this.m_ints[n2] << 1;
            if (carry) {
                int n3 = i2;
                this.m_ints[n3] = this.m_ints[n3] | 1;
            }
            carry = nextCarry;
        }
    }

    public IntArray shiftLeft(int n2) {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return this;
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 > 31) {
            throw new IllegalArgumentException("shiftLeft() for max 31 bits , " + n2 + "bit shift is not possible");
        }
        int[] newInts = new int[usedLen + 1];
        int nm32 = 32 - n2;
        newInts[0] = this.m_ints[0] << n2;
        for (int i2 = 1; i2 < usedLen; ++i2) {
            newInts[i2] = this.m_ints[i2] << n2 | this.m_ints[i2 - 1] >>> nm32;
        }
        newInts[usedLen] = this.m_ints[usedLen - 1] >>> nm32;
        return new IntArray(newInts);
    }

    public void addShifted(IntArray other, int shift) {
        int usedLenOther = other.getUsedLength();
        int newMinUsedLen = usedLenOther + shift;
        if (newMinUsedLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(newMinUsedLen);
        }
        for (int i2 = 0; i2 < usedLenOther; ++i2) {
            int n2 = i2 + shift;
            this.m_ints[n2] = this.m_ints[n2] ^ other.m_ints[i2];
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public boolean testBit(int n2) {
        int theInt = n2 >> 5;
        int theBit = n2 & 0x1F;
        int tester = 1 << theBit;
        return (this.m_ints[theInt] & tester) != 0;
    }

    public void flipBit(int n2) {
        int theInt = n2 >> 5;
        int theBit = n2 & 0x1F;
        int flipper = 1 << theBit;
        int n3 = theInt;
        this.m_ints[n3] = this.m_ints[n3] ^ flipper;
    }

    public void setBit(int n2) {
        int theInt = n2 >> 5;
        int theBit = n2 & 0x1F;
        int setter = 1 << theBit;
        int n3 = theInt;
        this.m_ints[n3] = this.m_ints[n3] | setter;
    }

    public IntArray multiply(IntArray other, int m2) {
        int t2 = m2 + 31 >> 5;
        if (this.m_ints.length < t2) {
            this.m_ints = this.resizedInts(t2);
        }
        IntArray b2 = new IntArray(other.resizedInts(other.getLength() + 1));
        IntArray c2 = new IntArray(m2 + m2 + 31 >> 5);
        int testBit = 1;
        for (int k2 = 0; k2 < 32; ++k2) {
            for (int j2 = 0; j2 < t2; ++j2) {
                if ((this.m_ints[j2] & testBit) == 0) continue;
                c2.addShifted(b2, j2);
            }
            testBit <<= 1;
            b2.shiftLeft();
        }
        return c2;
    }

    public void reduce(int m2, int[] redPol) {
        for (int i2 = m2 + m2 - 2; i2 >= m2; --i2) {
            if (!this.testBit(i2)) continue;
            int bit = i2 - m2;
            this.flipBit(bit);
            this.flipBit(i2);
            int l2 = redPol.length;
            while (--l2 >= 0) {
                this.flipBit(redPol[l2] + bit);
            }
        }
        this.m_ints = this.resizedInts(m2 + 31 >> 5);
    }

    public IntArray square(int m2) {
        int[] table = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85};
        int t2 = m2 + 31 >> 5;
        if (this.m_ints.length < t2) {
            this.m_ints = this.resizedInts(t2);
        }
        IntArray c2 = new IntArray(t2 + t2);
        for (int i2 = 0; i2 < t2; ++i2) {
            int v0 = 0;
            for (int j2 = 0; j2 < 4; ++j2) {
                v0 >>>= 8;
                int u2 = this.m_ints[i2] >>> j2 * 4 & 0xF;
                int w2 = table[u2] << 24;
                v0 |= w2;
            }
            c2.m_ints[i2 + i2] = v0;
            v0 = 0;
            int upper = this.m_ints[i2] >>> 16;
            for (int j3 = 0; j3 < 4; ++j3) {
                v0 >>>= 8;
                int u3 = upper >>> j3 * 4 & 0xF;
                int w3 = table[u3] << 24;
                v0 |= w3;
            }
            c2.m_ints[i2 + i2 + 1] = v0;
        }
        return c2;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)o2;
        int usedLen = this.getUsedLength();
        if (other.getUsedLength() != usedLen) {
            return false;
        }
        for (int i2 = 0; i2 < usedLen; ++i2) {
            if (this.m_ints[i2] == other.m_ints[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int usedLen = this.getUsedLength();
        int hash = 1;
        for (int i2 = 0; i2 < usedLen; ++i2) {
            hash = hash * 31 + this.m_ints[i2];
        }
        return hash;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(this.m_ints[usedLen - 1]));
        for (int iarrJ = usedLen - 2; iarrJ >= 0; --iarrJ) {
            String hexString = Integer.toBinaryString(this.m_ints[iarrJ]);
            for (int i2 = hexString.length(); i2 < 8; ++i2) {
                hexString = "0" + hexString;
            }
            sb.append(hexString);
        }
        return sb.toString();
    }
}

