/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            ECGenParameterSpec ecParams = (ECGenParameterSpec)ecParameters.get(new Integer(strength));
            if (ecParams != null) {
                try {
                    this.initialize(ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e2) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec p2 = (org.bouncycastle.jce.spec.ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p2.getCurve(), p2.getG(), p2.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECParameterSpec) {
                ECParameterSpec p3 = (ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p3.getCurve());
                ECPoint g2 = EC5Util.convertPoint(curve, p3.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g2, p3.getOrder(), BigInteger.valueOf(p3.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
                String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
                X9ECParameters ecP = X962NamedCurves.getByName(curveName);
                if (ecP == null) {
                    ecP = SECNamedCurves.getByName(curveName);
                    if (ecP == null) {
                        ecP = NISTNamedCurves.getByName(curveName);
                    }
                    if (ecP == null) {
                        ecP = TeleTrusTNamedCurves.getByName(curveName);
                    }
                    if (ecP == null) {
                        try {
                            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveName);
                            ecP = X962NamedCurves.getByOID(oid);
                            if (ecP == null) {
                                ecP = SECNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                ecP = NISTNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                ecP = TeleTrusTNamedCurves.getByOID(oid);
                            }
                            if (ecP == null) {
                                throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                        }
                    }
                }
                this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), null);
                ECParameterSpec p4 = (ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p4.getCurve());
                ECPoint g3 = EC5Util.convertPoint(curve, p4.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g3, p4.getOrder(), BigInteger.valueOf(p4.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && this.configuration.getEcImplicitlyCa() != null) {
                org.bouncycastle.jce.spec.ECParameterSpec p5 = this.configuration.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p5.getCurve(), p5.getG(), p5.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && this.configuration.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec p2 = (org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p2, this.configuration);
                return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p2, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, pub, this.configuration), new BCECPrivateKey(this.algorithm, priv, this.configuration));
            }
            ECParameterSpec p3 = (ECParameterSpec)this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p3, this.configuration);
            return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p3, this.configuration));
        }

        static {
            ecParameters.put(new Integer(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(new Integer(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(new Integer(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(new Integer(521), new ECGenParameterSpec("P-521"));
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }
}

