/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSABlindingParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest contentDigest;
    private Digest mgfDigest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int mgfhLen;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;
    private byte trailer;

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen) {
        this(cipher, digest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen) {
        this(cipher, contentDigest, mgfDigest, sLen, -68);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest digest, int sLen, byte trailer) {
        this(cipher, digest, digest, sLen, trailer);
    }

    public PSSSigner(AsymmetricBlockCipher cipher, Digest contentDigest, Digest mgfDigest, int sLen, byte trailer) {
        this.cipher = cipher;
        this.contentDigest = contentDigest;
        this.mgfDigest = mgfDigest;
        this.hLen = contentDigest.getDigestSize();
        this.mgfhLen = mgfDigest.getDigestSize();
        this.sLen = sLen;
        this.salt = new byte[sLen];
        this.mDash = new byte[8 + sLen + this.hLen];
        this.trailer = trailer;
    }

    public void init(boolean forSigning, CipherParameters param) {
        CipherParameters params;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p2 = (ParametersWithRandom)param;
            params = p2.getParameters();
            this.random = p2.getRandom();
        } else {
            params = param;
            if (forSigning) {
                this.random = new SecureRandom();
            }
        }
        this.cipher.init(forSigning, params);
        RSAKeyParameters kParam = params instanceof RSABlindingParameters ? ((RSABlindingParameters)params).getPublicKey() : (RSAKeyParameters)params;
        this.emBits = kParam.getModulus().bitLength() - 1;
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        this.block = new byte[(this.emBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] block) {
        for (int i2 = 0; i2 != block.length; ++i2) {
            block[i2] = 0;
        }
    }

    public void update(byte b2) {
        this.contentDigest.update(b2);
    }

    public void update(byte[] in, int off, int len) {
        this.contentDigest.update(in, off, len);
    }

    public void reset() {
        this.contentDigest.reset();
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        this.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (this.sLen != 0) {
            this.random.nextBytes(this.salt);
            System.arraycopy(this.salt, 0, this.mDash, this.mDash.length - this.sLen, this.sLen);
        }
        byte[] h2 = new byte[this.hLen];
        this.contentDigest.update(this.mDash, 0, this.mDash.length);
        this.contentDigest.doFinal(h2, 0);
        this.block[this.block.length - this.sLen - 1 - this.hLen - 1] = 1;
        System.arraycopy(this.salt, 0, this.block, this.block.length - this.sLen - this.hLen - 1, this.sLen);
        byte[] dbMask = this.maskGeneratorFunction1(h2, 0, h2.length, this.block.length - this.hLen - 1);
        for (int i2 = 0; i2 != dbMask.length; ++i2) {
            int n2 = i2;
            this.block[n2] = (byte)(this.block[n2] ^ dbMask[i2]);
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        System.arraycopy(h2, 0, this.block, this.block.length - this.hLen - 1, this.hLen);
        this.block[this.block.length - 1] = this.trailer;
        byte[] b2 = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.block);
        return b2;
    }

    public boolean verifySignature(byte[] signature) {
        int i2;
        this.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        try {
            byte[] b2 = this.cipher.processBlock(signature, 0, signature.length);
            System.arraycopy(b2, 0, this.block, this.block.length - b2.length, b2.length);
        }
        catch (Exception e2) {
            return false;
        }
        if (this.block[this.block.length - 1] != this.trailer) {
            this.clearBlock(this.block);
            return false;
        }
        byte[] dbMask = this.maskGeneratorFunction1(this.block, this.block.length - this.hLen - 1, this.hLen, this.block.length - this.hLen - 1);
        for (i2 = 0; i2 != dbMask.length; ++i2) {
            int n2 = i2;
            this.block[n2] = (byte)(this.block[n2] ^ dbMask[i2]);
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        for (i2 = 0; i2 != this.block.length - this.hLen - this.sLen - 2; ++i2) {
            if (this.block[i2] == 0) continue;
            this.clearBlock(this.block);
            return false;
        }
        if (this.block[this.block.length - this.hLen - this.sLen - 2] != 1) {
            this.clearBlock(this.block);
            return false;
        }
        System.arraycopy(this.block, this.block.length - this.sLen - this.hLen - 1, this.mDash, this.mDash.length - this.sLen, this.sLen);
        this.contentDigest.update(this.mDash, 0, this.mDash.length);
        this.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen);
        i2 = this.block.length - this.hLen - 1;
        for (int j2 = this.mDash.length - this.hLen; j2 != this.mDash.length; ++j2) {
            if ((this.block[i2] ^ this.mDash[j2]) != 0) {
                this.clearBlock(this.mDash);
                this.clearBlock(this.block);
                return false;
            }
            ++i2;
        }
        this.clearBlock(this.mDash);
        this.clearBlock(this.block);
        return true;
    }

    private void ItoOSP(int i2, byte[] sp) {
        sp[0] = (byte)(i2 >>> 24);
        sp[1] = (byte)(i2 >>> 16);
        sp[2] = (byte)(i2 >>> 8);
        sp[3] = (byte)(i2 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        int counter;
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgfhLen];
        byte[] C = new byte[4];
        this.mgfDigest.reset();
        for (counter = 0; counter < length / this.mgfhLen; ++counter) {
            this.ItoOSP(counter, C);
            this.mgfDigest.update(Z, zOff, zLen);
            this.mgfDigest.update(C, 0, C.length);
            this.mgfDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.mgfhLen, this.mgfhLen);
        }
        if (counter * this.mgfhLen < length) {
            this.ItoOSP(counter, C);
            this.mgfDigest.update(Z, zOff, zLen);
            this.mgfDigest.update(C, 0, C.length);
            this.mgfDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.mgfhLen, mask.length - counter * this.mgfhLen);
        }
        return mask;
    }
}

