/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.Digest;

public class DigestInputStream
extends FilterInputStream {
    protected Digest digest;

    public DigestInputStream(InputStream stream, Digest digest) {
        super(stream);
        this.digest = digest;
    }

    public int read() throws IOException {
        int b2 = this.in.read();
        if (b2 >= 0) {
            this.digest.update((byte)b2);
        }
        return b2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = this.in.read(b2, off, len);
        if (n2 > 0) {
            this.digest.update(b2, off, n2);
        }
        return n2;
    }

    public Digest getDigest() {
        return this.digest;
    }
}

