/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private int[] _S = new int[4];
    private int[] _sum0 = new int[32];
    private int[] _sum1 = new int[32];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "XTEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + params.getClass().getName());
        }
        this._forEncryption = forEncryption;
        this._initialised = true;
        KeyParameter p2 = (KeyParameter)params;
        this.setKey(p2.getKey());
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(in, inOff, out, outOff) : this.decryptBlock(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private void setKey(byte[] key) {
        int j2 = 0;
        int i2 = 0;
        while (i2 < 4) {
            this._S[i2] = this.bytesToInt(key, j2);
            ++i2;
            j2 += 4;
        }
        j2 = 0;
        for (i2 = 0; i2 < 32; ++i2) {
            this._sum0[i2] = j2 + this._S[j2 & 3];
            this._sum1[i2] = (j2 -= 1640531527) + this._S[j2 >>> 11 & 3];
        }
    }

    private int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int v0 = this.bytesToInt(in, inOff);
        int v1 = this.bytesToInt(in, inOff + 4);
        for (int i2 = 0; i2 < 32; ++i2) {
            v1 += ((v0 += (v1 << 4 ^ v1 >>> 5) + v1 ^ this._sum0[i2]) << 4 ^ v0 >>> 5) + v0 ^ this._sum1[i2];
        }
        this.unpackInt(v0, out, outOff);
        this.unpackInt(v1, out, outOff + 4);
        return 8;
    }

    private int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int v0 = this.bytesToInt(in, inOff);
        int v1 = this.bytesToInt(in, inOff + 4);
        for (int i2 = 31; i2 >= 0; --i2) {
            v0 -= ((v1 -= (v0 << 4 ^ v0 >>> 5) + v0 ^ this._sum1[i2]) << 4 ^ v1 >>> 5) + v1 ^ this._sum0[i2];
        }
        this.unpackInt(v0, out, outOff);
        this.unpackInt(v1, out, outOff + 4);
        return 8;
    }

    private int bytesToInt(byte[] in, int inOff) {
        return in[inOff++] << 24 | (in[inOff++] & 0xFF) << 16 | (in[inOff++] & 0xFF) << 8 | in[inOff] & 0xFF;
    }

    private void unpackInt(int v2, byte[] out, int outOff) {
        out[outOff++] = (byte)(v2 >>> 24);
        out[outOff++] = (byte)(v2 >>> 16);
        out[outOff++] = (byte)(v2 >>> 8);
        out[outOff] = (byte)v2;
    }
}

