/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher engine) {
        this.engine = new CBCBlockCipher(engine);
    }

    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p2 = (ParametersWithRandom)param;
            this.rand = p2.getRandom();
            this.param = (ParametersWithIV)p2.getParameters();
        } else {
            if (forWrapping) {
                this.rand = new SecureRandom();
            }
            this.param = (ParametersWithIV)param;
        }
    }

    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    public byte[] wrap(byte[] in, int inOff, int inLen) {
        int i2;
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.engine.init(true, this.param);
        int blockSize = this.engine.getBlockSize();
        byte[] cekBlock = inLen + 4 < blockSize * 2 ? new byte[blockSize * 2] : new byte[(inLen + 4) % blockSize == 0 ? inLen + 4 : ((inLen + 4) / blockSize + 1) * blockSize];
        cekBlock[0] = (byte)inLen;
        cekBlock[1] = ~in[inOff];
        cekBlock[2] = ~in[inOff + 1];
        cekBlock[3] = ~in[inOff + 2];
        System.arraycopy(in, inOff, cekBlock, 4, inLen);
        for (i2 = inLen + 4; i2 < cekBlock.length; ++i2) {
            cekBlock[i2] = (byte)this.rand.nextInt();
        }
        for (i2 = 0; i2 < cekBlock.length; i2 += blockSize) {
            this.engine.processBlock(cekBlock, i2, cekBlock, i2);
        }
        for (i2 = 0; i2 < cekBlock.length; i2 += blockSize) {
            this.engine.processBlock(cekBlock, i2, cekBlock, i2);
        }
        return cekBlock;
    }

    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int i2;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int blockSize = this.engine.getBlockSize();
        if (inLen < 2 * blockSize) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] cekBlock = new byte[inLen];
        byte[] iv = new byte[blockSize];
        System.arraycopy(in, inOff, cekBlock, 0, inLen);
        System.arraycopy(in, inOff, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        for (i2 = blockSize; i2 < cekBlock.length; i2 += blockSize) {
            this.engine.processBlock(cekBlock, i2, cekBlock, i2);
        }
        System.arraycopy(cekBlock, cekBlock.length - iv.length, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        this.engine.processBlock(cekBlock, 0, cekBlock, 0);
        this.engine.init(false, this.param);
        for (i2 = 0; i2 < cekBlock.length; i2 += blockSize) {
            this.engine.processBlock(cekBlock, i2, cekBlock, i2);
        }
        if ((cekBlock[0] & 0xFF) > cekBlock.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] key = new byte[cekBlock[0] & 0xFF];
        System.arraycopy(cekBlock, 4, key, 0, cekBlock[0]);
        int nonEqual = 0;
        for (int i3 = 0; i3 != 3; ++i3) {
            byte check = ~cekBlock[1 + i3];
            nonEqual |= check ^ key[i3];
        }
        if (nonEqual != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return key;
    }
}

