/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private static final int wordSize = 32;
    private static final int bytesPerWord = 4;
    private static final int _noRounds = 20;
    private int[] _S = null;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private static final int LGW = 5;
    private boolean forEncryption;

    public String getAlgorithmName() {
        return "RC6";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to RC6 init - " + params.getClass().getName());
        }
        KeyParameter p2 = (KeyParameter)params;
        this.forEncryption = forEncryption;
        this.setKey(p2.getKey());
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int blockSize = this.getBlockSize();
        if (this._S == null) {
            throw new IllegalStateException("RC6 engine not initialised");
        }
        if (inOff + blockSize > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + blockSize > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        return this.forEncryption ? this.encryptBlock(in, inOff, out, outOff) : this.decryptBlock(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private void setKey(byte[] key) {
        int i2;
        int c2 = (key.length + 3) / 4;
        if (c2 == 0) {
            c2 = 1;
        }
        int[] L = new int[(key.length + 4 - 1) / 4];
        for (i2 = key.length - 1; i2 >= 0; --i2) {
            L[i2 / 4] = (L[i2 / 4] << 8) + (key[i2] & 0xFF);
        }
        this._S = new int[44];
        this._S[0] = -1209970333;
        for (i2 = 1; i2 < this._S.length; ++i2) {
            this._S[i2] = this._S[i2 - 1] + -1640531527;
        }
        int iter = L.length > this._S.length ? 3 * L.length : 3 * this._S.length;
        int A = 0;
        int B = 0;
        int i3 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < iter; ++k2) {
            A = this._S[i3] = this.rotateLeft(this._S[i3] + A + B, 3);
            B = L[j2] = this.rotateLeft(L[j2] + A + B, A + B);
            i3 = (i3 + 1) % this._S.length;
            j2 = (j2 + 1) % L.length;
        }
    }

    private int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int A = this.bytesToWord(in, inOff);
        int B = this.bytesToWord(in, inOff + 4);
        int C = this.bytesToWord(in, inOff + 8);
        int D = this.bytesToWord(in, inOff + 12);
        B += this._S[0];
        D += this._S[1];
        for (int i2 = 1; i2 <= 20; ++i2) {
            int t2 = 0;
            int u2 = 0;
            t2 = B * (2 * B + 1);
            t2 = this.rotateLeft(t2, 5);
            u2 = D * (2 * D + 1);
            u2 = this.rotateLeft(u2, 5);
            A ^= t2;
            A = this.rotateLeft(A, u2);
            C ^= u2;
            C = this.rotateLeft(C, t2);
            int temp = A += this._S[2 * i2];
            A = B;
            B = C += this._S[2 * i2 + 1];
            C = D;
            D = temp;
        }
        this.wordToBytes(A += this._S[42], out, outOff);
        this.wordToBytes(B, out, outOff + 4);
        this.wordToBytes(C += this._S[43], out, outOff + 8);
        this.wordToBytes(D, out, outOff + 12);
        return 16;
    }

    private int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int A = this.bytesToWord(in, inOff);
        int B = this.bytesToWord(in, inOff + 4);
        int C = this.bytesToWord(in, inOff + 8);
        int D = this.bytesToWord(in, inOff + 12);
        C -= this._S[43];
        A -= this._S[42];
        for (int i2 = 20; i2 >= 1; --i2) {
            int t2 = 0;
            int u2 = 0;
            int temp = D;
            D = C;
            C = B;
            B = A;
            A = temp;
            t2 = B * (2 * B + 1);
            t2 = this.rotateLeft(t2, 5);
            u2 = D * (2 * D + 1);
            u2 = this.rotateLeft(u2, 5);
            C -= this._S[2 * i2 + 1];
            C = this.rotateRight(C, t2);
            C ^= u2;
            A -= this._S[2 * i2];
            A = this.rotateRight(A, u2);
            A ^= t2;
        }
        this.wordToBytes(A, out, outOff);
        this.wordToBytes(B -= this._S[0], out, outOff + 4);
        this.wordToBytes(C, out, outOff + 8);
        this.wordToBytes(D -= this._S[1], out, outOff + 12);
        return 16;
    }

    private int rotateLeft(int x2, int y) {
        return x2 << y | x2 >>> -y;
    }

    private int rotateRight(int x2, int y) {
        return x2 >>> y | x2 << -y;
    }

    private int bytesToWord(byte[] src, int srcOff) {
        int word = 0;
        for (int i2 = 3; i2 >= 0; --i2) {
            word = (word << 8) + (src[i2 + srcOff] & 0xFF);
        }
        return word;
    }

    private void wordToBytes(int word, byte[] dst, int dstOff) {
        for (int i2 = 0; i2 < 4; ++i2) {
            dst[i2 + dstOff] = (byte)word;
            word >>>= 8;
        }
    }
}

