/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;

public class NullEngine
implements BlockCipher {
    private boolean initialised;
    protected static final int BLOCK_SIZE = 1;

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Null";
    }

    public int getBlockSize() {
        return 1;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Null engine not initialised");
        }
        if (inOff + 1 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 1 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < 1; ++i2) {
            out[outOff + i2] = in[inOff + i2];
        }
        return 1;
    }

    public void reset() {
    }
}

