/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC128Engine
implements StreamCipher {
    private int[] p = new int[512];
    private int[] q = new int[512];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private static int f1(int x2) {
        return HC128Engine.rotateRight(x2, 7) ^ HC128Engine.rotateRight(x2, 18) ^ x2 >>> 3;
    }

    private static int f2(int x2) {
        return HC128Engine.rotateRight(x2, 17) ^ HC128Engine.rotateRight(x2, 19) ^ x2 >>> 10;
    }

    private int g1(int x2, int y, int z) {
        return (HC128Engine.rotateRight(x2, 10) ^ HC128Engine.rotateRight(z, 23)) + HC128Engine.rotateRight(y, 8);
    }

    private int g2(int x2, int y, int z) {
        return (HC128Engine.rotateLeft(x2, 10) ^ HC128Engine.rotateLeft(z, 23)) + HC128Engine.rotateLeft(y, 8);
    }

    private static int rotateLeft(int x2, int bits) {
        return x2 << bits | x2 >>> -bits;
    }

    private static int rotateRight(int x2, int bits) {
        return x2 >>> bits | x2 << -bits;
    }

    private int h1(int x2) {
        return this.q[x2 & 0xFF] + this.q[(x2 >> 16 & 0xFF) + 256];
    }

    private int h2(int x2) {
        return this.p[x2 & 0xFF] + this.p[(x2 >> 16 & 0xFF) + 256];
    }

    private static int mod1024(int x2) {
        return x2 & 0x3FF;
    }

    private static int mod512(int x2) {
        return x2 & 0x1FF;
    }

    private static int dim(int x2, int y) {
        return HC128Engine.mod512(x2 - y);
    }

    private int step() {
        int ret;
        int j2 = HC128Engine.mod512(this.cnt);
        if (this.cnt < 512) {
            int n2 = j2;
            this.p[n2] = this.p[n2] + this.g1(this.p[HC128Engine.dim(j2, 3)], this.p[HC128Engine.dim(j2, 10)], this.p[HC128Engine.dim(j2, 511)]);
            ret = this.h1(this.p[HC128Engine.dim(j2, 12)]) ^ this.p[j2];
        } else {
            int n3 = j2;
            this.q[n3] = this.q[n3] + this.g2(this.q[HC128Engine.dim(j2, 3)], this.q[HC128Engine.dim(j2, 10)], this.q[HC128Engine.dim(j2, 511)]);
            ret = this.h2(this.q[HC128Engine.dim(j2, 12)]) ^ this.q[j2];
        }
        this.cnt = HC128Engine.mod1024(this.cnt + 1);
        return ret;
    }

    private void init() {
        int i2;
        if (this.key.length != 16) {
            throw new IllegalArgumentException("The key must be 128 bits long");
        }
        this.cnt = 0;
        int[] w2 = new int[1280];
        for (i2 = 0; i2 < 16; ++i2) {
            int n2 = i2 >> 2;
            w2[n2] = w2[n2] | (this.key[i2] & 0xFF) << 8 * (i2 & 3);
        }
        System.arraycopy(w2, 0, w2, 4, 4);
        for (i2 = 0; i2 < this.iv.length && i2 < 16; ++i2) {
            int n3 = (i2 >> 2) + 8;
            w2[n3] = w2[n3] | (this.iv[i2] & 0xFF) << 8 * (i2 & 3);
        }
        System.arraycopy(w2, 8, w2, 12, 4);
        for (i2 = 16; i2 < 1280; ++i2) {
            w2[i2] = HC128Engine.f2(w2[i2 - 2]) + w2[i2 - 7] + HC128Engine.f1(w2[i2 - 15]) + w2[i2 - 16] + i2;
        }
        System.arraycopy(w2, 256, this.p, 0, 512);
        System.arraycopy(w2, 768, this.q, 0, 512);
        for (i2 = 0; i2 < 512; ++i2) {
            this.p[i2] = this.step();
        }
        for (i2 = 0; i2 < 512; ++i2) {
            this.q[i2] = this.step();
        }
        this.cnt = 0;
    }

    public String getAlgorithmName() {
        return "HC-128";
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters keyParam = params;
        if (params instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)params).getIV();
            keyParam = ((ParametersWithIV)params).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(keyParam instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC128 init - " + params.getClass().getName());
        }
        this.key = ((KeyParameter)keyParam).getKey();
        this.init();
        this.initialised = true;
    }

    private byte getByte() {
        if (this.idx == 0) {
            int step = this.step();
            this.buf[0] = (byte)(step & 0xFF);
            this.buf[1] = (byte)((step >>= 8) & 0xFF);
            this.buf[2] = (byte)((step >>= 8) & 0xFF);
            this.buf[3] = (byte)((step >>= 8) & 0xFF);
        }
        byte ret = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return ret;
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[outOff + i2] = (byte)(in[inOff + i2] ^ this.getByte());
        }
    }

    public void reset() {
        this.idx = 0;
        this.init();
    }

    public byte returnByte(byte in) {
        return (byte)(in ^ this.getByte());
    }
}

