/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509.qualified;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class SemanticsInformation
extends ASN1Object {
    private ASN1ObjectIdentifier semanticsIdentifier;
    private GeneralName[] nameRegistrationAuthorities;

    public static SemanticsInformation getInstance(Object obj) {
        if (obj instanceof SemanticsInformation) {
            return (SemanticsInformation)obj;
        }
        if (obj != null) {
            return new SemanticsInformation(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SemanticsInformation(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        if (seq.size() < 1) {
            throw new IllegalArgumentException("no objects in SemanticsInformation");
        }
        Object object = e2.nextElement();
        if (object instanceof ASN1ObjectIdentifier) {
            this.semanticsIdentifier = ASN1ObjectIdentifier.getInstance(object);
            object = e2.hasMoreElements() ? e2.nextElement() : null;
        }
        if (object != null) {
            ASN1Sequence generalNameSeq = ASN1Sequence.getInstance(object);
            this.nameRegistrationAuthorities = new GeneralName[generalNameSeq.size()];
            for (int i2 = 0; i2 < generalNameSeq.size(); ++i2) {
                this.nameRegistrationAuthorities[i2] = GeneralName.getInstance(generalNameSeq.getObjectAt(i2));
            }
        }
    }

    public SemanticsInformation(ASN1ObjectIdentifier semanticsIdentifier, GeneralName[] generalNames) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = generalNames;
    }

    public SemanticsInformation(ASN1ObjectIdentifier semanticsIdentifier) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = null;
    }

    public SemanticsInformation(GeneralName[] generalNames) {
        this.semanticsIdentifier = null;
        this.nameRegistrationAuthorities = generalNames;
    }

    public ASN1ObjectIdentifier getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return this.nameRegistrationAuthorities;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        if (this.semanticsIdentifier != null) {
            seq.add(this.semanticsIdentifier);
        }
        if (this.nameRegistrationAuthorities != null) {
            ASN1EncodableVector seqname = new ASN1EncodableVector();
            for (int i2 = 0; i2 < this.nameRegistrationAuthorities.length; ++i2) {
                seqname.add(this.nameRegistrationAuthorities[i2]);
            }
            seq.add(new DERSequence(seqname));
        }
        return new DERSequence(seq);
    }
}

